/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.sv.svconfigurator.processor;

import com.microfocus.sv.svconfigurator.core.IService;
import com.microfocus.sv.svconfigurator.core.impl.exception.CommandExecutorException;
import com.microfocus.sv.svconfigurator.core.impl.exception.CommunicatorException;
import com.microfocus.sv.svconfigurator.core.impl.jaxb.ServiceRuntimeConfiguration;
import com.microfocus.sv.svconfigurator.core.impl.jaxb.ServiceRuntimeReport;
import com.microfocus.sv.svconfigurator.processor.IViewProcessor;
import com.microfocus.sv.svconfigurator.processor.ViewProcessorInput;
import com.microfocus.sv.svconfigurator.processor.printer.IPrinter;
import com.microfocus.sv.svconfigurator.processor.printer.PrinterFactory;
import com.microfocus.sv.svconfigurator.serverclient.ICommandExecutor;
import com.microfocus.sv.svconfigurator.serverclient.ICommandExecutorFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ViewProcessor
implements IViewProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(ViewProcessor.class);
    private ICommandExecutorFactory commandExecutorFactory;

    public ViewProcessor(ICommandExecutorFactory commandExecutorFactory) {
        this.commandExecutorFactory = commandExecutorFactory;
    }

    @Override
    public ICommandExecutorFactory getCommandExecutorFactory() {
        return this.commandExecutorFactory;
    }

    @Override
    public void process(ViewProcessorInput input, ICommandExecutor exec) throws CommunicatorException, CommandExecutorException {
        String svcStr = input.getService();
        if (svcStr == null) {
            throw new CommandExecutorException("Service have to be specified");
        }
        IService svc = exec.findService(svcStr, input.getProject());
        this.processInfo(exec, svc, input.isDetail(), input.getOutputFormat());
    }

    private void processInfo(ICommandExecutor exec, IService svc, boolean showDetail, String outputFormat) throws CommunicatorException, CommandExecutorException {
        IPrinter printer = PrinterFactory.create(outputFormat);
        ServiceRuntimeConfiguration conf = exec.getServiceRuntimeInfo(svc);
        ServiceRuntimeReport report = showDetail ? exec.getServiceRuntimeReport(svc) : null;
        LOG.info(printer.createServiceInfoOutput(svc, conf, report));
    }
}

