/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.sv.svconfigurator.processor;

import com.microfocus.sv.svconfigurator.build.IProjectBuilder;
import com.microfocus.sv.svconfigurator.build.parser.AbstractXMLElementParser;
import com.microfocus.sv.svconfigurator.build.parser.DataModelElementParser;
import com.microfocus.sv.svconfigurator.build.parser.DataSetElementParser;
import com.microfocus.sv.svconfigurator.build.parser.ManifestElementParser;
import com.microfocus.sv.svconfigurator.build.parser.PerfModelElementParser;
import com.microfocus.sv.svconfigurator.build.parser.ServiceDescriptionElementParser;
import com.microfocus.sv.svconfigurator.build.parser.ServiceElementParser;
import com.microfocus.sv.svconfigurator.core.IDataModel;
import com.microfocus.sv.svconfigurator.core.IDataSet;
import com.microfocus.sv.svconfigurator.core.IPerfModel;
import com.microfocus.sv.svconfigurator.core.IProject;
import com.microfocus.sv.svconfigurator.core.IProjectElement;
import com.microfocus.sv.svconfigurator.core.IProjectElementDataSource;
import com.microfocus.sv.svconfigurator.core.IService;
import com.microfocus.sv.svconfigurator.core.IServiceDescription;
import com.microfocus.sv.svconfigurator.core.impl.datasource.InMemoryProjectElementDataSource;
import com.microfocus.sv.svconfigurator.core.impl.exception.AbstractSVCException;
import com.microfocus.sv.svconfigurator.core.impl.exception.CommandExecutorException;
import com.microfocus.sv.svconfigurator.core.impl.jaxb.ServiceRuntimeConfiguration;
import com.microfocus.sv.svconfigurator.serverclient.ICommandExecutor;
import com.microfocus.sv.svconfigurator.serverclient.ICommandExecutorFactory;
import com.microfocus.sv.svconfigurator.util.ProjectUtils;
import com.microfocus.sv.svconfigurator.util.XmlUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class UpdateProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(UpdateProcessor.class);
    private final ICommandExecutorFactory commandExecutorFactory;
    private final IProjectBuilder projectBuilder;
    private final PerfModelElementParser pmParser;
    private final DataModelElementParser dmParser;
    private final DataSetElementParser dsParser;
    private final ManifestElementParser manifestParser;
    private final ServiceDescriptionElementParser sdParser;
    private final ServiceElementParser vsParser;
    private final Pattern numberResolver = Pattern.compile("^.* ([0-9]{3})\\.vsdataset$");
    private final Pattern unsafeCharacters = Pattern.compile("[/?<>\\:*|\"^]");

    public UpdateProcessor(IProjectBuilder projectBuilder, ICommandExecutorFactory commandExecutorFactory) {
        this.commandExecutorFactory = commandExecutorFactory;
        this.projectBuilder = projectBuilder;
        this.pmParser = new PerfModelElementParser();
        this.dmParser = new DataModelElementParser();
        this.dsParser = new DataSetElementParser();
        this.manifestParser = new ManifestElementParser();
        this.sdParser = new ServiceDescriptionElementParser();
        this.vsParser = new ServiceElementParser();
    }

    public void process(ICommandExecutor exec, String projectPath, String projectPassword, IProject project, String service) throws AbstractSVCException {
        byte[] data;
        if (project == null) {
            throw new CommandExecutorException("You have to specify the project.");
        }
        IService svc = ProjectUtils.findProjElem(project.getServices(), service, "Virtual service");
        ServiceRuntimeConfiguration config = exec.getServiceRuntimeInfo(svc);
        if (config == null) {
            throw new CommandExecutorException("Cannot find the service [" + service + "] on the server.");
        }
        if (config.getRuntimeMode() != ServiceRuntimeConfiguration.RuntimeMode.STAND_BY && config.getRuntimeMode() != ServiceRuntimeConfiguration.RuntimeMode.SIMULATING) {
            throw new CommandExecutorException("Service [" + service + "] must be in the STAND_BY or SIMULATING mode.");
        }
        File projectRoot = new File(projectPath).getParentFile();
        Collection<IProjectElementDataSource> dataSources = this.projectBuilder.getDataSources(new File(projectPath), projectPassword);
        if (svc.getPerfModels() != null) {
            for (IPerfModel pm : svc.getPerfModels()) {
                data = exec.getClient().fetchPerformanceModel(svc.getId(), pm.getId());
                String pmFile = UpdateProcessor.getName(dataSources, pm.getId(), projectPassword, this.pmParser);
                if (pmFile == null) {
                    throw new CommandExecutorException("Failed to find the selected performance model file [ID=" + pm.getId() + "]");
                }
                UpdateProcessor.persistFile(projectRoot, pmFile, data);
            }
        }
        if (svc.getDataModels() != null) {
            for (IDataModel dm : svc.getDataModels()) {
                data = exec.getClient().fetchDataModel(svc.getId(), dm.getId());
                String dmFile = UpdateProcessor.getName(dataSources, dm.getId(), projectPassword, this.dmParser);
                if (dmFile == null) {
                    throw new CommandExecutorException("Failed to find the selected data model file [ID=" + dm.getId() + "]");
                }
                UpdateProcessor.persistFile(projectRoot, dmFile, data);
                Collection<String> datasetIds = exec.getClient().getDataSetIds(svc.getId(), dm.getId());
                ArrayList<String> foundDsNames = new ArrayList<String>();
                ArrayList<String> addedIds = new ArrayList<String>();
                for (String string : datasetIds) {
                    String dsFile = UpdateProcessor.getName(dataSources, string, projectPassword, this.dsParser);
                    if (dsFile == null) {
                        addedIds.add(string);
                        LOG.trace("DS not found: " + string);
                        continue;
                    }
                    data = exec.getClient().fetchDataSet(svc.getId(), dm.getId(), string);
                    foundDsNames.add(dsFile);
                    UpdateProcessor.persistFile(projectRoot, dsFile, data);
                }
                if (addedIds.isEmpty()) continue;
                HashMap<String, IDataSet> notFoundDsIds = new HashMap<String, IDataSet>();
                for (String dsId3 : addedIds) {
                    data = exec.getClient().fetchDataSet(svc.getId(), dm.getId(), dsId3);
                    String nextDsFile = this.findNextName(foundDsNames, projectRoot, dm);
                    IDataSet ds = (IDataSet)this.dsParser.create(new InMemoryProjectElementDataSource(data, "DS.vsdataset"), null);
                    notFoundDsIds.put(nextDsFile, ds);
                    UpdateProcessor.persistFile(projectRoot, nextDsFile, data);
                }
                this.addFiles(projectPath, notFoundDsIds.keySet());
                String string = UpdateProcessor.getName(dataSources, "manifest_" + svc.getId(), projectPassword, this.manifestParser);
                if (string == null) {
                    throw new CommandExecutorException("Failed to find the manifest file of the service '" + svc.getId() + "'");
                }
                this.addManifestItems(projectRoot, string, notFoundDsIds.values(), dm.getId());
            }
        }
        if (svc.getDescriptions() != null) {
            for (IServiceDescription sd : svc.getDescriptions()) {
                data = exec.getClient().fetchServiceDescription(svc.getId(), sd.getId());
                String sdFile = UpdateProcessor.getName(dataSources, sd.getId(), projectPassword, this.sdParser);
                if (sdFile == null) {
                    throw new CommandExecutorException("Failed to find the service description file [ID=" + sd.getId() + "]");
                }
                UpdateProcessor.persistFile(projectRoot, sdFile, data);
            }
        }
        byte[] data2 = exec.getClient().fetchVirtualService(svc.getId());
        String vsFile = UpdateProcessor.getName(dataSources, svc.getId(), projectPassword, this.vsParser);
        if (vsFile == null) {
            throw new CommandExecutorException("Failed to find the virtual service file [ID=" + svc.getId() + "]");
        }
        UpdateProcessor.persistFile(projectRoot, vsFile, data2);
    }

    private void addManifestItems(File projectRoot, String manifestFile, Collection<IDataSet> values, String dmId) throws CommandExecutorException {
        File manifestPath = new File(projectRoot, manifestFile);
        Document doc = UpdateProcessor.loadXml(manifestPath);
        Element root = doc.getDocumentElement();
        if (root == null) {
            throw new CommandExecutorException("Failed to find root element of the manifest file");
        }
        NodeList items = root.getElementsByTagName("Item");
        if (items == null || items.getLength() < 1) {
            throw new CommandExecutorException("Failed to find Item element of the manifest file");
        }
        Element dmElement = null;
        for (int i = 0; i < items.getLength(); ++i) {
            Node item = items.item(i);
            if (!(item instanceof Element)) continue;
            Element elementItem = (Element)item;
            String type = elementItem.getAttribute("type");
            String id = elementItem.getAttribute("id");
            if (!"DataModel".equals(type) || !dmId.equals(id)) continue;
            dmElement = elementItem;
        }
        if (dmElement == null) {
            throw new CommandExecutorException("Failed to find data model Item element of the manifest file");
        }
        try {
            Element references = (Element)dmElement.getElementsByTagName("References").item(0);
            for (IDataSet ds : values) {
                Element item = doc.createElement("Ref");
                item.setAttribute("id", ds.getId());
                references.appendChild(item);
            }
        }
        catch (Exception e) {
            throw new CommandExecutorException("Failed to find data model References element of the manifest file");
        }
        for (IDataSet ds : values) {
            Element item = doc.createElement("Item");
            item.setAttribute("id", ds.getId());
            item.setAttribute("type", "Dataset");
            item.setAttribute("contentHashcode", Long.toString(ds.getDataHashCode()));
            Element references = doc.createElement("References");
            item.appendChild(references);
            root.appendChild(item);
        }
        UpdateProcessor.saveXml(manifestPath, doc);
    }

    private void addFiles(String projectPath, Set<String> keySet) throws CommandExecutorException {
        File projectFile = new File(projectPath);
        Document doc = UpdateProcessor.loadXml(projectFile);
        Element root = doc.getDocumentElement();
        if (root == null) {
            throw new CommandExecutorException("Failed to find root element of the project file");
        }
        NodeList items = root.getElementsByTagName("ItemGroup");
        if (items == null || items.getLength() != 1) {
            throw new CommandExecutorException("Failed to find ItemGroup element of the project file");
        }
        Node itemsGroup = items.item(0);
        for (String path : keySet) {
            Element item = doc.createElement("None");
            item.setAttribute("Include", ProjectUtils.encodeInclude(path));
            itemsGroup.appendChild(item);
        }
        UpdateProcessor.saveXml(projectFile, doc);
    }

    private String findNextName(List<String> foundDsNames, File projectRoot, IDataModel dm) {
        String name;
        int max = -2;
        String baseName = null;
        for (String name2 : foundDsNames) {
            try {
                Matcher m = this.numberResolver.matcher(name2);
                if (m.matches()) {
                    max = Math.max(Integer.parseInt(m.group(1), 10), max);
                    baseName = name2.substring(0, name2.length() - ".vsdataset".length() - 4);
                    continue;
                }
                max = Math.max(-1, max);
                baseName = name2.substring(0, name2.length() - ".vsdataset".length());
            }
            catch (Exception e) {
                LOG.warn("Failed to detect a dataset name", (Throwable)e);
            }
        }
        do {
            name = ++max == -1 ? this.unsafeCharacters.matcher(dm.getName()).replaceAll("_") + " Dataset" + ".vsdataset" : (baseName == null ? this.unsafeCharacters.matcher(dm.getName()).replaceAll("_") + String.format(" Dataset %03d", max) + ".vsdataset" : baseName + String.format(" %03d", max) + ".vsdataset");
            foundDsNames.add(name);
        } while (new File(projectRoot, name).exists());
        LOG.trace("Detected dataset name: " + name);
        return name;
    }

    private static String getName(Collection<IProjectElementDataSource> dataSources, String id, String projectPassword, AbstractXMLElementParser parser) throws AbstractSVCException {
        String file = null;
        for (IProjectElementDataSource ds : dataSources) {
            IProjectElement pm;
            if (!parser.isParserForDataSource(ds) || !(pm = parser.create(ds, projectPassword)).getId().equals(id)) continue;
            file = ds.getName();
            break;
        }
        return file;
    }

    private static void persistFile(File projectRoot, String file, byte[] data) throws CommandExecutorException {
        FileOutputStream fos;
        block5: {
            File f = new File(projectRoot, file);
            fos = null;
            try {
                boolean exists = f.exists();
                fos = new FileOutputStream(f, false);
                fos.write(data);
                if (exists) {
                    LOG.info("Updated the file: " + f);
                    break block5;
                }
                LOG.info("Created the file: " + f);
            }
            catch (Exception e) {
                try {
                    throw new CommandExecutorException("Failed to update the file '" + f + "'", e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(fos);
                    throw throwable;
                }
            }
        }
        IOUtils.closeQuietly((OutputStream)fos);
    }

    private static Document loadXml(File f) throws CommandExecutorException {
        Document document;
        FileInputStream fis = null;
        try {
            Document doc;
            fis = new FileInputStream(f);
            document = doc = XmlUtils.createDoc(fis);
        }
        catch (Exception e) {
            try {
                throw new CommandExecutorException("Failed to open the file '" + f + "'", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fis);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)fis);
        return document;
    }

    private static void saveXml(File f, Document doc) throws CommandExecutorException {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(f, false);
            XmlUtils.writeDoc(fos, doc);
        }
        catch (Exception e) {
            try {
                throw new CommandExecutorException("Failed to save the file '" + f + "'", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fos);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)fos);
        LOG.info("Updated the file: " + f);
    }

    public ICommandExecutorFactory getCommandExecutorFactory() {
        return this.commandExecutorFactory;
    }
}

