/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.sv.svconfigurator.core.impl.datasource;

import com.microfocus.sv.svconfigurator.core.IProjectElementDataSource;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Base64;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ContentFileElementDataSource
implements IProjectElementDataSource {
    public static final String CONTENTFILE_ROOT_ELEMENT_NAME = "contentFile";
    public static final String NAMESPACE = "http://hp.com/SOAQ/ServiceVirtualization/2010/";
    private IProjectElementDataSource rawDataSource;
    private Map<String, String> metadata;
    private byte[] data;

    private static byte[] generateDataRepresentation(Map<String, String> metadata, InputStream rawFileContentStream, long rawFileContentLength) throws ParserConfigurationException, IOException, TransformerException {
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
        Document doc = docBuilder.newDocument();
        Element rootElement = doc.createElementNS(NAMESPACE, CONTENTFILE_ROOT_ELEMENT_NAME);
        doc.appendChild(rootElement);
        for (Map.Entry<String, String> entry : metadata.entrySet()) {
            Attr attr = doc.createAttribute(entry.getKey());
            attr.setValue(entry.getValue());
            rootElement.setAttributeNode(attr);
        }
        byte[] rawContentBytes = new byte[(int)rawFileContentLength];
        rawFileContentStream.read(rawContentBytes, 0, rawContentBytes.length);
        rawFileContentStream.close();
        String rawContentBase64 = Base64.getEncoder().encodeToString(rawContentBytes);
        rootElement.setTextContent(rawContentBase64);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        DOMSource source = new DOMSource(doc);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        StreamResult result = new StreamResult(bos);
        transformer.transform(source, result);
        byte[] resultBytes = bos.toByteArray();
        bos.close();
        return resultBytes;
    }

    public ContentFileElementDataSource(IProjectElementDataSource rawDataSource, Map<String, String> metadata) throws IOException, TransformerException, ParserConfigurationException {
        this.rawDataSource = rawDataSource;
        this.metadata = metadata;
        this.data = ContentFileElementDataSource.generateDataRepresentation(metadata, rawDataSource.getData(), rawDataSource.getDataSize());
    }

    @Override
    public long getDataSize() {
        return this.data.length;
    }

    @Override
    public InputStream getData() {
        return new ByteArrayInputStream(this.data);
    }

    @Override
    public String getName() {
        return this.rawDataSource.getName();
    }

    @Override
    public void close() {
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ContentFileElementDataSource)) {
            return false;
        }
        ContentFileElementDataSource that = (ContentFileElementDataSource)o;
        return !(this.data != null ? !this.data.equals(that.data) : that.data != null);
    }

    public int hashCode() {
        return this.rawDataSource != null ? this.rawDataSource.hashCode() : 0;
    }
}

