/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.sv.svconfigurator.core.impl;

import com.microfocus.sv.svconfigurator.core.IContentFile;
import com.microfocus.sv.svconfigurator.core.IDataModel;
import com.microfocus.sv.svconfigurator.core.ILoggedServiceCallList;
import com.microfocus.sv.svconfigurator.core.IPerfModel;
import com.microfocus.sv.svconfigurator.core.IProject;
import com.microfocus.sv.svconfigurator.core.IProjectElementDataSource;
import com.microfocus.sv.svconfigurator.core.IProjectElementVisitor;
import com.microfocus.sv.svconfigurator.core.IService;
import com.microfocus.sv.svconfigurator.core.IServiceDescription;
import com.microfocus.sv.svconfigurator.core.impl.exception.SVCParseException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;

public class ServiceDataDecorator
implements IService {
    private final IService service;
    private final IProjectElementDataSource ds;

    public ServiceDataDecorator(IService service, IProjectElementDataSource ds) {
        this.service = service;
        this.ds = ds;
    }

    public String toString() {
        return this.service.toString();
    }

    @Override
    public String getId() {
        return this.service.getId();
    }

    @Override
    public String getName() {
        return this.service.getName();
    }

    @Override
    public InputStream getData() throws IOException, SVCParseException {
        return this.ds.getData();
    }

    @Override
    public long getDataLength() throws IOException, SVCParseException {
        return this.ds.getDataSize();
    }

    @Override
    public void accept(IProjectElementVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void close() throws IOException {
        this.ds.close();
        this.service.close();
    }

    @Override
    public Collection<IDataModel> getDataModels() {
        return this.service.getDataModels();
    }

    @Override
    public Collection<IPerfModel> getPerfModels() {
        return this.service.getPerfModels();
    }

    @Override
    public Collection<IServiceDescription> getDescriptions() {
        return this.service.getDescriptions();
    }

    @Override
    public Collection<IContentFile> getContentFiles() {
        return this.service.getContentFiles();
    }

    @Override
    public Collection<ILoggedServiceCallList> getLoggedServiceCallLists() {
        return this.service.getLoggedServiceCallLists();
    }

    @Override
    public IProject getBaseProject() {
        return this.service.getBaseProject();
    }

    @Override
    public void addDataModel(IDataModel dm) {
        this.service.addDataModel(dm);
    }

    @Override
    public void addPerfModel(IPerfModel pm) {
        this.service.addPerfModel(pm);
    }

    @Override
    public void setBaseProject(IProject baseProject) {
        this.service.setBaseProject(baseProject);
    }

    @Override
    public void addDescription(IServiceDescription sd) {
        this.service.addDescription(sd);
    }

    @Override
    public void addContentFile(IContentFile cf) {
        this.service.addContentFile(cf);
    }

    @Override
    public void addLoggedServiceCallList(ILoggedServiceCallList loggedServiceCallList) {
        this.service.addLoggedServiceCallList(loggedServiceCallList);
    }

    @Override
    public String getRuntimeIssues() {
        return this.service.getRuntimeIssues();
    }

    @Override
    public boolean NonExistentRealService() {
        return this.service.NonExistentRealService();
    }
}

