/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.sv.svconfigurator.cli.impl;

import com.microfocus.sv.svconfigurator.build.IProjectBuilder;
import com.microfocus.sv.svconfigurator.cli.ICLICommandProcessor;
import com.microfocus.sv.svconfigurator.cli.impl.AbstractProjectCommandProcessor;
import com.microfocus.sv.svconfigurator.core.IProject;
import com.microfocus.sv.svconfigurator.core.impl.Server;
import com.microfocus.sv.svconfigurator.core.impl.exception.AbstractSVCException;
import com.microfocus.sv.svconfigurator.core.impl.exception.CommunicatorException;
import com.microfocus.sv.svconfigurator.core.impl.exception.ProjectBuilderException;
import com.microfocus.sv.svconfigurator.core.server.IServerCommandRunner;
import com.microfocus.sv.svconfigurator.core.server.ServersCommandExecutor;
import com.microfocus.sv.svconfigurator.processor.UpdateProcessor;
import com.microfocus.sv.svconfigurator.serverclient.ICommandExecutor;
import com.microfocus.sv.svconfigurator.util.CliUtils;
import java.util.List;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateCommandProcessor
extends AbstractProjectCommandProcessor
implements ICLICommandProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(UpdateCommandProcessor.class);
    public static final String COMMAND = "update";
    private static final String PARAM_SERVICE = "s";
    private static final String LONG_PARAM_SERVICE = "service";
    private static final String MANDAT_PROP_PROJ = "project_file";
    private static final String HELP_USAGE = "update [parameters] <project_file>";
    private final Options opts;
    private final UpdateProcessor updateProcessor;

    public UpdateCommandProcessor(IProjectBuilder projectBuilder, UpdateProcessor proc) {
        super(projectBuilder);
        this.updateProcessor = proc;
        this.opts = this.createParamOptions();
    }

    @Override
    public int process(String[] args) {
        BasicParser parser = new BasicParser();
        try {
            CommandLine line = parser.parse(this.opts, args);
            final String projectPath = this.getProjectPath(line);
            if (projectPath == null) {
                throw new ParseException("You have to specify the project.");
            }
            final String projectPassword = this.getProjectPassword(line);
            final IProject proj = this.getProject(projectPath, projectPassword);
            if (proj == null) {
                throw new ParseException("You have to specify the project.");
            }
            List<Server> servers = CliUtils.obtainServers(line, null, true);
            if (!line.hasOption(PARAM_SERVICE)) {
                throw new ParseException("You must specify a service that will be updated.");
            }
            final String service = line.getOptionValue(PARAM_SERVICE);
            ServersCommandExecutor executor = new ServersCommandExecutor(servers, this.updateProcessor.getCommandExecutorFactory());
            executor.execute(new IServerCommandRunner(){

                @Override
                public void runCommand(ICommandExecutor executor) throws AbstractSVCException {
                    UpdateCommandProcessor.this.updateProcessor.process(executor, projectPath, projectPassword, proj, service);
                }
            });
        }
        catch (ParseException e) {
            LOG.error(e.getLocalizedMessage(), (Throwable)e);
            CliUtils.printHelp(HELP_USAGE, this.opts, this.createMandatParamOptions());
            return 1000;
        }
        catch (ProjectBuilderException e) {
            LOG.error(e.getLocalizedMessage(), (Throwable)e);
            return 1100;
        }
        catch (CommunicatorException e) {
            LOG.error(e.getLocalizedMessage(), (Throwable)e);
            return 1200;
        }
        catch (AbstractSVCException e) {
            LOG.error(e.getLocalizedMessage(), (Throwable)e);
            return 1300;
        }
        return 0;
    }

    @Override
    protected IProject getProject(String filePath, String password) throws ProjectBuilderException {
        if (!filePath.endsWith(".vproj")) {
            throw new ProjectBuilderException("Cannot update SV project archive. Only unpacked project archives can be updated.");
        }
        return super.getProject(filePath, password);
    }

    private Options createParamOptions() {
        Options opts = new Options();
        CliUtils.addConnectionOptions(opts);
        opts.addOption(PARAM_SERVICE, LONG_PARAM_SERVICE, true, "A service that will be updated (id or name).");
        opts.addOption("w", "project-password", true, "Project encryption password");
        return opts;
    }

    private Options createMandatParamOptions() {
        Options opts = new Options();
        opts.addOption(MANDAT_PROP_PROJ, false, "Project file (.vproj) for the update.");
        return opts;
    }
}

