/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.sv.svconfigurator.cli.impl;

import com.microfocus.sv.svconfigurator.build.IProjectBuilder;
import com.microfocus.sv.svconfigurator.cli.impl.AbstractProjectCommandProcessor;
import com.microfocus.sv.svconfigurator.core.IProject;
import com.microfocus.sv.svconfigurator.core.impl.Server;
import com.microfocus.sv.svconfigurator.core.impl.exception.AbstractSVCException;
import com.microfocus.sv.svconfigurator.core.impl.exception.CommandExecutorException;
import com.microfocus.sv.svconfigurator.core.impl.exception.CommunicatorException;
import com.microfocus.sv.svconfigurator.core.impl.exception.ProjectBuilderException;
import com.microfocus.sv.svconfigurator.core.impl.exception.SVCParseException;
import com.microfocus.sv.svconfigurator.core.server.IServerCommandRunner;
import com.microfocus.sv.svconfigurator.core.server.ServersCommandExecutor;
import com.microfocus.sv.svconfigurator.processor.IUnlockProcessor;
import com.microfocus.sv.svconfigurator.processor.UnlockProcessorInput;
import com.microfocus.sv.svconfigurator.serverclient.ICommandExecutor;
import com.microfocus.sv.svconfigurator.util.CliUtils;
import java.util.List;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnlockCLICommandCliProcessor
extends AbstractProjectCommandProcessor {
    public static final String COMMAND = "unlock";
    private static final String PROP_LOCK = "l";
    private static final String LONG_PROP_LOCK = "lock";
    private static final String MAND_PROP_SERVICE = "service";
    private static final String HELP_USAGE = "unlock [parameters] <service>";
    private static final Logger LOG = LoggerFactory.getLogger(UnlockCLICommandCliProcessor.class);
    private IUnlockProcessor processor;
    private Options opts;

    public UnlockCLICommandCliProcessor(IProjectBuilder projectBuilder, IUnlockProcessor processor) {
        super(projectBuilder);
        this.processor = processor;
        this.opts = this.createPropsOptions();
    }

    @Override
    public int process(String[] args) {
        BasicParser parser = new BasicParser();
        try {
            CommandLine line = parser.parse(this.opts, args);
            String[] lineArgs = line.getArgs();
            if (lineArgs.length != 1) {
                throw new ParseException("There should be one mandatory parameter. Please, take a look into the help.");
            }
            IProject proj = null;
            if (line.hasOption("p")) {
                String projPass = line.hasOption("w") ? line.getOptionValue("w") : null;
                proj = this.getProject(line.getOptionValue("p"), projPass);
            }
            List<Server> servers = CliUtils.obtainServers(line, proj);
            final UnlockProcessorInput input = new UnlockProcessorInput(line.hasOption(PROP_LOCK), proj, lineArgs[0]);
            ServersCommandExecutor executor = new ServersCommandExecutor(servers, this.processor.getCommandExecutorFactory());
            executor.execute(new IServerCommandRunner(){

                @Override
                public void runCommand(ICommandExecutor executor) throws AbstractSVCException {
                    UnlockCLICommandCliProcessor.this.processor.process(input, executor);
                }
            });
            LOG.info("Service lock change successful.");
        }
        catch (ParseException e) {
            LOG.error(e.getLocalizedMessage(), (Throwable)e);
            CliUtils.printHelp(HELP_USAGE, this.opts, this.createMandPropsOptions());
            return 1000;
        }
        catch (SVCParseException e) {
            LOG.error(e.getLocalizedMessage(), (Throwable)e);
            CliUtils.printHelp(HELP_USAGE, this.opts, this.createMandPropsOptions());
            return 1000;
        }
        catch (CommunicatorException e) {
            LOG.error(e.getLocalizedMessage(), (Throwable)e);
            return 1200;
        }
        catch (CommandExecutorException e) {
            LOG.error(e.getLocalizedMessage(), (Throwable)e);
            return 1300;
        }
        catch (ProjectBuilderException e) {
            LOG.error(e.getLocalizedMessage(), (Throwable)e);
            return 1100;
        }
        catch (AbstractSVCException e) {
            LOG.error(e.getLocalizedMessage(), (Throwable)e);
            return 1500;
        }
        return 0;
    }

    private Options createPropsOptions() {
        Options opts = new Options();
        CliUtils.addConnectionOptions(opts);
        opts.addOption(PROP_LOCK, LONG_PROP_LOCK, false, "Locks the service with your ID after the unlock.");
        opts.addOption("p", "project", true, "Processes the project file (.vproja or .vproj). You have to specify the project file either if you want to identify the service by its name or if you want to obtain the server management URL from the project.");
        opts.addOption("w", "project-password", true, "Project encryption password");
        return opts;
    }

    private Options createMandPropsOptions() {
        Options opts = new Options();
        opts.addOption(MAND_PROP_SERVICE, false, "Service identification (name or ID) to be unlocked.");
        return opts;
    }
}

