/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.sv.svconfigurator.cli.impl;

import com.microfocus.sv.svconfigurator.build.IProjectBuilder;
import com.microfocus.sv.svconfigurator.cli.ICLICommandProcessor;
import com.microfocus.sv.svconfigurator.cli.impl.AbstractProjectCommandProcessor;
import com.microfocus.sv.svconfigurator.cli.impl.DeployCLICommandProcessor;
import com.microfocus.sv.svconfigurator.core.IProject;
import com.microfocus.sv.svconfigurator.core.impl.Server;
import com.microfocus.sv.svconfigurator.core.impl.exception.AbstractSVCException;
import com.microfocus.sv.svconfigurator.core.impl.exception.CommandExecutorException;
import com.microfocus.sv.svconfigurator.core.impl.exception.CommunicatorException;
import com.microfocus.sv.svconfigurator.core.impl.exception.SVCParseException;
import com.microfocus.sv.svconfigurator.core.server.IServerCommandRunner;
import com.microfocus.sv.svconfigurator.core.server.ServersCommandExecutor;
import com.microfocus.sv.svconfigurator.processor.ExportProcessor;
import com.microfocus.sv.svconfigurator.serverclient.ICommandExecutor;
import com.microfocus.sv.svconfigurator.util.CliUtils;
import java.io.IOException;
import java.util.List;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExportCommandProcessor
extends AbstractProjectCommandProcessor
implements ICLICommandProcessor {
    public static final String COMMAND = "export";
    private static final String PARAM_SERVICE = "s";
    private static final String LONG_PARAM_SERVICE = "service";
    private static final String PARAM_DIR = "d";
    private static final String LONG_PARAM_DIR = "directory";
    private static final String PARAM_ARCHIVE = "a";
    private static final String LONG_PARAM_ARCHIVE = "archive";
    private static final String PARAM_CONTINUE_ON_ERROR = "f";
    private static final String LONG_PARAM_CONTINUE_ON_ERROR = "continue-on-error";
    private static final String HELP_USAGE = "export [parameters]";
    private static final Logger LOG = LoggerFactory.getLogger(DeployCLICommandProcessor.class);
    private ExportProcessor exportProcessor;
    private Options opts;

    public ExportCommandProcessor(ExportProcessor exportProcessor, IProjectBuilder projectBuilder) {
        super(projectBuilder);
        this.exportProcessor = exportProcessor;
        this.opts = this.createParamOptions();
    }

    @Override
    public int process(String[] args) {
        BasicParser parser = new BasicParser();
        try {
            CommandLine line = parser.parse(this.opts, args);
            List<Server> servers = CliUtils.obtainServers(line, null, true);
            final String directory = line.getOptionValue(PARAM_DIR);
            if (directory == null) {
                throw new ParseException("You have to specify the output directory.");
            }
            final boolean ignoreErrors = line.hasOption(PARAM_CONTINUE_ON_ERROR);
            final boolean exportAsArchive = line.hasOption(PARAM_ARCHIVE);
            final boolean includeLoggedMessages = line.hasOption("with-logged-messages");
            final String svc = line.hasOption(PARAM_SERVICE) ? line.getOptionValue(PARAM_SERVICE) : null;
            final IProject project = this.getProject(line);
            ServersCommandExecutor executor = new ServersCommandExecutor(servers, this.exportProcessor.getCommandExecutorFactory());
            executor.execute(new IServerCommandRunner(){

                @Override
                public void runCommand(ICommandExecutor executor) throws AbstractSVCException {
                    try {
                        ExportCommandProcessor.this.exportProcessor.process(executor, directory, svc, project, ignoreErrors, exportAsArchive, includeLoggedMessages);
                    }
                    catch (CommunicatorException e) {
                        throw e;
                    }
                    catch (IOException e) {
                        throw new CommunicatorException(e.getMessage(), e);
                    }
                    catch (Exception e) {
                        throw new CommandExecutorException(e.getMessage(), e);
                    }
                }
            });
        }
        catch (ParseException e) {
            LOG.error(e.getLocalizedMessage(), (Throwable)e);
            CliUtils.printHelp(HELP_USAGE, this.opts, new Options());
            return 1000;
        }
        catch (SVCParseException e) {
            LOG.error(e.getLocalizedMessage(), (Throwable)e);
            CliUtils.printHelp(HELP_USAGE, this.opts, new Options());
            return 1000;
        }
        catch (AbstractSVCException e) {
            LOG.error(e.getLocalizedMessage(), (Throwable)e);
            return 1200;
        }
        return 0;
    }

    private Options createParamOptions() {
        Options opts = new Options();
        CliUtils.addConnectionOptions(opts);
        opts.addOption(PARAM_SERVICE, LONG_PARAM_SERVICE, true, "If you specify this parameter, only the specified service will be exported.");
        opts.addOption(PARAM_DIR, LONG_PARAM_DIR, true, "Output directory.");
        opts.addOption(PARAM_CONTINUE_ON_ERROR, LONG_PARAM_CONTINUE_ON_ERROR, false, "Continue without error if export of any service failed.");
        opts.addOption(PARAM_ARCHIVE, LONG_PARAM_ARCHIVE, false, "Export as project archives (.vproja).");
        opts.addOption(null, "with-logged-messages", false, "Include logged messages");
        opts.addOption("p", "project", true, "Project file (.vproj or .vproja) to define set of services to be exported.");
        opts.addOption("w", "project-password", true, "Project encryption password");
        return opts;
    }
}

