/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.sv.svconfigurator.build.parser;

import com.microfocus.sv.svconfigurator.build.parser.AbstractXMLElementParser;
import com.microfocus.sv.svconfigurator.core.IProjectElement;
import com.microfocus.sv.svconfigurator.core.IProjectElementDataSource;
import com.microfocus.sv.svconfigurator.core.impl.PerfModel;
import com.microfocus.sv.svconfigurator.core.impl.exception.SVCParseException;
import java.util.Arrays;
import java.util.Collection;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class PerfModelElementParser
extends AbstractXMLElementParser {
    private static final String ATTR_ID = "id";
    private static final String ATTRIBUTE_NAME = "name";
    public static final String FILE_EXTENSION = ".vspfmodel";
    private static final Collection<String> rootElements = Arrays.asList("offlinePerformanceModel", "performanceModel");

    @Override
    public IProjectElement create(IProjectElementDataSource ds, XMLEventReader reader, String projectPassword) throws SVCParseException, XMLStreamException {
        XMLEvent event = null;
        while (reader.hasNext() && (event == null || !event.isStartElement())) {
            event = reader.nextEvent();
        }
        if (event == null) {
            throw new SVCParseException(String.format("Unable to parse content of the file '%s'", ds.getName()));
        }
        StartElement el = event.asStartElement();
        if (!rootElements.contains(el.getName().getLocalPart())) {
            throw new SVCParseException("Parser does not recognize root element '" + el.getName() + "'");
        }
        String id = AbstractXMLElementParser.getAttributeValue(el, ATTR_ID, false);
        String name = AbstractXMLElementParser.getAttributeValue(el, ATTRIBUTE_NAME, true);
        return new PerfModel(id, name, ds, this.readEncryptionMetadata(reader), projectPassword);
    }

    @Override
    public boolean isParserForDataSource(IProjectElementDataSource ds) {
        return ds.getName().endsWith(FILE_EXTENSION);
    }
}

