/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.sv.svconfigurator.build.parser;

import com.microfocus.sv.svconfigurator.build.parser.AbstractXMLElementParser;
import com.microfocus.sv.svconfigurator.core.IProjectElement;
import com.microfocus.sv.svconfigurator.core.IProjectElementDataSource;
import com.microfocus.sv.svconfigurator.core.impl.Manifest;
import com.microfocus.sv.svconfigurator.core.impl.exception.SVCParseException;
import com.microfocus.sv.svconfigurator.util.StringUtils;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;

public class ManifestElementParser
extends AbstractXMLElementParser {
    public static final String FILE_SUFFIX = ".vsmf";
    private static final String ELEMENT_MANIFEST = "deploymentManifest";
    private static final String ID_ATTR = "id";

    @Override
    public IProjectElement create(IProjectElementDataSource ds, XMLEventReader reader, String projectPassword) throws SVCParseException, XMLStreamException {
        StartElement elManifest = AbstractXMLElementParser.skipToElement(reader, ELEMENT_MANIFEST);
        Attribute idAttr = elManifest.getAttributeByName(QName.valueOf(ID_ATTR));
        String name = StringUtils.removeSuffix(ds.getName(), FILE_SUFFIX);
        return new Manifest(idAttr.getValue(), name, ds);
    }

    @Override
    public boolean isParserForDataSource(IProjectElementDataSource ds) {
        return ds.getName().endsWith(FILE_SUFFIX);
    }
}

