/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.sv.svconfigurator.build.parser;

import com.microfocus.sv.svconfigurator.build.parser.AbstractXMLElementParser;
import com.microfocus.sv.svconfigurator.core.IProjectElement;
import com.microfocus.sv.svconfigurator.core.IProjectElementDataSource;
import com.microfocus.sv.svconfigurator.core.impl.DataSet;
import com.microfocus.sv.svconfigurator.core.impl.exception.SVCParseException;
import com.microfocus.sv.svconfigurator.util.StringUtils;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;

public class DataSetElementParser
extends AbstractXMLElementParser {
    public static final String FILE_EXTENSION = ".vsdataset";
    private static final String ROOT_EL = "ds";
    private static final String ATTR_ID = "id";
    private static final String ATTR_HASH_CODE = "hc";

    @Override
    public IProjectElement create(IProjectElementDataSource ds, XMLEventReader reader, String projectPassword) throws SVCParseException, XMLStreamException {
        StartElement el = AbstractXMLElementParser.skipToElement(reader, ROOT_EL);
        String id = AbstractXMLElementParser.getAttributeValue(el, ATTR_ID, false);
        String name = StringUtils.removeSuffix(ds.getName(), FILE_EXTENSION);
        long hashCode = Long.parseLong(AbstractXMLElementParser.getAttributeValue(el, ATTR_HASH_CODE, false));
        return new DataSet(id, name, hashCode, ds, this.readEncryptionMetadata(reader), projectPassword);
    }

    @Override
    public boolean isParserForDataSource(IProjectElementDataSource ds) {
        return ds.getName().endsWith(FILE_EXTENSION);
    }
}

