/*
 * Decompiled with CFR 0.152.
 */
package com.hp.octane.integrations.dto.events;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum ItemType {
    JOB("Job"),
    MULTI_BRANCH("Multi branch"),
    FOLDER("Folder");

    private String value;

    private ItemType(String value) {
        this.value = value;
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    @JsonCreator
    public static ItemType fromValue(String value) {
        if (value == null || value.isEmpty()) {
            throw new IllegalArgumentException("value MUST NOT be null nor empty");
        }
        ItemType result = JOB;
        for (ItemType v : ItemType.values()) {
            if (v.value.compareTo(value) != 0) continue;
            result = v;
            break;
        }
        return result;
    }
}

