/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.adm.performancecenter.plugins.common.utils;

import com.microfocus.adm.performancecenter.plugins.common.pcentities.PcException;
import com.microfocus.adm.performancecenter.plugins.common.pcentities.PcScript;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ScriptCache {
    private final Map<String, PcScript> scriptByNameAndPath = new HashMap<String, PcScript>();
    private final Map<Integer, PcScript> scriptById = new HashMap<Integer, PcScript>();

    public ScriptCache(List<PcScript> pcScriptList) {
        for (PcScript script : pcScriptList) {
            String key = this.buildKey(script.getTestFolderPath(), script.getName()).toLowerCase();
            this.scriptByNameAndPath.put(key, script);
            this.scriptById.put(script.getID(), script);
        }
    }

    public PcScript getScript(String testFolderPath, String scriptName) throws PcException {
        String key = this.buildKey(testFolderPath, scriptName).toLowerCase();
        PcScript script = this.scriptByNameAndPath.get(key);
        if (script == null) {
            throw new PcException(String.format("No script named '%s' was found under folder path '%s'.", scriptName, testFolderPath));
        }
        return script;
    }

    public PcScript getScript(int scriptId) throws PcException {
        PcScript script = this.scriptById.get(scriptId);
        if (script == null) {
            throw new PcException(String.format("No script with ID '%d' was found.", scriptId));
        }
        return script;
    }

    private String buildKey(String folderPath, String name) {
        return folderPath + "|" + name;
    }
}

