/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.adm.performancecenter.plugins.common.utils;

import com.microfocus.adm.performancecenter.plugins.common.pcentities.PcException;
import com.microfocus.adm.performancecenter.plugins.common.pcentities.PcScript;
import com.microfocus.adm.performancecenter.plugins.common.pcentities.pcsubentities.test.content.Content;
import com.microfocus.adm.performancecenter.plugins.common.pcentities.pcsubentities.test.content.analysistemplate.AnalysisTemplate;
import com.microfocus.adm.performancecenter.plugins.common.pcentities.pcsubentities.test.content.automatictrending.AutomaticTrending;
import com.microfocus.adm.performancecenter.plugins.common.pcentities.pcsubentities.test.content.diagnostics.Diagnostics;
import com.microfocus.adm.performancecenter.plugins.common.pcentities.pcsubentities.test.content.elasticcontrollerconfiguration.ElasticControllerConfiguration;
import com.microfocus.adm.performancecenter.plugins.common.pcentities.pcsubentities.test.content.elasticloadgeneratorconfiguration.ElasticLoadGeneratorConfiguration;
import com.microfocus.adm.performancecenter.plugins.common.pcentities.pcsubentities.test.content.globalcommandline.GlobalCommandLine;
import com.microfocus.adm.performancecenter.plugins.common.pcentities.pcsubentities.test.content.globalcommandline.commandline.CommandLine;
import com.microfocus.adm.performancecenter.plugins.common.pcentities.pcsubentities.test.content.globalrts.GlobalRTS;
import com.microfocus.adm.performancecenter.plugins.common.pcentities.pcsubentities.test.content.groups.Group;
import com.microfocus.adm.performancecenter.plugins.common.pcentities.pcsubentities.test.content.groups.host.Host;
import com.microfocus.adm.performancecenter.plugins.common.pcentities.pcsubentities.test.content.groups.rts.RTS;
import com.microfocus.adm.performancecenter.plugins.common.pcentities.pcsubentities.test.content.groups.rts.javavm.JavaVM;
import com.microfocus.adm.performancecenter.plugins.common.pcentities.pcsubentities.test.content.groups.rts.javavm.javaenvclasspaths.JavaEnvClassPaths;
import com.microfocus.adm.performancecenter.plugins.common.pcentities.pcsubentities.test.content.groups.rts.jmeter.JMeter;
import com.microfocus.adm.performancecenter.plugins.common.pcentities.pcsubentities.test.content.groups.rts.log.Log;
import com.microfocus.adm.performancecenter.plugins.common.pcentities.pcsubentities.test.content.groups.rts.pacing.Pacing;
import com.microfocus.adm.performancecenter.plugins.common.pcentities.pcsubentities.test.content.groups.rts.pacing.startnewiteration.StartNewIteration;
import com.microfocus.adm.performancecenter.plugins.common.pcentities.pcsubentities.test.content.groups.rts.selenium.Selenium;
import com.microfocus.adm.performancecenter.plugins.common.pcentities.pcsubentities.test.content.groups.rts.thinktime.ThinkTime;
import com.microfocus.adm.performancecenter.plugins.common.pcentities.pcsubentities.test.content.groups.script.Script;
import com.microfocus.adm.performancecenter.plugins.common.pcentities.pcsubentities.test.content.lgdistribution.LGDistribution;
import com.microfocus.adm.performancecenter.plugins.common.pcentities.pcsubentities.test.content.monitorprofiles.MonitorProfile;
import com.microfocus.adm.performancecenter.plugins.common.pcentities.pcsubentities.test.content.monitorsofw.MonitorOFW;
import com.microfocus.adm.performancecenter.plugins.common.pcentities.pcsubentities.test.content.scheduler.Scheduler;
import com.microfocus.adm.performancecenter.plugins.common.pcentities.pcsubentities.test.content.scheduler.actions.Action;
import com.microfocus.adm.performancecenter.plugins.common.pcentities.pcsubentities.test.content.scheduler.actions.common.Ramp;
import com.microfocus.adm.performancecenter.plugins.common.pcentities.pcsubentities.test.content.scheduler.actions.common.TimeInterval;
import com.microfocus.adm.performancecenter.plugins.common.pcentities.pcsubentities.test.content.scheduler.actions.duration.Duration;
import com.microfocus.adm.performancecenter.plugins.common.pcentities.pcsubentities.test.content.scheduler.actions.initialize.Initialize;
import com.microfocus.adm.performancecenter.plugins.common.pcentities.pcsubentities.test.content.scheduler.actions.startvusers.StartVusers;
import com.microfocus.adm.performancecenter.plugins.common.pcentities.pcsubentities.test.content.scheduler.actions.stopvusers.StopVusers;
import com.microfocus.adm.performancecenter.plugins.common.pcentities.pcsubentities.test.content.sla.SLA;
import com.microfocus.adm.performancecenter.plugins.common.pcentities.pcsubentities.test.content.workloadtype.WorkloadType;
import com.microfocus.adm.performancecenter.plugins.common.pcentities.pcsubentities.test.enums.DurationTypeValues;
import com.microfocus.adm.performancecenter.plugins.common.pcentities.pcsubentities.test.enums.HostTypeValues;
import com.microfocus.adm.performancecenter.plugins.common.pcentities.pcsubentities.test.enums.LGDistributionTypeValues;
import com.microfocus.adm.performancecenter.plugins.common.pcentities.pcsubentities.test.enums.StartNewIterationTypeValues;
import com.microfocus.adm.performancecenter.plugins.common.pcentities.pcsubentities.test.enums.StartStopVusersTypeValues;
import com.microfocus.adm.performancecenter.plugins.common.pcentities.pcsubentities.test.enums.VusersDistributionModeValues;
import com.microfocus.adm.performancecenter.plugins.common.pcentities.pcsubentities.test.enums.WorkloadTypeSubTypeValues;
import com.microfocus.adm.performancecenter.plugins.common.pcentities.pcsubentities.test.enums.WorkloadTypeValues;
import com.microfocus.adm.performancecenter.plugins.common.pcentities.simplifiedentities.simplifiedtest.SimplifiedTest;
import com.microfocus.adm.performancecenter.plugins.common.pcentities.simplifiedentities.simplifiedtest.content.SimplifiedContent;
import com.microfocus.adm.performancecenter.plugins.common.pcentities.simplifiedentities.simplifiedtest.content.automatictrending.SimplifiedAutomaticTrending;
import com.microfocus.adm.performancecenter.plugins.common.pcentities.simplifiedentities.simplifiedtest.content.elasticconfiguration.SimplifiedElasticConfiguration;
import com.microfocus.adm.performancecenter.plugins.common.pcentities.simplifiedentities.simplifiedtest.content.group.SimplifiedGroup;
import com.microfocus.adm.performancecenter.plugins.common.pcentities.simplifiedentities.simplifiedtest.content.group.rts.javavm.SimplifiedJavaVM;
import com.microfocus.adm.performancecenter.plugins.common.pcentities.simplifiedentities.simplifiedtest.content.group.rts.jmeter.SimplifiedJMeter;
import com.microfocus.adm.performancecenter.plugins.common.pcentities.simplifiedentities.simplifiedtest.content.group.rts.pacing.SimplifiedPacing;
import com.microfocus.adm.performancecenter.plugins.common.pcentities.simplifiedentities.simplifiedtest.content.group.rts.selenium.SimplifiedSelenium;
import com.microfocus.adm.performancecenter.plugins.common.pcentities.simplifiedentities.simplifiedtest.content.group.rts.thinktime.SimplifiedThinkTime;
import com.microfocus.adm.performancecenter.plugins.common.rest.PcRestProxy;
import com.microfocus.adm.performancecenter.plugins.common.utils.Helper;
import com.microfocus.adm.performancecenter.plugins.common.utils.ScriptCache;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class ConvertContentStringToTest {
    private static final int MIN_INTERVAL_TIME = 15;
    private PcRestProxy pcRestProxy;
    private String testName;
    private String testFolderPath;
    private String testFolderPathWithSubject;
    private String testOrContent;
    private Content content;

    public ConvertContentStringToTest(PcRestProxy pcRestProxy, String testName, String testFolderPath, String testOrContent) {
        this.pcRestProxy = pcRestProxy;
        this.testName = testName;
        this.testFolderPath = testFolderPath;
        this.testOrContent = testOrContent;
    }

    public String getTestName() {
        return this.testName;
    }

    public String getTestFolderPath() {
        return this.testFolderPath;
    }

    public String getTestFolderPathWithSubject() {
        return this.testFolderPathWithSubject;
    }

    public Content getContent() {
        return this.content;
    }

    public ConvertContentStringToTest invoke() throws IOException, PcException {
        SimplifiedContent simplifiedContent = this.getSimplifiedContent();
        simplifiedContent = this.verifyAndFixSimplifiedContent(simplifiedContent);
        String controller = this.getController(simplifiedContent);
        WorkloadType workloadType = this.getWorkloadType();
        LGDistribution lgDistribution = this.getLgDistribution(simplifiedContent);
        ArrayList<MonitorProfile> monitorProfiles = null;
        Scheduler scheduler = this.getScheduler(simplifiedContent);
        AnalysisTemplate analysisTemplate = null;
        AutomaticTrending automaticTrending = this.getAutomaticTrending(simplifiedContent);
        ArrayList<MonitorOFW> monitorsOFW = null;
        ElasticLoadGeneratorConfiguration elasticLoadGeneratorConfiguration = this.getElasticLoadGeneratorConfiguration(simplifiedContent);
        ElasticControllerConfiguration elasticControllerConfiguration = this.getElasticControllerConfiguration(simplifiedContent);
        SLA sla = null;
        Diagnostics diagnostics = null;
        GlobalCommandLine globalCommandLine = this.getGlobalCommandLine(simplifiedContent);
        GlobalRTS globalRTS = null;
        ArrayList<Group> receivedGroups = this.getGroups(simplifiedContent.getGroup(), lgDistribution);
        this.content = new Content(controller, workloadType, lgDistribution, monitorProfiles, receivedGroups, scheduler, analysisTemplate, automaticTrending, monitorsOFW, sla, diagnostics, globalCommandLine, globalRTS, elasticLoadGeneratorConfiguration, elasticControllerConfiguration);
        return this;
    }

    private SimplifiedContent verifyAndFixSimplifiedContent(SimplifiedContent simplifiedContent) throws IOException, PcException {
        simplifiedContent.setGroup(this.getSimplifiedGroups(simplifiedContent));
        return simplifiedContent;
    }

    private GlobalCommandLine getGlobalCommandLine(SimplifiedContent simplifiedContent) {
        List<SimplifiedGroup> simplifiedGroups = simplifiedContent.getGroup();
        ArrayList<CommandLine> commandLines = new ArrayList<CommandLine>();
        for (SimplifiedGroup simplifiedGroup : simplifiedGroups) {
            if (simplifiedGroup.getCommand_line() == null || simplifiedGroup.getCommand_line().isEmpty()) continue;
            commandLines.add(new CommandLine(simplifiedGroup.getGroup_name(), simplifiedGroup.getCommand_line()));
        }
        if (commandLines.size() > 0) {
            return new GlobalCommandLine(commandLines);
        }
        return null;
    }

    private SimplifiedContent getSimplifiedContent() throws IOException {
        SimplifiedContent simplifiedContent;
        if (this.testName.isEmpty() && this.testFolderPath.isEmpty()) {
            SimplifiedTest simplifiedTest = PcRestProxy.xmlOrYamlStringToSimplifiedTest(this.testOrContent);
            simplifiedContent = simplifiedTest.getTest_content();
            this.testName = simplifiedTest.getTest_name();
            this.testFolderPath = simplifiedTest.getTest_folder_path();
        } else {
            simplifiedContent = PcRestProxy.xmlOrYamlStringToSimplifiedContent(this.testOrContent);
        }
        this.testFolderPathWithSubject = this.verifyTestFolderPath(this.testFolderPath);
        return simplifiedContent;
    }

    private List<SimplifiedGroup> getSimplifiedGroups(SimplifiedContent simplifiedContent) throws IOException, PcException {
        List<SimplifiedGroup> simplifiedGroups = simplifiedContent.getGroup();
        int i = 0;
        ScriptCache scriptCache = null;
        for (SimplifiedGroup simplifiedGroup : simplifiedGroups) {
            ++i;
            PcScript pcScript = null;
            if (simplifiedGroup.getScript_id() == 0 && !simplifiedGroup.getScript_path().isEmpty()) {
                if (scriptCache == null) {
                    ArrayList<PcScript> allScripts = this.pcRestProxy.getScripts().getPcScriptList();
                    scriptCache = new ScriptCache(allScripts);
                }
                File file = new File("Subject\\".concat(simplifiedGroup.getScript_path()));
                String testFolderPath = Helper.getParent(file.toPath()).toString();
                String scriptName = Helper.getName(file.getName());
                pcScript = scriptCache.getScript(testFolderPath, scriptName);
                simplifiedGroup.setScript_id(pcScript.getID());
                simplifiedGroup.setProtocol(pcScript.getProtocol());
                simplifiedContent.setGroup(simplifiedGroups);
            } else if (simplifiedGroup.getScript_id() > 0) {
                pcScript = this.pcRestProxy.getScript(simplifiedGroup.getScript_id());
                simplifiedGroup.setProtocol(pcScript.getProtocol());
                simplifiedGroup.setScript_path(pcScript.getTestFolderPath());
                simplifiedContent.setGroup(simplifiedGroups);
            }
            if (simplifiedGroup.getGroup_name() != null && !simplifiedGroup.getGroup_name().isEmpty()) continue;
            simplifiedGroup.setGroup_name(pcScript.getName().concat("_").concat(Integer.toString(i)));
        }
        return simplifiedGroups;
    }

    private Scheduler getScheduler(SimplifiedContent simplifiedContent) {
        ArrayList<Action> actions = new ArrayList<Action>();
        Initialize initialize = new Initialize();
        StartVusers startVusers = this.getStartVusersSchedulerByTest(simplifiedContent);
        Duration duration = new Duration();
        if (simplifiedContent.getScheduler().getDuration() > 0) {
            TimeInterval timeInterval = this.getTimeInterval(simplifiedContent.getScheduler().getDuration());
            duration = new Duration(DurationTypeValues.RUN_FOR, timeInterval);
        }
        StopVusers stopVusers = new StopVusers();
        actions.add(new Action(initialize));
        actions.add(new Action(startVusers));
        actions.add(new Action(duration));
        actions.add(new Action(stopVusers));
        return new Scheduler(actions);
    }

    private ElasticLoadGeneratorConfiguration getElasticLoadGeneratorConfiguration(SimplifiedContent simplifiedContent) {
        SimplifiedElasticConfiguration simplifiedElasticConfiguration = simplifiedContent.getLg_elastic_configuration();
        ElasticLoadGeneratorConfiguration elasticLoadGeneratorConfiguration = null;
        if (simplifiedElasticConfiguration != null && simplifiedElasticConfiguration.getImage_id() != 0) {
            elasticLoadGeneratorConfiguration = new ElasticLoadGeneratorConfiguration(simplifiedElasticConfiguration.getImage_id(), simplifiedElasticConfiguration.getMemory_limit(), simplifiedElasticConfiguration.getCpu_limit());
        }
        return elasticLoadGeneratorConfiguration;
    }

    private ElasticControllerConfiguration getElasticControllerConfiguration(SimplifiedContent simplifiedContent) {
        SimplifiedElasticConfiguration simplifiedElasticConfiguration = simplifiedContent.getController_elastic_configuration();
        ElasticControllerConfiguration elasticControllerConfiguration = null;
        if (simplifiedElasticConfiguration != null && simplifiedElasticConfiguration.getImage_id() != 0) {
            elasticControllerConfiguration = new ElasticControllerConfiguration(simplifiedElasticConfiguration.getImage_id(), simplifiedElasticConfiguration.getMemory_limit(), simplifiedElasticConfiguration.getCpu_limit());
        }
        return elasticControllerConfiguration;
    }

    private AutomaticTrending getAutomaticTrending(SimplifiedContent simplifiedContent) {
        SimplifiedAutomaticTrending simplifiedAutomaticTrending = simplifiedContent.getAutomatic_trending();
        AutomaticTrending automaticTrending = null;
        if (simplifiedAutomaticTrending != null) {
            automaticTrending = new AutomaticTrending(simplifiedAutomaticTrending.getReport_id(), simplifiedAutomaticTrending.getMax_runs_in_report());
        }
        return automaticTrending;
    }

    private StartVusers getStartVusersSchedulerByTest(SimplifiedContent simplifiedContent) {
        StartVusers startVusers;
        if (simplifiedContent.getScheduler().getRampup() > 30) {
            int vusersSum = simplifiedContent.getGroup().stream().filter(o -> o.getVusers() > 0).mapToInt(o -> o.getVusers()).sum();
            double exactTimeIntervalInSecondsPerUser = (double)simplifiedContent.getScheduler().getRampup() / (double)vusersSum;
            int vusers = 1;
            int timeIntervalInSeconds = (int)exactTimeIntervalInSecondsPerUser;
            if (exactTimeIntervalInSecondsPerUser < 15.0 && exactTimeIntervalInSecondsPerUser > 0.0) {
                vusers = (int)(15.0 / exactTimeIntervalInSecondsPerUser) + (15.0 % exactTimeIntervalInSecondsPerUser == 0.0 ? 0 : 1);
                timeIntervalInSeconds = 15;
            }
            TimeInterval timeInterval = this.getTimeInterval(timeIntervalInSeconds);
            Ramp ramp = new Ramp(vusers, timeInterval);
            startVusers = new StartVusers(StartStopVusersTypeValues.GRADUALLY, ramp);
        } else if (simplifiedContent.getScheduler().getRampup() > 1) {
            int vusersSum = simplifiedContent.getGroup().stream().filter(o -> o.getVusers() > 0).mapToInt(o -> o.getVusers()).sum();
            int timeIntervalInSeconds = simplifiedContent.getScheduler().getRampup() / 2;
            int vusers = vusersSum / 2 + (vusersSum % 2 == 0 ? 0 : 1);
            TimeInterval timeInterval = this.getTimeInterval(timeIntervalInSeconds);
            Ramp ramp = new Ramp(vusers, timeInterval);
            startVusers = new StartVusers(StartStopVusersTypeValues.GRADUALLY, ramp);
        } else {
            startVusers = new StartVusers();
        }
        return startVusers;
    }

    private ArrayList<Group> getGroups(List<SimplifiedGroup> simplifiedGroups, LGDistribution lgDistribution) {
        ArrayList<Group> receivedGroups = new ArrayList<Group>();
        for (SimplifiedGroup simplifiedGroup : simplifiedGroups) {
            String groupName = simplifiedGroup.getGroup_name();
            int groupVusers = simplifiedGroup.getVusers() > 0 ? simplifiedGroup.getVusers() : 1;
            Script groupScript = new Script(simplifiedGroup.getScript_id());
            RTS groupRTS = this.defineRTS(simplifiedGroup);
            String globalCommandLine = this.defineGlobalCommandLine(simplifiedGroup);
            ArrayList<Host> groupHosts = this.defineGroupHosts(lgDistribution, simplifiedGroup);
            Group group = new Group(groupName, groupVusers, groupScript, groupHosts, groupRTS, globalCommandLine, null, null);
            receivedGroups.add(group);
        }
        return receivedGroups;
    }

    private RTS defineRTS(SimplifiedGroup simplifiedGroup) {
        Pacing pacing = null;
        JavaVM javaVM = null;
        Log log = null;
        JMeter jMeter = null;
        ThinkTime thinkTime = null;
        Selenium selenium = null;
        if (simplifiedGroup.getRts() != null) {
            pacing = this.definePacing(simplifiedGroup);
            javaVM = this.defineJavaVM(simplifiedGroup);
            thinkTime = this.defineThinkTime(simplifiedGroup);
            jMeter = this.defineJMeter(simplifiedGroup);
            selenium = this.defineSelenium(simplifiedGroup);
        }
        return new RTS(pacing, thinkTime, log, jMeter, javaVM, selenium);
    }

    private String defineGlobalCommandLine(SimplifiedGroup simplifiedGroup) {
        String globalCommandLine = null;
        if (simplifiedGroup.getCommand_line() != null && !simplifiedGroup.getCommand_line().isEmpty()) {
            globalCommandLine = simplifiedGroup.getGroup_name();
        }
        return globalCommandLine;
    }

    private ArrayList<Host> defineGroupHosts(LGDistribution lgDistribution, SimplifiedGroup simplifiedGroup) {
        ArrayList<Host> groupHosts = new ArrayList<Host>();
        if (lgDistribution.getType() == LGDistributionTypeValues.MANUAL.value()) {
            for (String lgHost : simplifiedGroup.getLg_name()) {
                if (lgHost.startsWith("LG") && Character.isDigit(lgHost.charAt(lgHost.length() - 1))) {
                    groupHosts.add(new Host(lgHost, HostTypeValues.AUTOMATCH));
                    continue;
                }
                if (lgHost.startsWith("DOCKER") && Character.isDigit(lgHost.charAt(lgHost.length() - 1))) {
                    groupHosts.add(new Host(lgHost, HostTypeValues.DYNAMIC));
                    continue;
                }
                groupHosts.add(new Host(lgHost, HostTypeValues.SPECIFIC));
            }
        } else {
            groupHosts = null;
        }
        return groupHosts;
    }

    private Pacing definePacing(SimplifiedGroup simplifiedGroup) {
        SimplifiedPacing simplifiedPacing = simplifiedGroup.getRts().getPacing();
        if (simplifiedPacing != null && simplifiedPacing.getNumber_of_iterations() > 0) {
            StartNewIteration startNewIteration = new StartNewIteration();
            if (simplifiedPacing.getType() != null && !simplifiedPacing.getType().isEmpty() && simplifiedPacing.getDelay() > 0) {
                if (simplifiedPacing.getType().equalsIgnoreCase(StartNewIterationTypeValues.FIXED_DELAY.value()) || simplifiedPacing.getType().equalsIgnoreCase(StartNewIterationTypeValues.FIXED_INTERVAL.value())) {
                    startNewIteration = new StartNewIteration(simplifiedPacing.getType().equalsIgnoreCase(StartNewIterationTypeValues.FIXED_DELAY.value()) ? StartNewIterationTypeValues.FIXED_DELAY.value() : StartNewIterationTypeValues.FIXED_INTERVAL.value(), simplifiedPacing.getDelay(), -1, -1);
                }
                if ((simplifiedPacing.getType().equalsIgnoreCase(StartNewIterationTypeValues.RANDOM_DELAY.value()) || simplifiedPacing.getType().equalsIgnoreCase(StartNewIterationTypeValues.RANDOM_INTERVAL.value())) && simplifiedPacing.getDelay_random_range() > 0) {
                    startNewIteration = new StartNewIteration(simplifiedPacing.getType().equalsIgnoreCase(StartNewIterationTypeValues.RANDOM_DELAY.value()) ? StartNewIterationTypeValues.RANDOM_DELAY.value() : StartNewIterationTypeValues.RANDOM_INTERVAL.value(), -1, simplifiedPacing.getDelay(), simplifiedPacing.getDelay() + simplifiedPacing.getDelay_random_range());
                }
            }
            return new Pacing(simplifiedPacing.getNumber_of_iterations(), startNewIteration);
        }
        return null;
    }

    private JMeter defineJMeter(SimplifiedGroup simplifiedGroup) {
        SimplifiedJMeter simplifiedJMeter = simplifiedGroup.getRts().getJmeter();
        if (simplifiedJMeter != null) {
            boolean useJMeterAdditionalProperties = simplifiedJMeter.getJmeter_additional_properties() != null && !simplifiedJMeter.getJmeter_additional_properties().isEmpty();
            return new JMeter(simplifiedJMeter.isStart_measurements(), simplifiedJMeter.getJmeter_home_path(), simplifiedJMeter.getJmeter_min_port() <= 0 || simplifiedJMeter.getJmeter_max_port() <= simplifiedJMeter.getJmeter_min_port(), simplifiedJMeter.getJmeter_min_port(), simplifiedJMeter.getJmeter_max_port(), useJMeterAdditionalProperties, useJMeterAdditionalProperties ? simplifiedJMeter.getJmeter_additional_properties() : null);
        }
        return null;
    }

    private Selenium defineSelenium(SimplifiedGroup simplifiedGroup) {
        SimplifiedSelenium simplifiedSelenium = simplifiedGroup.getRts().getSelenium();
        if (simplifiedSelenium != null) {
            return new Selenium(simplifiedSelenium.getJre_path(), simplifiedSelenium.getClass_path(), simplifiedSelenium.getTest_ng_files());
        }
        return null;
    }

    private ThinkTime defineThinkTime(SimplifiedGroup simplifiedGroup) {
        SimplifiedThinkTime simplifiedThinkTime = simplifiedGroup.getRts().getThinktime();
        if (simplifiedThinkTime != null && simplifiedThinkTime.getType() != null && !simplifiedThinkTime.getType().isEmpty()) {
            return new ThinkTime(simplifiedThinkTime.getType(), simplifiedThinkTime.getLimit_seconds(), simplifiedThinkTime.getMin_percentage(), simplifiedThinkTime.getMax_percentage(), simplifiedThinkTime.getMultiply_factor());
        }
        return null;
    }

    private JavaVM defineJavaVM(SimplifiedGroup simplifiedGroup) {
        SimplifiedJavaVM simplifiedJavaVM = simplifiedGroup.getRts().getJava_vm();
        if (simplifiedJavaVM != null) {
            boolean userSpecifiedJdk = simplifiedJavaVM.getJdk_home() != null && !simplifiedJavaVM.getJdk_home().isEmpty();
            JavaEnvClassPaths javaEnvClassPaths = null;
            if (simplifiedJavaVM.getJava_env_class_paths() != null && simplifiedJavaVM.getJava_env_class_paths().length > 0) {
                javaEnvClassPaths = new JavaEnvClassPaths();
                ArrayList<String> JavaEnvClassPath = new ArrayList<String>();
                for (String java_env_class_path : simplifiedJavaVM.getJava_env_class_paths()) {
                    JavaEnvClassPath.add(java_env_class_path);
                }
                javaEnvClassPaths.setJavaEnvClassPath(JavaEnvClassPath);
            }
            return new JavaVM(javaEnvClassPaths, userSpecifiedJdk, userSpecifiedJdk ? simplifiedJavaVM.getJdk_home() : null, simplifiedJavaVM.getJava_vm_parameters(), simplifiedJavaVM.isUse_xboot(), simplifiedJavaVM.isEnable_classloader_per_vuser());
        }
        return null;
    }

    private LGDistribution getLgDistribution(SimplifiedContent simplifiedContent) {
        boolean isLGHostDefinedInGroups;
        LGDistributionTypeValues lgDistributionTypeValues = LGDistributionTypeValues.ALL_TO_EACH_GROUP;
        boolean bl = isLGHostDefinedInGroups = simplifiedContent.getGroup().stream().filter(o -> o.getLg_name() != null && o.getLg_name().length > 0).count() == (long)simplifiedContent.getGroup().size();
        if (simplifiedContent.getLg_amount() == 0 && isLGHostDefinedInGroups) {
            lgDistributionTypeValues = LGDistributionTypeValues.MANUAL;
        } else if (simplifiedContent.getLg_amount() == 0) {
            simplifiedContent.setLg_amount(1);
        }
        LGDistribution lgDistribution = new LGDistribution(lgDistributionTypeValues);
        lgDistribution.setType(lgDistributionTypeValues);
        if (lgDistributionTypeValues == LGDistributionTypeValues.ALL_TO_EACH_GROUP) {
            lgDistribution.setAmount(simplifiedContent.getLg_amount());
        }
        return lgDistribution;
    }

    private WorkloadType getWorkloadType() {
        return new WorkloadType(WorkloadTypeValues.BASIC, VusersDistributionModeValues.BY_NUMBER, WorkloadTypeSubTypeValues.BY_TEST);
    }

    private String getController(SimplifiedContent simplifiedContent) {
        String controller = null;
        if (simplifiedContent.getController() != null && !simplifiedContent.getController().isEmpty() && (controller = simplifiedContent.getController()).equalsIgnoreCase("Elastic")) {
            controller = "Elastic";
        }
        return controller;
    }

    private String verifyTestFolderPath(String testFolderPath) {
        String testFolderPathWithSubject = "Subject\\".concat(testFolderPath);
        return testFolderPathWithSubject.replace("/", "\\");
    }

    private TimeInterval getTimeInterval(int timeIntervalInSeconds) {
        int day = (int)TimeUnit.SECONDS.toDays(timeIntervalInSeconds);
        long hours = TimeUnit.SECONDS.toHours(timeIntervalInSeconds) - (long)(day * 24);
        long minute = TimeUnit.SECONDS.toMinutes(timeIntervalInSeconds) - TimeUnit.SECONDS.toHours(timeIntervalInSeconds) * 60L;
        long second = TimeUnit.SECONDS.toSeconds(timeIntervalInSeconds) - TimeUnit.SECONDS.toMinutes(timeIntervalInSeconds) * 60L;
        return new TimeInterval(day, Math.toIntExact(hours), Math.toIntExact(minute), Math.toIntExact(second));
    }
}

