/*
 * Decompiled with CFR 0.152.
 */
package com.hp.octane.integrations.uft;

import com.hp.octane.integrations.dto.entities.Entity;
import com.hp.octane.integrations.services.entities.EntitiesService;
import com.hp.octane.integrations.services.entities.QueryHelper;
import com.hp.octane.integrations.uft.DiscoveryResultPreparer;
import com.hp.octane.integrations.uft.items.AutomatedTest;
import com.hp.octane.integrations.uft.items.OctaneStatus;
import com.hp.octane.integrations.uft.items.ScmResourceFile;
import com.hp.octane.integrations.uft.items.UftTestDiscoveryResult;
import com.hp.octane.integrations.utils.SdkStringUtils;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class UftDiscoveryResultPreparerImpl
implements DiscoveryResultPreparer {
    private static final Logger logger = LogManager.getLogger(UftDiscoveryResultPreparerImpl.class);
    private static final int QUERY_CONDITION_SIZE_THRESHOLD = 3000;
    private static final String OCTANE_VERSION_SUPPORTING_TEST_RENAME = "12.60.3";

    @Override
    public void prepareDiscoveryResultForDispatchInFullSyncMode(EntitiesService entitiesService, UftTestDiscoveryResult discoveryResult) {
        this.matchDiscoveryTestResultsWithOctaneForFullSync(entitiesService, discoveryResult);
        this.matchDiscoveryDataTablesResultsWithOctaneForFullSync(entitiesService, discoveryResult);
        this.removeItemsWithStatusNone(discoveryResult.getAllTests());
        this.removeItemsWithStatusNone(discoveryResult.getAllScmResourceFiles());
    }

    @Override
    public void prepareDiscoveryResultForDispatchInScmChangesMode(EntitiesService entitiesService, UftTestDiscoveryResult discoveryResult) {
        if (this.isOctaneSupportTestRename(entitiesService)) {
            if (!discoveryResult.getCombineDataTableHashCodeToTestPathListMap().isEmpty()) {
                this.handleMovedTestsWithBulkTestRename(discoveryResult);
            } else {
                this.handleMovedTests(discoveryResult);
            }
            this.handleMovedDataTables(discoveryResult);
        }
        this.validateTestDiscoveryAndCompleteTestIdsForScmChangeDetection(entitiesService, discoveryResult);
        this.validateTestDiscoveryAndCompleteDataTableIdsForScmChangeDetection(entitiesService, discoveryResult);
        this.removeItemsWithStatusNone(discoveryResult.getAllTests());
        this.removeItemsWithStatusNone(discoveryResult.getAllScmResourceFiles());
    }

    private void matchDiscoveryTestResultsWithOctaneForFullSync(EntitiesService entitiesService, UftTestDiscoveryResult discoveryResult) {
        List<String> additionalFields = SdkStringUtils.isNotEmpty(discoveryResult.getTestRunnerId()) ? Arrays.asList("test_runner") : null;
        Map<String, Entity> octaneTestsMap = this.getTestsFromServer(entitiesService, Long.parseLong(discoveryResult.getWorkspaceId()), Long.parseLong(discoveryResult.getScmRepositoryId()), true, null, additionalFields);
        Map<String, Entity> octaneTestsMapWithoutScmRepository = this.getTestsFromServer(entitiesService, Long.parseLong(discoveryResult.getWorkspaceId()), Long.parseLong(discoveryResult.getScmRepositoryId()), false, null, additionalFields);
        for (AutomatedTest discoveredTest : discoveryResult.getAllTests()) {
            String key = this.createKey(discoveredTest.getPackage(), discoveredTest.getName());
            Entity octaneTest = octaneTestsMap.remove(key);
            Entity octaneTestWithoutScmRepository = octaneTestsMapWithoutScmRepository.remove(key);
            if (octaneTest != null) {
                boolean testsEqual = this.checkTestEquals(discoveredTest, octaneTest, discoveryResult.getTestRunnerId());
                if (!testsEqual) {
                    discoveredTest.setId(octaneTest.getId());
                    discoveredTest.setOctaneStatus(OctaneStatus.MODIFIED);
                    if (!octaneTest.containsField("test_runner") || octaneTest.getField("test_runner") != null) continue;
                    discoveredTest.setMissingTestRunner(true);
                    continue;
                }
                discoveredTest.setOctaneStatus(OctaneStatus.NONE);
                continue;
            }
            if (octaneTestWithoutScmRepository == null) continue;
            discoveredTest.setId(octaneTestWithoutScmRepository.getId());
            discoveredTest.setOctaneStatus(OctaneStatus.MODIFIED);
            if (octaneTestWithoutScmRepository.containsField("test_runner") && octaneTestWithoutScmRepository.getField("test_runner") == null) {
                discoveredTest.setMissingTestRunner(true);
            }
            discoveredTest.setMissingScmRepository(true);
        }
        for (Entity octaneTest : octaneTestsMap.values()) {
            boolean octaneExecutable = octaneTest.getBooleanValue("executable");
            if (!octaneExecutable) continue;
            AutomatedTest test = new AutomatedTest();
            discoveryResult.getAllTests().add(test);
            test.setId(octaneTest.getId());
            test.setExecutable(false);
            test.setName(octaneTest.getName());
            test.setPackage(octaneTest.getStringValue("package"));
            test.setOctaneStatus(OctaneStatus.DELETED);
        }
    }

    private boolean matchDiscoveryDataTablesResultsWithOctaneForFullSync(EntitiesService entitiesService, UftTestDiscoveryResult discoveryResult) {
        boolean hasDiff = false;
        Map<String, Entity> octaneDataTablesMap = this.getDataTablesFromServer(entitiesService, Long.parseLong(discoveryResult.getWorkspaceId()), Long.parseLong(discoveryResult.getScmRepositoryId()), null);
        for (ScmResourceFile dataTable : discoveryResult.getAllScmResourceFiles()) {
            Entity octaneDataTable = octaneDataTablesMap.remove(dataTable.getRelativePath());
            if (octaneDataTable == null) continue;
            dataTable.setOctaneStatus(OctaneStatus.NONE);
            hasDiff = true;
        }
        for (Entity octaneDataTable : octaneDataTablesMap.values()) {
            hasDiff = true;
            ScmResourceFile dt = new ScmResourceFile();
            dt.setId(octaneDataTable.getId());
            dt.setName(octaneDataTable.getName());
            dt.setRelativePath(octaneDataTable.getStringValue("relative_path"));
            dt.setOctaneStatus(OctaneStatus.DELETED);
            discoveryResult.getAllScmResourceFiles().add(dt);
        }
        return hasDiff;
    }

    private Map<String, Entity> getTestsFromServer(EntitiesService entitiesService, long workspaceId, long scmRepositoryId, boolean belongToScmRepository, Collection<String> allTestNames, Collection<String> additionalFieldsToFetch) {
        String byNameCondition;
        ArrayList<String> conditions = new ArrayList<String>();
        if (allTestNames != null && !allTestNames.isEmpty() && (byNameCondition = QueryHelper.conditionIn("name", allTestNames, false)).length() < 3000) {
            conditions.add(byNameCondition);
        }
        if (belongToScmRepository) {
            conditions.add(QueryHelper.conditionRef("scm_repository", scmRepositoryId));
        } else {
            conditions.add(QueryHelper.conditionRef("testing_tool_type", "id", "list_node.testing_tool_type.uft"));
            conditions.add(QueryHelper.conditionNot(QueryHelper.conditionRef("scm_repository", scmRepositoryId)));
        }
        ArrayList<String> fields = new ArrayList<String>(Arrays.asList("id", "name", "package", "executable", "description"));
        if (additionalFieldsToFetch != null && !additionalFieldsToFetch.isEmpty()) {
            fields.addAll(additionalFieldsToFetch);
        }
        List<Entity> octaneTests = entitiesService.getEntities(workspaceId, "automated_tests", conditions, fields);
        HashMap<String, Entity> octaneTestsMapByKey = new HashMap<String, Entity>();
        for (Entity octaneTest : octaneTests) {
            String key = this.createKey(octaneTest.getStringValue("package"), octaneTest.getName());
            octaneTestsMapByKey.put(key, octaneTest);
        }
        return octaneTestsMapByKey;
    }

    private Map<String, Entity> getDataTablesFromServer(EntitiesService entitiesService, long workspaceId, long scmRepositoryId, Set<String> allNames) {
        String byPathCondition;
        ArrayList<String> conditions = new ArrayList<String>();
        if (allNames != null && !allNames.isEmpty() && (byPathCondition = QueryHelper.conditionIn("name", allNames, false)).length() < 3000) {
            conditions.add(byPathCondition);
        }
        String conditionByScmRepository = QueryHelper.conditionRef("scm_repository", scmRepositoryId);
        conditions.add(conditionByScmRepository);
        List<String> dataTablesFields = Arrays.asList("id", "name", "relative_path");
        List<Entity> octaneDataTables = entitiesService.getEntities(workspaceId, "scm_resource_files", conditions, dataTablesFields);
        HashMap<String, Entity> octaneDataTablesMap = new HashMap<String, Entity>();
        for (Entity dataTable : octaneDataTables) {
            octaneDataTablesMap.put(dataTable.getStringValue("relative_path"), dataTable);
        }
        return octaneDataTablesMap;
    }

    private String createKey(String ... values) {
        for (int i = 0; i < values.length; ++i) {
            if (values[i] != null && !"null".equals(values[i])) continue;
            values[i] = "";
        }
        return SdkStringUtils.join(values, "#");
    }

    private boolean checkTestEquals(AutomatedTest discoveredTest, Entity octaneTest, String testRunnerId) {
        boolean octaneExecutable = octaneTest.getBooleanValue("executable");
        String octaneDesc = octaneTest.getStringValue("description");
        octaneDesc = SdkStringUtils.isEmpty(octaneDesc) || "null".equals(octaneDesc) ? "" : octaneDesc;
        String discoveredDesc = SdkStringUtils.isEmpty(discoveredTest.getDescription()) ? "" : discoveredTest.getDescription();
        boolean descriptionEquals = SdkStringUtils.isEmpty(octaneDesc) && SdkStringUtils.isEmpty(discoveredDesc) || octaneDesc.contains(discoveredDesc);
        boolean testRunnerMissing = SdkStringUtils.isNotEmpty(testRunnerId) && octaneTest.getField("test_runner") == null;
        return octaneExecutable && descriptionEquals && discoveredTest.getIsMoved() == false && !testRunnerMissing;
    }

    private boolean isOctaneSupportTestRename(EntitiesService entitiesService) {
        try {
            String octane_version = this.getOctaneVersion(entitiesService);
            boolean supportTestRename = octane_version != null && this.versionCompare(OCTANE_VERSION_SUPPORTING_TEST_RENAME, octane_version) <= 0;
            logger.warn("Support test rename = " + supportTestRename);
            return supportTestRename;
        }
        catch (Exception e) {
            logger.warn("Failed to check isOctaneSupportTestRename : " + e.getMessage());
            return false;
        }
    }

    private String getOctaneVersion(EntitiesService entitiesService) {
        String octaneVersion = null;
        List<Entity> entities = entitiesService.getEntities(null, "server_version", null, null);
        if (entities.size() == 1) {
            Entity entity = entities.get(0);
            octaneVersion = entity.getStringValue("version");
            logger.debug("Received Octane version - " + octaneVersion);
        } else {
            logger.error(String.format("Request for Octane version returned %s items. return version is not defined.", entities.size()));
        }
        return octaneVersion;
    }

    private Integer versionCompare(String str1, String str2) {
        int i;
        String[] vals1 = str1.split("\\.");
        String[] vals2 = str2.split("\\.");
        for (i = 0; i < vals1.length && i < vals2.length && vals1[i].equals(vals2[i]); ++i) {
        }
        if (i < vals1.length && i < vals2.length) {
            int diff = Integer.valueOf(vals1[i]).compareTo(Integer.valueOf(vals2[i]));
            return Integer.signum(diff);
        }
        return Integer.signum(vals1.length - vals2.length);
    }

    private void handleMovedTests(UftTestDiscoveryResult result) {
        List<AutomatedTest> newTests = result.getNewTests();
        List<AutomatedTest> deletedTests = result.getDeletedTests();
        if (!newTests.isEmpty() && !deletedTests.isEmpty()) {
            HashMap<String, AutomatedTest> dst2Test = new HashMap<String, AutomatedTest>();
            HashMap<AutomatedTest, AutomatedTest> deleted2newMovedTests = new HashMap<AutomatedTest, AutomatedTest>();
            for (AutomatedTest automatedTest : newTests) {
                if (!SdkStringUtils.isNotEmpty(automatedTest.getChangeSetDst())) continue;
                dst2Test.put(automatedTest.getChangeSetDst(), automatedTest);
            }
            for (AutomatedTest automatedTest : deletedTests) {
                if (!SdkStringUtils.isNotEmpty(automatedTest.getChangeSetDst()) || !dst2Test.containsKey(automatedTest.getChangeSetDst())) continue;
                AutomatedTest newTest = (AutomatedTest)dst2Test.get(automatedTest.getChangeSetDst());
                deleted2newMovedTests.put(automatedTest, newTest);
            }
            for (Map.Entry entry : deleted2newMovedTests.entrySet()) {
                AutomatedTest deletedTest = (AutomatedTest)entry.getKey();
                AutomatedTest newTest = (AutomatedTest)entry.getValue();
                newTest.setIsMoved(true);
                newTest.setOldName(deletedTest.getName());
                newTest.setOldPackage(deletedTest.getPackage());
                newTest.setOctaneStatus(OctaneStatus.MODIFIED);
                result.getAllTests().remove(deletedTest);
            }
        }
    }

    private void handleMovedTestsWithBulkTestRename(UftTestDiscoveryResult result) {
        List<AutomatedTest> newTests = result.getNewTests();
        List<AutomatedTest> deletedTests = result.getDeletedTests();
        if (!newTests.isEmpty() && !deletedTests.isEmpty()) {
            AutomatedTest newTest;
            String key;
            HashMap<String, List> dst2Test = new HashMap<String, List>();
            LinkedList<AbstractMap.SimpleEntry<AutomatedTest, AutomatedTest>> deleted2newMovedTests = new LinkedList<AbstractMap.SimpleEntry<AutomatedTest, AutomatedTest>>();
            for (AutomatedTest automatedTest : newTests) {
                if (!SdkStringUtils.isNotEmpty(automatedTest.getChangeSetDst())) continue;
                key = automatedTest.getChangeSetDst();
                dst2Test.computeIfAbsent(key, k -> new LinkedList()).add(automatedTest);
            }
            for (AutomatedTest automatedTest : deletedTests) {
                if (!SdkStringUtils.isNotEmpty(automatedTest.getChangeSetDst()) || !dst2Test.containsKey(key = automatedTest.getChangeSetDst())) continue;
                if (((List)dst2Test.get(key)).size() == 1) {
                    newTest = (AutomatedTest)((List)dst2Test.get(key)).get(0);
                    deleted2newMovedTests.add(new AbstractMap.SimpleEntry<AutomatedTest, AutomatedTest>(automatedTest, newTest));
                    continue;
                }
                AbstractMap.SimpleEntry<AutomatedTest, AutomatedTest> pairsDeletedNew = this.createPairsDeletedNew((List)dst2Test.get(key), automatedTest, result);
                if (pairsDeletedNew != null) {
                    deleted2newMovedTests.add(pairsDeletedNew);
                    continue;
                }
                logger.warn("since found same tests we can't determine which test modified");
            }
            for (AbstractMap.SimpleEntry simpleEntry : deleted2newMovedTests) {
                AutomatedTest deletedTest = (AutomatedTest)simpleEntry.getKey();
                newTest = (AutomatedTest)simpleEntry.getValue();
                newTest.setIsMoved(true);
                newTest.setOldName(deletedTest.getName());
                newTest.setOldPackage(deletedTest.getPackage());
                newTest.setOctaneStatus(OctaneStatus.MODIFIED);
                result.getAllTests().remove(deletedTest);
            }
        }
    }

    private void handleMovedDataTables(UftTestDiscoveryResult result) {
        List<ScmResourceFile> newItems = result.getNewScmResourceFiles();
        List<ScmResourceFile> deletedItems = result.getDeletedScmResourceFiles();
        if (!newItems.isEmpty() && !deletedItems.isEmpty()) {
            HashMap<String, ScmResourceFile> dst2File = new HashMap<String, ScmResourceFile>();
            HashMap<ScmResourceFile, ScmResourceFile> deleted2newMovedFiles = new HashMap<ScmResourceFile, ScmResourceFile>();
            for (ScmResourceFile scmResourceFile : newItems) {
                if (!SdkStringUtils.isNotEmpty(scmResourceFile.getChangeSetDst())) continue;
                dst2File.put(scmResourceFile.getChangeSetDst(), scmResourceFile);
            }
            for (ScmResourceFile scmResourceFile : deletedItems) {
                if (!SdkStringUtils.isNotEmpty(scmResourceFile.getChangeSetDst()) || !dst2File.containsKey(scmResourceFile.getChangeSetDst())) continue;
                ScmResourceFile newFile = (ScmResourceFile)dst2File.get(scmResourceFile.getChangeSetDst());
                deleted2newMovedFiles.put(scmResourceFile, newFile);
            }
            for (Map.Entry entry : deleted2newMovedFiles.entrySet()) {
                ScmResourceFile deletedFile = (ScmResourceFile)entry.getKey();
                ScmResourceFile newFile = (ScmResourceFile)entry.getValue();
                newFile.setIsMoved(true);
                newFile.setOldName(deletedFile.getName());
                newFile.setOldRelativePath(deletedFile.getRelativePath());
                newFile.setOctaneStatus(OctaneStatus.MODIFIED);
                result.getAllScmResourceFiles().remove(deletedFile);
            }
        }
    }

    private AbstractMap.SimpleEntry<AutomatedTest, AutomatedTest> createPairsDeletedNew(List<AutomatedTest> newTests, AutomatedTest deletedTest, UftTestDiscoveryResult result) {
        Map<String, List<String>> combineDataTableHashCodeToTestPathList = result.getCombineDataTableHashCodeToTestPathListMap();
        LinkedList deletedTestsList = new LinkedList();
        LinkedList newTestsList = new LinkedList();
        combineDataTableHashCodeToTestPathList.values().forEach(entry -> {
            LinkedList tempDeletedTestsList = new LinkedList();
            LinkedList<AutomatedTest> tempNewTestsList = new LinkedList<AutomatedTest>();
            entry.forEach(testPath1 -> {
                LinkedList<AutomatedTest> internalDeletedTestsList = new LinkedList<AutomatedTest>();
                LinkedList internalNewTestsList = new LinkedList();
                String deletedTestPath = deletedTest.getPackage() + "\\" + deletedTest.getName();
                if (deletedTestPath.equals(testPath1)) {
                    internalDeletedTestsList.add(deletedTest);
                }
                newTests.forEach(test -> {
                    String newTestPath = test.getPackage() + "\\" + test.getName();
                    if (newTestPath.equals(testPath1)) {
                        internalNewTestsList.add(test);
                    }
                });
                tempDeletedTestsList.addAll(internalDeletedTestsList);
                tempNewTestsList.addAll(internalNewTestsList);
            });
            if (tempDeletedTestsList.size() == 1 && tempNewTestsList.size() == 1) {
                deletedTestsList.addAll(tempDeletedTestsList);
                newTestsList.addAll(tempNewTestsList);
            } else if (tempDeletedTestsList.size() == 1 && tempNewTestsList.size() > 1) {
                String allTestsName = this.getTestsName(tempNewTestsList);
                logger.warn("The following tests are dupilcated: " + allTestsName + " it is recommended to rename duplicated test one by one and not in bulk.");
            }
        });
        if (deletedTestsList.size() == 1 && newTestsList.size() == 1) {
            return new AbstractMap.SimpleEntry<AutomatedTest, AutomatedTest>((AutomatedTest)deletedTestsList.get(0), (AutomatedTest)newTestsList.get(0));
        }
        return null;
    }

    private String getTestsName(List<AutomatedTest> tempNewTestsList) {
        String returnString = tempNewTestsList.stream().map(test -> test.getName() + ", ").collect(Collectors.joining());
        return returnString.substring(0, returnString.length() - 2);
    }

    private boolean validateTestDiscoveryAndCompleteTestIdsForScmChangeDetection(EntitiesService entitiesService, UftTestDiscoveryResult result) {
        boolean hasDiff = false;
        HashSet<String> allTestNames = new HashSet<String>();
        for (AutomatedTest test : result.getAllTests()) {
            if (test.getIsMoved().booleanValue()) {
                allTestNames.add(test.getOldName());
                continue;
            }
            allTestNames.add(test.getName());
        }
        List<String> additionalFields = SdkStringUtils.isNotEmpty(result.getTestRunnerId()) ? Collections.singletonList("test_runner") : null;
        Map<String, Entity> octaneTestsMapByKey = this.getTestsFromServer(entitiesService, Long.parseLong(result.getWorkspaceId()), Long.parseLong(result.getScmRepositoryId()), true, allTestNames, additionalFields);
        block6: for (AutomatedTest discoveredTest : result.getAllTests()) {
            boolean octaneTestFound;
            String key = discoveredTest.getIsMoved() != false ? this.createKey(discoveredTest.getOldPackage(), discoveredTest.getOldName()) : this.createKey(discoveredTest.getPackage(), discoveredTest.getName());
            Entity octaneTest = octaneTestsMapByKey.get(key);
            boolean bl = octaneTestFound = octaneTest != null;
            if (octaneTestFound) {
                discoveredTest.setId(octaneTest.getId());
            }
            switch (discoveredTest.getOctaneStatus()) {
                case DELETED: {
                    if (octaneTestFound) break;
                    hasDiff = true;
                    discoveredTest.setOctaneStatus(OctaneStatus.NONE);
                    break;
                }
                case MODIFIED: {
                    if (!octaneTestFound) {
                        hasDiff = true;
                        discoveredTest.setOctaneStatus(OctaneStatus.NEW);
                        break;
                    }
                    boolean testsEqual = this.checkTestEquals(discoveredTest, octaneTest, result.getTestRunnerId());
                    if (!testsEqual) continue block6;
                    discoveredTest.setOctaneStatus(OctaneStatus.NONE);
                    break;
                }
                case NEW: {
                    if (!octaneTestFound) break;
                    hasDiff = true;
                    discoveredTest.setOctaneStatus(OctaneStatus.MODIFIED);
                    break;
                }
            }
        }
        return hasDiff;
    }

    private boolean validateTestDiscoveryAndCompleteDataTableIdsForScmChangeDetection(EntitiesService entitiesService, UftTestDiscoveryResult result) {
        boolean hasDiff = false;
        HashSet<String> allNames = new HashSet<String>();
        for (ScmResourceFile file : result.getAllScmResourceFiles()) {
            if (file.getIsMoved().booleanValue()) {
                allNames.add(file.getOldName());
                continue;
            }
            allNames.add(file.getName());
        }
        Map<String, Entity> octaneEntityMapByRelativePath = this.getDataTablesFromServer(entitiesService, Long.parseLong(result.getWorkspaceId()), Long.parseLong(result.getScmRepositoryId()), allNames);
        for (ScmResourceFile file : result.getAllScmResourceFiles()) {
            boolean octaneFileFound;
            String key = file.getIsMoved() != false ? file.getOldRelativePath() : file.getRelativePath();
            Entity octaneFile = octaneEntityMapByRelativePath.get(key);
            boolean bl = octaneFileFound = octaneFile != null;
            if (octaneFileFound) {
                file.setId(octaneFile.getId());
            }
            switch (file.getOctaneStatus()) {
                case DELETED: {
                    if (octaneFileFound) break;
                    hasDiff = true;
                    file.setOctaneStatus(OctaneStatus.NONE);
                    break;
                }
                case MODIFIED: {
                    if (octaneFileFound) break;
                    hasDiff = true;
                    file.setOctaneStatus(OctaneStatus.NEW);
                    break;
                }
                case NEW: {
                    if (!octaneFileFound) break;
                    hasDiff = true;
                    file.setOctaneStatus(OctaneStatus.NONE);
                    break;
                }
            }
        }
        return hasDiff;
    }
}

