/*
 * Decompiled with CFR 0.152.
 */
package com.hp.octane.integrations.services.vulnerabilities.ssc;

import com.hp.octane.integrations.dto.DTOFactory;
import com.hp.octane.integrations.dto.entities.Entity;
import com.hp.octane.integrations.dto.securityscans.OctaneIssue;
import com.hp.octane.integrations.services.vulnerabilities.OctaneIssueConsts;
import com.hp.octane.integrations.services.vulnerabilities.ssc.dto.IssueDetails;
import com.hp.octane.integrations.services.vulnerabilities.ssc.dto.Issues;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SSCToOctaneIssueUtil {
    private static final Logger logger = LogManager.getLogger(SSCToOctaneIssueUtil.class);
    public static final String EXTERNAL_TOOL_NAME = "Fortify SSC";
    public static final String STATUS_NEW = "NEW";

    public static List<OctaneIssue> createOctaneIssues(List<Issues.Issue> issues, String remoteTag, Map<Integer, IssueDetails> issueDetailsById) {
        if (issues == null) {
            return new ArrayList<OctaneIssue>();
        }
        logger.warn("SSCToOctane.createOctaneIssues");
        DTOFactory dtoFactory = DTOFactory.getInstance();
        ArrayList<OctaneIssue> octaneIssues = new ArrayList<OctaneIssue>();
        for (Issues.Issue issue : issues) {
            OctaneIssue octaneIssue = SSCToOctaneIssueUtil.createOctaneIssue(dtoFactory, issue, issueDetailsById.get(issue.id));
            octaneIssues.add(octaneIssue);
            octaneIssue.setRemoteTag(remoteTag);
        }
        return octaneIssues;
    }

    private static OctaneIssue createOctaneIssue(DTOFactory dtoFactory, Issues.Issue issue, IssueDetails issueDetails) {
        logger.debug("enter createOctaneIssue");
        OctaneIssue octaneIssue = (OctaneIssue)dtoFactory.newDTO(OctaneIssue.class);
        SSCToOctaneIssueUtil.setOctaneAnalysis(dtoFactory, issue, octaneIssue);
        SSCToOctaneIssueUtil.setOctaneSeverity(issue, octaneIssue);
        SSCToOctaneIssueUtil.setOctaneStatus(issue, octaneIssue);
        Map<String, String> extendedData = SSCToOctaneIssueUtil.prepareExtendedData(issue, issueDetails);
        octaneIssue.setExtendedData(extendedData);
        octaneIssue.setPrimaryLocationFull(issue.fullFileName);
        octaneIssue.setLine(issue.lineNumber);
        octaneIssue.setRemoteId(issue.issueInstanceId);
        octaneIssue.setIntroducedDate(SSCToOctaneIssueUtil.convertDates(issue.foundDate));
        octaneIssue.setExternalLink(issue.hRef);
        octaneIssue.setToolName(EXTERNAL_TOOL_NAME);
        octaneIssue.setCategory(issue.issueName);
        octaneIssue.setPackage(issue.package1);
        logger.debug("exit createOctaneIssue");
        return octaneIssue;
    }

    private static String convertDates(String inputFoundDate) {
        if (inputFoundDate == null) {
            return null;
        }
        SimpleDateFormat sourceDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        try {
            Date date = sourceDateFormat.parse(inputFoundDate);
            SimpleDateFormat targetDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
            return targetDateFormat.format(date);
        }
        catch (ParseException e) {
            logger.error(e.getMessage());
            logger.error((Object)e.getStackTrace());
            return null;
        }
    }

    private static void setOctaneAnalysis(DTOFactory dtoFactory, Issues.Issue issue, OctaneIssue octaneIssue) {
        String listId = null;
        if (issue.analysis != null) {
            listId = "Not an Issue".equals(issue.analysis) ? "list_node.issue_analysis_node.not_an_issue" : "list_node.issue_analysis_node.maybe_an_issue";
        } else if (SSCToOctaneIssueUtil.isReviewed(issue)) {
            listId = "list_node.issue_analysis_node.reviewed";
        }
        if (listId != null) {
            octaneIssue.setAnalysis(SSCToOctaneIssueUtil.createListNodeEntity(listId));
        }
    }

    private static boolean isReviewed(Issues.Issue issue) {
        boolean returnValue = false;
        if (issue.issueStatus != null && issue.issueStatus.equalsIgnoreCase("reviewed")) {
            returnValue = true;
        } else if (issue.reviewed != null && issue.reviewed.booleanValue()) {
            returnValue = true;
        } else if (issue.audited != null && issue.audited.booleanValue()) {
            returnValue = true;
        }
        return returnValue;
    }

    private static void setOctaneStatus(Issues.Issue issue, OctaneIssue octaneIssue) {
        if (issue.scanStatus != null) {
            String listNodeId = null;
            if (issue.scanStatus.equalsIgnoreCase("UPDATED")) {
                listNodeId = "list_node.issue_state_node.existing";
            } else if (issue.scanStatus.equalsIgnoreCase(STATUS_NEW)) {
                listNodeId = "list_node.issue_state_node.new";
            } else if (issue.scanStatus.equalsIgnoreCase("REINTRODUCED")) {
                listNodeId = "list_node.issue_state_node.reopen";
            } else if (issue.scanStatus.equalsIgnoreCase("REMOVED")) {
                listNodeId = "list_node.issue_state_node.closed";
            }
            if (OctaneIssueConsts.isLegalOctaneState(listNodeId)) {
                octaneIssue.setState(SSCToOctaneIssueUtil.createListNodeEntity(listNodeId));
            }
        }
    }

    private static Map<String, String> prepareExtendedData(Issues.Issue issue, IssueDetails issueDetails) {
        HashMap<String, String> retVal = new HashMap<String, String>();
        retVal.put("issueName", issue.issueName);
        retVal.put("likelihood", issue.likelihood);
        retVal.put("kingdom", issue.kingdom);
        retVal.put("impact", issue.impact);
        retVal.put("confidence", issue.confidance);
        retVal.put("removedDate", issue.removedDate);
        if (issueDetails != null) {
            retVal.put("summary", ((IssueDetails.IssueDetailsData)issueDetails.getData()).brief);
            retVal.put("explanation", ((IssueDetails.IssueDetailsData)issueDetails.getData()).detail);
            retVal.put("recommendations", ((IssueDetails.IssueDetailsData)issueDetails.getData()).recommendation);
            retVal.put("tips", ((IssueDetails.IssueDetailsData)issueDetails.getData()).tips);
        }
        return retVal;
    }

    private static void setOctaneSeverity(Issues.Issue issue, OctaneIssue octaneIssue) {
        String octaneSeverity = null;
        if (issue.likelihood != null && issue.impact != null) {
            octaneSeverity = SSCToOctaneIssueUtil.getNewOctaneSeverityFromSSCValue(issue.likelihood, issue.impact);
        } else if (issue.severity != null) {
            octaneSeverity = SSCToOctaneIssueUtil.getOctaneSeverityFromSSCValue(issue.severity);
        }
        if (octaneSeverity != null) {
            octaneIssue.setSeverity(SSCToOctaneIssueUtil.createListNodeEntity(octaneSeverity));
        }
    }

    private static String getNewOctaneSeverityFromSSCValue(String likelihood, String impact) {
        String logicalNameForSeverity = null;
        try {
            Float ssclikelhood = Float.valueOf(likelihood);
            Float sscimpact = Float.valueOf(impact);
            if ((double)sscimpact.floatValue() >= 2.5 && (double)ssclikelhood.floatValue() >= 2.5) {
                logicalNameForSeverity = "list_node.severity.urgent";
            }
            if ((double)sscimpact.floatValue() >= 2.5 && (double)ssclikelhood.floatValue() < 2.5) {
                logicalNameForSeverity = "list_node.severity.high";
            }
            if ((double)sscimpact.floatValue() < 2.5 && (double)ssclikelhood.floatValue() >= 2.5) {
                logicalNameForSeverity = "list_node.severity.medium";
            }
            if ((double)sscimpact.floatValue() < 2.5 && (double)ssclikelhood.floatValue() < 2.5) {
                logicalNameForSeverity = "list_node.severity.low";
            }
        }
        catch (Exception e) {
            logger.error("failed to process vulnerability severity (priority) input: {},{}", (Object)likelihood, (Object)impact, (Object)e);
        }
        return logicalNameForSeverity;
    }

    private static String getOctaneSeverityFromSSCValue(Integer severity) {
        String logicalNameForSeverity = null;
        if (severity.equals(4)) {
            logicalNameForSeverity = "list_node.severity.urgent";
        } else if (severity.equals(3)) {
            logicalNameForSeverity = "list_node.severity.high";
        } else if (severity.equals(2)) {
            logicalNameForSeverity = "list_node.severity.medium";
        } else if (severity.equals(1)) {
            logicalNameForSeverity = "list_node.severity.low";
        }
        return logicalNameForSeverity;
    }

    public static Entity createListNodeEntity(String id) {
        if (id == null) {
            return null;
        }
        return ((Entity)DTOFactory.getInstance().newDTO(Entity.class)).setType("list_node").setId(id);
    }
}

