/*
 * Decompiled with CFR 0.152.
 */
package com.hp.octane.integrations.services.vulnerabilities.ssc;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.hp.octane.integrations.dto.securityscans.SSCProjectConfiguration;
import com.hp.octane.integrations.exceptions.PermanentException;
import com.hp.octane.integrations.exceptions.TemporaryException;
import com.hp.octane.integrations.services.rest.SSCRestClient;
import com.hp.octane.integrations.services.vulnerabilities.ssc.dto.Artifacts;
import com.hp.octane.integrations.services.vulnerabilities.ssc.dto.IssueDetails;
import com.hp.octane.integrations.services.vulnerabilities.ssc.dto.Issues;
import com.hp.octane.integrations.services.vulnerabilities.ssc.dto.ProjectVersions;
import com.hp.octane.integrations.services.vulnerabilities.ssc.dto.Projects;
import com.hp.octane.integrations.services.vulnerabilities.ssc.dto.SscBaseEntityArray;
import com.hp.octane.integrations.utils.CIPluginSDKUtils;
import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.utils.HttpClientUtils;
import org.apache.http.util.EntityUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SSCProjectConnector {
    private final SSCProjectConfiguration sscProjectConfiguration;
    private final SSCRestClient sscRestClient;
    private static final Logger logger = LogManager.getLogger(SSCProjectConnector.class);

    public SSCProjectConnector(SSCProjectConfiguration sscProjectConfiguration, SSCRestClient sscRestClient) {
        this.sscProjectConfiguration = sscProjectConfiguration;
        this.sscRestClient = sscRestClient;
    }

    private String sendGetEntity(String urlSuffix) {
        String url = this.sscProjectConfiguration.getSSCUrl() + "/api/v1/" + urlSuffix;
        CloseableHttpResponse response = this.sscRestClient.sendGetRequest(this.sscProjectConfiguration, url);
        if (response.getStatusLine().getStatusCode() == 503) {
            throw new TemporaryException("SSC Server is not available:" + response.getStatusLine().getStatusCode());
        }
        if (response.getStatusLine().getStatusCode() != 200) {
            throw new PermanentException("Error from SSC:" + response.getStatusLine().getStatusCode());
        }
        try {
            String string = CIPluginSDKUtils.inputStreamToUTF8String(response.getEntity().getContent());
            return string;
        }
        catch (IOException e) {
            throw new PermanentException(e);
        }
        finally {
            EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
            HttpClientUtils.closeQuietly((CloseableHttpResponse)response);
        }
    }

    public ProjectVersions.ProjectVersion getProjectVersion() {
        Integer projectId = this.getProjectId();
        if (projectId == null) {
            return null;
        }
        String suffix = this.getURLForProjectVersion(projectId);
        String rawResponse = this.sendGetEntity(suffix);
        ProjectVersions projectVersions = SSCProjectConnector.stringToObject(rawResponse, ProjectVersions.class);
        if (projectVersions.getCount() == 0) {
            return null;
        }
        return (ProjectVersions.ProjectVersion)projectVersions.getData().get(0);
    }

    private Integer getProjectId() {
        String projectIdURL = this.getProjectIdURL();
        String rawResponse = this.sendGetEntity(projectIdURL);
        Projects projects = SSCProjectConnector.stringToObject(rawResponse, Projects.class);
        if (projects.getCount() == 0) {
            return null;
        }
        return ((Projects.Project)projects.getData().get((int)0)).id;
    }

    public static <T> T stringToObject(String response, Class<T> type) {
        if (response == null) {
            return null;
        }
        try {
            return (T)new ObjectMapper().readValue(response, TypeFactory.defaultInstance().constructType(type));
        }
        catch (IOException e) {
            throw new PermanentException(e);
        }
    }

    public Issues readIssues(int projectVersionId) {
        String urlSuffix = this.getIssuesURL(projectVersionId);
        return this.readPagedEntities(urlSuffix, Issues.class);
    }

    public IssueDetails getIssueDetails(Integer id) {
        String urlForIssueDetails = this.getURLForIssueDetails(id);
        String rawResponse = this.sendGetEntity(urlForIssueDetails);
        return SSCProjectConnector.stringToObject(rawResponse, IssueDetails.class);
    }

    public <SSCArray extends SscBaseEntityArray> SSCArray readPagedEntities(String url, Class<SSCArray> type) {
        int startIndex = 0;
        try {
            boolean allFetched = false;
            SscBaseEntityArray total = (SscBaseEntityArray)type.newInstance();
            while (!allFetched) {
                String pagedURL = this.getPagedURL(url, startIndex);
                String rawResponse = this.sendGetEntity(pagedURL);
                SscBaseEntityArray page = (SscBaseEntityArray)SSCProjectConnector.stringToObject(rawResponse, type);
                if (total.getData() == null) {
                    total.setData(page.getData());
                } else {
                    total.getData().addAll(page.getData());
                }
                total.setCount(total.getData().size());
                allFetched = total.getData().size() == page.getCount();
                startIndex = total.getCount();
            }
            return (SSCArray)total;
        }
        catch (IllegalAccessException | InstantiationException e) {
            logger.error(e.getMessage());
            throw new PermanentException("Fail to fetch Issues", e);
        }
    }

    private String getPagedURL(String url, int startIndex) {
        if (url.contains("?")) {
            return url + "&start=" + startIndex;
        }
        return url + "?start=" + startIndex;
    }

    public Artifacts getArtifactsOfProjectVersion(Integer id, int limit) {
        logger.debug("getArtifactsOfProjectVersion-id: " + String.valueOf(id) + " getArtifactsOfProjectVersion-limit: " + String.valueOf(limit));
        String urlSuffix = this.getArtifactsURL(id, limit);
        logger.debug("urlSuffix: " + urlSuffix);
        String rawResponse = this.sendGetEntity(urlSuffix);
        logger.debug("rawResponse: " + rawResponse);
        return SSCProjectConnector.stringToObject(rawResponse, Artifacts.class);
    }

    public String getProjectIdURL() {
        return "projects?q=name:" + CIPluginSDKUtils.urlEncodePathParam(this.sscProjectConfiguration.getProjectName());
    }

    public String getIssuesURL(int projectVersionId) {
        return String.format("projectVersions/%d/issues?showhidden=false&showremoved=false&showsuppressed=false", projectVersionId);
    }

    public String getArtifactsURL(Integer projectVersionId, int limit) {
        return String.format("projectVersions/%d/artifacts?limit=%d", projectVersionId, limit);
    }

    public String getURLForProjectVersion(Integer projectId) {
        return "projects/" + projectId + "/versions?q=name:" + CIPluginSDKUtils.urlEncodePathParam(this.sscProjectConfiguration.getProjectVersion());
    }

    public String getURLForIssueDetails(Integer issuesId) {
        return "issueDetails/" + issuesId;
    }
}

