/*
 * Decompiled with CFR 0.152.
 */
package com.hp.octane.integrations.services.vulnerabilities;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.hp.octane.integrations.dto.securityscans.OctaneIssue;
import com.hp.octane.integrations.exceptions.OctaneSDKGeneralException;
import com.hp.octane.integrations.exceptions.PermanentException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class IssuesFileSerializer {
    private static final Logger logger = LogManager.getLogger(IssuesFileSerializer.class);

    public static InputStream serializeIssues(List<OctaneIssue> octaneIssues) {
        try {
            HashMap<String, List<OctaneIssue>> dataFormat = new HashMap<String, List<OctaneIssue>>();
            dataFormat.put("data", octaneIssues);
            ObjectMapper mapper = new ObjectMapper();
            mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            mapper.writeValue((OutputStream)baos, dataFormat);
            ByteArrayInputStream is = new ByteArrayInputStream(baos.toByteArray());
            return is;
        }
        catch (Exception e) {
            throw new PermanentException(e);
        }
    }

    public static String getTargetDir(File allowedOctaneStorage, String jobId, String buildId) {
        if (allowedOctaneStorage == null) {
            logger.info("hosting plugin does not provide storage, vulnerabilities won't be cached");
            return null;
        }
        return allowedOctaneStorage.getPath() + File.separator + jobId + File.separator + buildId;
    }

    public static InputStream getCachedScanResult(String runRootDir) {
        if (runRootDir == null) {
            logger.debug("exit getCachedScanResult, no runRootDir");
            return null;
        }
        FileInputStream result = null;
        String vulnerabilitiesScanFilePath = runRootDir + File.separator + "securityScan.json";
        File vulnerabilitiesScanFile = new File(vulnerabilitiesScanFilePath);
        if (!vulnerabilitiesScanFile.exists()) {
            return null;
        }
        try {
            result = new FileInputStream(vulnerabilitiesScanFilePath);
        }
        catch (IOException ioe) {
            logger.error("failed to obtain  vulnerabilities Scan File in " + runRootDir);
        }
        return result;
    }

    public static void cacheIssues(String targetDir, List<OctaneIssue> octaneIssues) {
        try {
            if (targetDir != null) {
                IssuesFileSerializer.validateFolderExists(targetDir);
                HashMap<String, List<OctaneIssue>> dataFormat = new HashMap<String, List<OctaneIssue>>();
                dataFormat.put("data", octaneIssues);
                ObjectMapper mapper = new ObjectMapper();
                mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
                String vulnerabilitiesScanFilePath = targetDir + File.separator + "securityScan.json";
                PrintWriter fw = new PrintWriter(vulnerabilitiesScanFilePath, "UTF-8");
                mapper.writeValue((Writer)fw, dataFormat);
                fw.flush();
                fw.close();
            }
        }
        catch (Exception e) {
            throw new PermanentException(e);
        }
    }

    public static void validateFolderExists(String targetDir) {
        File file = new File(targetDir);
        if (!file.exists() && !file.mkdirs()) {
            throw new OctaneSDKGeneralException("target directory was missing and failed to create one");
        }
    }

    public static boolean deleteDirectory(File directoryToBeDeleted) {
        File[] allContents = directoryToBeDeleted.listFiles();
        if (allContents != null) {
            for (File file : allContents) {
                IssuesFileSerializer.deleteDirectory(file);
            }
        }
        return directoryToBeDeleted.delete();
    }
}

