/*
 * Decompiled with CFR 0.152.
 */
package com.hp.octane.integrations.services.tests;

import com.hp.octane.integrations.OctaneSDK;
import com.hp.octane.integrations.dto.DTOBase;
import com.hp.octane.integrations.dto.DTOFactory;
import com.hp.octane.integrations.dto.connectivity.HttpMethod;
import com.hp.octane.integrations.dto.connectivity.OctaneRequest;
import com.hp.octane.integrations.dto.connectivity.OctaneResponse;
import com.hp.octane.integrations.dto.tests.TestsResult;
import com.hp.octane.integrations.exceptions.PermanentException;
import com.hp.octane.integrations.exceptions.RequestTimeoutException;
import com.hp.octane.integrations.exceptions.TemporaryException;
import com.hp.octane.integrations.services.WorkerPreflight;
import com.hp.octane.integrations.services.configuration.ConfigurationService;
import com.hp.octane.integrations.services.configuration.ConfigurationServiceImpl;
import com.hp.octane.integrations.services.configurationparameters.factory.ConfigurationParameterFactory;
import com.hp.octane.integrations.services.queueing.QueueingService;
import com.hp.octane.integrations.services.rest.OctaneRestClient;
import com.hp.octane.integrations.services.rest.RestService;
import com.hp.octane.integrations.services.tests.TestsService;
import com.hp.octane.integrations.utils.CIPluginSDKUtils;
import com.squareup.tape.ObjectQueue;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.URISyntaxException;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.apache.commons.codec.Charsets;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

final class TestsServiceImpl
implements TestsService {
    private static final Logger logger = LogManager.getLogger(TestsServiceImpl.class);
    private static final DTOFactory dtoFactory = DTOFactory.getInstance();
    private static final String TESTS_RESULTS_QUEUE_FILE = "test-results-queue.dat";
    public static int TEMPORARY_ERROR_BREATHE_INTERVAL = 15000;
    private final ExecutorService testsPushExecutor = Executors.newSingleThreadExecutor(new TestsResultPushWorkerThreadFactory());
    private final ObjectQueue<TestsResultQueueItem> testResultsQueue;
    private final OctaneSDK.SDKServicesConfigurer configurer;
    private final RestService restService;
    private final WorkerPreflight workerPreflight;
    private final ConfigurationService configurationService;
    private long requestTimeoutCount = 0L;
    private long lastRequestTimeoutTime = 0L;

    TestsServiceImpl(OctaneSDK.SDKServicesConfigurer configurer, QueueingService queueingService, RestService restService, ConfigurationService configurationService) {
        if (configurer == null) {
            throw new IllegalArgumentException("invalid configurer");
        }
        if (queueingService == null) {
            throw new IllegalArgumentException("queue service MUST NOT be null");
        }
        if (restService == null) {
            throw new IllegalArgumentException("rest service MUST NOT be null");
        }
        if (configurationService == null) {
            throw new IllegalArgumentException("configuration service MUST NOT be null");
        }
        this.testResultsQueue = queueingService.isPersistenceEnabled() ? queueingService.initFileQueue(TESTS_RESULTS_QUEUE_FILE, TestsResultQueueItem.class) : queueingService.initMemoQueue();
        this.configurer = configurer;
        this.restService = restService;
        this.configurationService = configurationService;
        this.workerPreflight = new WorkerPreflight(this, configurationService, logger);
        logger.info(configurer.octaneConfiguration.getLocationForLog() + "starting background worker...");
        this.testsPushExecutor.execute(this::worker);
        logger.info(configurer.octaneConfiguration.getLocationForLog() + "initialized SUCCESSFULLY (backed by " + this.testResultsQueue.getClass().getSimpleName() + ")");
    }

    public boolean isTestsResultRelevant(String jobId, String rootJobId) {
        String serverCiId = this.configurer.octaneConfiguration.getInstanceId();
        if (jobId == null || jobId.isEmpty()) {
            throw new IllegalArgumentException("job CI ID MUST NOT be null nor empty");
        }
        boolean base64 = this.isEncodeBase64();
        String jobIdEncoded = base64 ? CIPluginSDKUtils.urlEncodeBase64(jobId) : CIPluginSDKUtils.urlEncodePathParam(jobId);
        String rootJobIdEncoded = base64 ? CIPluginSDKUtils.urlEncodeBase64(rootJobId) : CIPluginSDKUtils.urlEncodeQueryParam(rootJobId);
        String url = this.getAnalyticsContextPath(this.configurer.octaneConfiguration.getUrl(), this.configurer.octaneConfiguration.getSharedSpace()) + "servers/" + CIPluginSDKUtils.urlEncodePathParam(serverCiId) + "/jobs/" + jobIdEncoded + "/tests-result-preflight";
        if (rootJobId != null && !rootJobId.isEmpty()) {
            url = url + "?rootJobId=" + rootJobIdEncoded;
        }
        if (base64) {
            url = CIPluginSDKUtils.addParameterEncode64ToUrl(url);
            logger.info("Using base64, " + url);
        }
        OctaneRequest preflightRequest = ((OctaneRequest)dtoFactory.newDTO(OctaneRequest.class)).setMethod(HttpMethod.GET).setTimeoutSec(60).setUrl(url);
        try {
            OctaneResponse response = this.restService.obtainOctaneRestClient().execute(preflightRequest);
            if (response.getStatus() == 200) {
                return String.valueOf(true).equals(response.getBody());
            }
            if (response.getStatus() == 503 || response.getStatus() == 502 || response.getStatus() == 429) {
                throw new TemporaryException("preflight request failed with status " + response.getStatus());
            }
            if (response.getStatus() == 401 || response.getStatus() == 403) {
                CIPluginSDKUtils.doWait(30000L);
                throw new PermanentException("preflight request failed with status " + response.getStatus());
            }
            throw new PermanentException("preflight request failed with status " + response.getStatus() + ". JobId: '" + jobId + "'. Request URL : " + url);
        }
        catch (InterruptedIOException ie) {
            throw new RequestTimeoutException("!!!!!!!!!!!!!!!!!!! request timeout during preflight : " + ie.getClass().getCanonicalName() + " - " + ie.getMessage());
        }
        catch (IOException ioe) {
            throw new TemporaryException(ioe);
        }
    }

    private boolean isEncodeBase64() {
        return ConfigurationParameterFactory.isEncodeCiJobBase64(this.configurer.octaneConfiguration);
    }

    public OctaneResponse pushTestsResult(TestsResult testsResult, String jobId, String buildId) throws IOException {
        if (testsResult == null) {
            throw new IllegalArgumentException("tests result MUST NOT be null");
        }
        if (jobId == null || jobId.isEmpty()) {
            throw new IllegalArgumentException("job ID MUST NOT be null nor empty");
        }
        if (buildId == null || buildId.isEmpty()) {
            throw new IllegalArgumentException("build ID MUST NOT be null nor empty");
        }
        String testsResultAsXml = dtoFactory.dtoToXml((DTOBase)testsResult);
        ByteArrayInputStream testsResultAsStream = new ByteArrayInputStream(testsResultAsXml.getBytes(Charsets.UTF_8));
        return this.pushTestsResult(testsResultAsStream, jobId, buildId);
    }

    @Override
    public OctaneResponse pushTestsResult(InputStream testsResult, String jobId, String buildId) throws IOException {
        String uri;
        if (testsResult == null) {
            throw new IllegalArgumentException("tests result MUST NOT be null");
        }
        if (jobId == null || jobId.isEmpty()) {
            throw new IllegalArgumentException("job ID MUST NOT be null nor empty");
        }
        if (buildId == null || buildId.isEmpty()) {
            throw new IllegalArgumentException("build ID MUST NOT be null nor empty");
        }
        OctaneRestClient octaneRestClient = this.restService.obtainOctaneRestClient();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("content-type", ContentType.APPLICATION_XML.getMimeType());
        headers.put("X-Correlation-ID", CIPluginSDKUtils.getNextCorrelationId());
        String tempJobId = jobId;
        boolean base64 = this.isEncodeBase64();
        if (base64) {
            tempJobId = CIPluginSDKUtils.urlEncodeBase64(jobId);
        }
        try {
            uri = new URIBuilder(this.getAnalyticsContextPath(this.configurer.octaneConfiguration.getUrl(), this.configurer.octaneConfiguration.getSharedSpace()) + "test-results").addParameter("skip-errors", "false").addParameter("instance-id", this.configurer.octaneConfiguration.getInstanceId()).addParameter("job-ci-id", tempJobId).addParameter("build-ci-id", buildId).build().toString();
        }
        catch (URISyntaxException urise) {
            throw new PermanentException("failed to build URL to Octane's 'test-results' resource", urise);
        }
        if (base64) {
            uri = CIPluginSDKUtils.addParameterEncode64ToUrl(uri);
        }
        OctaneRequest request = ((OctaneRequest)dtoFactory.newDTO(OctaneRequest.class)).setMethod(HttpMethod.POST).setUrl(uri).setHeaders(headers).setBody(testsResult).setTimeoutSec(120);
        try {
            return octaneRestClient.execute(request);
        }
        catch (InterruptedIOException ie) {
            throw new RequestTimeoutException("!!!!!!!!!!!!!!!!!!! request timeout during pushTestsResult : " + ie.getClass().getCanonicalName() + " - " + ie.getMessage());
        }
    }

    @Override
    public void enqueuePushTestsResult(String jobId, String buildId, String rootJobId) {
        if (jobId == null || jobId.isEmpty()) {
            throw new IllegalArgumentException("job ID MUST NOT be null nor empty");
        }
        if (buildId == null || buildId.isEmpty()) {
            throw new IllegalArgumentException("build ID MUST NOT be null nor empty");
        }
        if (this.configurer.octaneConfiguration.isDisabled()) {
            return;
        }
        if (!((ConfigurationServiceImpl)this.configurationService).isRelevantForOctane(rootJobId)) {
            return;
        }
        this.testResultsQueue.add((Object)new TestsResultQueueItem(jobId, buildId, rootJobId));
        this.workerPreflight.itemAddedToQueue();
    }

    @Override
    public void shutdown() {
        this.testsPushExecutor.shutdown();
    }

    @Override
    public boolean isShutdown() {
        return this.testsPushExecutor.isShutdown();
    }

    private void worker() {
        while (!this.testsPushExecutor.isShutdown()) {
            if (!this.workerPreflight.preflight()) continue;
            TestsResultQueueItem testsResultQueueItem = null;
            try {
                testsResultQueueItem = (TestsResultQueueItem)this.testResultsQueue.peek();
                this.doPreflightAndPushTestResult(testsResultQueueItem);
                this.testResultsQueue.remove();
            }
            catch (RequestTimeoutException rte) {
                ++this.requestTimeoutCount;
                this.lastRequestTimeoutTime = System.currentTimeMillis();
                logger.error(this.configurer.octaneConfiguration.getLocationForLog() + rte.getMessage());
                CIPluginSDKUtils.doWait(TEMPORARY_ERROR_BREATHE_INTERVAL);
            }
            catch (TemporaryException tque) {
                logger.error(this.configurer.octaneConfiguration.getLocationForLog() + "temporary error on " + testsResultQueueItem + ", breathing " + TEMPORARY_ERROR_BREATHE_INTERVAL + "ms and retrying", (Throwable)tque);
                CIPluginSDKUtils.doWait(TEMPORARY_ERROR_BREATHE_INTERVAL);
            }
            catch (PermanentException pqie) {
                logger.error(this.configurer.octaneConfiguration.getLocationForLog() + "permanent error on " + testsResultQueueItem + ", passing over", (Throwable)pqie);
                this.testResultsQueue.remove();
            }
            catch (Throwable t) {
                logger.error(this.configurer.octaneConfiguration.getLocationForLog() + "unexpected error on build log item '" + testsResultQueueItem + "', passing over", t);
                this.testResultsQueue.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doPreflightAndPushTestResult(TestsResultQueueItem queueItem) {
        block27: {
            InputStream testsResultA = this.configurer.pluginServices.getTestsResult(queueItem.jobId, queueItem.buildId);
            if (testsResultA == null) {
                logger.warn(this.configurer.octaneConfiguration.getLocationForLog() + "test result of " + queueItem + " resolved to be NULL, skipping");
                return;
            }
            try {
                InputStream testsResultB;
                boolean isRelevant = this.isTestsResultRelevant(queueItem.jobId, queueItem.rootJobId);
                logger.info(this.configurer.octaneConfiguration.getLocationForLog() + "test results preflight " + queueItem + " = " + isRelevant);
                if (!isRelevant) {
                    return;
                }
                if (!this.configurationService.isOctaneVersionGreaterOrEqual("15.1.60")) {
                    try {
                        String testResultXML = CIPluginSDKUtils.inputStreamToUTF8String(testsResultA);
                        testResultXML = testResultXML.replaceAll("<build.*?>", "<build server_id=\"" + this.configurer.octaneConfiguration.getInstanceId() + "\" job_id=\"" + queueItem.jobId + "\" build_id=\"" + queueItem.buildId + "\"/>").replace("</build>", "");
                        testsResultB = new ByteArrayInputStream(testResultXML.getBytes(Charsets.UTF_8));
                    }
                    catch (Exception e) {
                        throw new PermanentException("failed to update ci server instance ID in the test results XML");
                    }
                } else {
                    testsResultB = testsResultA;
                }
                try {
                    OctaneResponse response = this.pushTestsResult(testsResultB, queueItem.jobId, queueItem.buildId);
                    if (response.getStatus() == 202) {
                        logger.info(this.configurer.octaneConfiguration.getLocationForLog() + "successfully pushed test results for " + queueItem + "; status: " + response.getStatus() + ", response: " + response.getBody() + ", CorrelationId - " + response.getCorrelationId());
                        break block27;
                    }
                    if (response.getStatus() == 503 || response.getStatus() == 502 || response.getStatus() == 429) {
                        throw new TemporaryException("push request TEMPORARILY failed with status " + response.getStatus());
                    }
                    throw new PermanentException("push request PERMANENTLY failed with status " + response.getStatus());
                }
                catch (IOException ioe) {
                    throw new TemporaryException("failed to perform push test results request for " + queueItem, ioe);
                }
                finally {
                    try {
                        testsResultB.close();
                    }
                    catch (IOException e) {
                        logger.warn(this.configurer.octaneConfiguration.getLocationForLog() + "failed to close test result file after push test for " + queueItem);
                    }
                }
            }
            finally {
                try {
                    testsResultA.close();
                }
                catch (IOException e) {
                    logger.warn(this.configurer.octaneConfiguration.getLocationForLog() + "failed to close test result file after push test for " + queueItem);
                }
            }
        }
    }

    private String getAnalyticsContextPath(String octaneBaseUrl, String sharedSpaceId) {
        return octaneBaseUrl + "/internal-api/shared_spaces/" + sharedSpaceId + "/analytics/ci/";
    }

    @Override
    public long getQueueSize() {
        return this.testResultsQueue.size();
    }

    @Override
    public void clearQueue() {
        while (this.testResultsQueue.size() > 0) {
            this.testResultsQueue.remove();
        }
    }

    @Override
    public Map<String, Object> getMetrics() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("queueSize", this.getQueueSize());
        map.put("requestTimeoutCount", this.requestTimeoutCount);
        if (this.lastRequestTimeoutTime > 0L) {
            map.put("lastRequestTimeoutTime", new Date(this.lastRequestTimeoutTime));
        }
        this.workerPreflight.addMetrics(map);
        return map;
    }

    private static final class TestsResultPushWorkerThreadFactory
    implements ThreadFactory {
        private TestsResultPushWorkerThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable runnable) {
            Thread result = new Thread(runnable);
            result.setName("TestsResultPushWorker-" + result.getId());
            result.setDaemon(true);
            return result;
        }
    }

    private static final class TestsResultQueueItem
    implements QueueingService.QueueItem {
        private String jobId;
        private String buildId;
        private String rootJobId;

        private TestsResultQueueItem() {
        }

        private TestsResultQueueItem(String jobId, String buildId, String rootJobId) {
            this.jobId = jobId;
            this.buildId = buildId;
            this.rootJobId = rootJobId;
        }

        public String toString() {
            return "'" + this.jobId + " #" + this.buildId + (this.rootJobId != null ? "', root job : " + this.rootJobId : "");
        }
    }
}

