/*
 * Decompiled with CFR 0.152.
 */
package com.hp.octane.integrations.services.testexecution;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.hp.octane.integrations.OctaneSDK;
import com.hp.octane.integrations.dto.DTOFactory;
import com.hp.octane.integrations.dto.connectivity.HttpMethod;
import com.hp.octane.integrations.dto.connectivity.OctaneRequest;
import com.hp.octane.integrations.dto.connectivity.OctaneResponse;
import com.hp.octane.integrations.dto.entities.Entity;
import com.hp.octane.integrations.executor.TestToRunData;
import com.hp.octane.integrations.executor.TestToRunDataCollection;
import com.hp.octane.integrations.services.SupportsConsoleLog;
import com.hp.octane.integrations.services.entities.EntitiesService;
import com.hp.octane.integrations.services.entities.QueryHelper;
import com.hp.octane.integrations.services.rest.RestService;
import com.hp.octane.integrations.services.testexecution.TestExecutionContext;
import com.hp.octane.integrations.services.testexecution.TestExecutionIdentifierType;
import com.hp.octane.integrations.services.testexecution.TestExecutionService;
import com.hp.octane.integrations.utils.SdkStringUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

final class TestExecutionServiceImpl
implements TestExecutionService {
    private static final Logger logger = LogManager.getLogger(TestExecutionServiceImpl.class);
    private static final DTOFactory dtoFactory = DTOFactory.getInstance();
    private final OctaneSDK.SDKServicesConfigurer configurer;
    private final RestService restService;
    private final EntitiesService entitiesService;

    TestExecutionServiceImpl(OctaneSDK.SDKServicesConfigurer configurer, RestService restService, EntitiesService entitiesService) {
        if (configurer == null) {
            throw new IllegalArgumentException("invalid configurer");
        }
        if (restService == null) {
            throw new IllegalArgumentException("rest service MUST NOT be null");
        }
        if (entitiesService == null) {
            throw new IllegalArgumentException("entities service MUST NOT be null");
        }
        this.configurer = configurer;
        this.restService = restService;
        this.entitiesService = entitiesService;
        logger.info(configurer.octaneConfiguration.getLocationForLog() + "initialized SUCCESSFULLY");
    }

    @Override
    public void executeSuiteRuns(Long workspaceId, List<Long> suiteIds, Long optionalReleaseId, String optionalSuiteRunName, SupportsConsoleLog supportsConsoleLog) throws IOException {
        SupportsConsoleLog mySupportsConsoleLog = this.getSupportConsoleLogOrCreateEmpty(supportsConsoleLog);
        mySupportsConsoleLog.println("Executing suite ids " + suiteIds + " in " + this.configurer.octaneConfiguration.getLocationForLog() + ", workspace " + workspaceId);
        for (Long suiteId : suiteIds) {
            this.validateSuiteRun(workspaceId, suiteId);
        }
        Entity release = this.getReleaseOrThrow(workspaceId, optionalReleaseId);
        mySupportsConsoleLog.println("Using release  - " + release.getId());
        List<Entity> suiteRuns = this.planSuiteRuns(workspaceId, suiteIds, release, optionalSuiteRunName);
        for (Entity suiteRun : suiteRuns) {
            String suiteId = suiteRun.getEntityValue("test").getId();
            String url = this.configurer.octaneConfiguration.getUrl() + String.format("/ui/?p=%s/%s#/entity-navigation?entityType=run&id=%s", this.configurer.octaneConfiguration.getSharedSpace(), workspaceId, suiteRun.getId());
            mySupportsConsoleLog.println(String.format("Suite %s - suite run id is %s , %s", suiteId, suiteRun.getId(), url));
            this.runSuiteRun(workspaceId, Long.parseLong(suiteRun.getId()));
        }
        mySupportsConsoleLog.println("Suite runs are started ");
    }

    @Override
    public List<TestExecutionContext> prepareTestExecutionForSuites(Long workspaceId, List<Long> suiteIds, SupportsConsoleLog supportsConsoleLog) {
        SupportsConsoleLog mySupportsConsoleLog = this.getSupportConsoleLogOrCreateEmpty(supportsConsoleLog);
        ArrayList<TestExecutionContext> output = new ArrayList<TestExecutionContext>();
        mySupportsConsoleLog.println("Fetching test data for suite ids " + suiteIds + " from " + this.configurer.octaneConfiguration.getLocationForLog() + ":" + workspaceId);
        suiteIds.forEach(suiteId -> {
            List<Entity> suiteLinks = this.getSuiteLinks(workspaceId, (Long)suiteId, mySupportsConsoleLog);
            List suiteLinksWithTestRunner = suiteLinks.stream().filter(e -> e.containsFieldAndValue("test_runner")).collect(Collectors.toList());
            int noRunnerCount = suiteLinks.size() - suiteLinksWithTestRunner.size();
            if (noRunnerCount > 0) {
                String noRunnerMsg = String.format("Suite %s: found %s test(s) without test runner, such tests will be skipped", suiteId, noRunnerCount);
                mySupportsConsoleLog.println(noRunnerMsg);
            }
            mySupportsConsoleLog.println(String.format("suite %s: found %s test(s) eligible for execution", suiteId, suiteLinks.size()));
            Map<String, List<Entity>> testRunnerId2links = suiteLinksWithTestRunner.stream().collect(Collectors.groupingBy(e -> ((Entity)e.getField("test_runner")).getId()));
            Map id2testRunners = this.getTestRunners(workspaceId, testRunnerId2links.keySet()).stream().collect(Collectors.toMap(Entity::getId, Function.identity()));
            List<Entity> testRunnersFromAnotherCiServer = id2testRunners.values().stream().filter(e -> !this.configurer.octaneConfiguration.getInstanceId().equals(e.getEntityValue("ci_server").getStringValue("instance_id"))).collect(Collectors.toList());
            if (!testRunnersFromAnotherCiServer.isEmpty()) {
                String runnerNames = testRunnersFromAnotherCiServer.stream().map(Entity::getName).collect(Collectors.joining(","));
                mySupportsConsoleLog.println(String.format("Suite %s: found tests with test runner(s) belong to another ci server, such tests will be skipped. Test runners are : %s", suiteId, runnerNames));
                testRunnersFromAnotherCiServer.forEach(e -> testRunnerId2links.remove(e.getId()));
            }
            testRunnerId2links.keySet().forEach(testRunnerId -> {
                try {
                    List links = (List)testRunnerId2links.get(testRunnerId);
                    String testsToRunJson = this.convertLinksToJson(links);
                    output.add(new TestExecutionContext((Entity)id2testRunners.get(testRunnerId), testsToRunJson, links, TestExecutionIdentifierType.SUITE, Long.toString(suiteId)));
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to build testsToRun for test runner " + testRunnerId + " : " + e.getMessage());
                }
            });
        });
        return output;
    }

    private SupportsConsoleLog getSupportConsoleLogOrCreateEmpty(SupportsConsoleLog supportsConsoleLog) {
        if (supportsConsoleLog == null) {
            return new SupportsConsoleLog(){

                @Override
                public void println(String msg) {
                }

                @Override
                public void print(String msg) {
                }

                @Override
                public void append(String msg) {
                }

                @Override
                public void newLine() {
                }
            };
        }
        return supportsConsoleLog;
    }

    private Entity getReleaseOrThrow(Long workspaceId, Long optionalReleaseId) {
        Entity release;
        if (optionalReleaseId == null) {
            Optional<Entity> defaultRelease = this.getDefaultRelease(workspaceId);
            if (!defaultRelease.isPresent()) {
                throw new RuntimeException("Failed to find default release ");
            }
            release = defaultRelease.get();
        } else {
            release = ((Entity)dtoFactory.newDTO(Entity.class)).setType("release").setId(Long.toString(optionalReleaseId));
        }
        return release;
    }

    @Override
    public Map<Long, String> validateAllSuiteIdsExistAndReturnSuiteNames(Long workspaceId, List<Long> suiteIds) {
        List<Entity> entities = this.entitiesService.getEntitiesByIds(workspaceId, "test_suites", suiteIds, Collections.singletonList("name"));
        Map<Long, String> map = entities.stream().collect(Collectors.toMap(e -> Long.parseLong(e.getId()), Entity::getName));
        List missingSuiteIds = suiteIds.stream().filter(suiteId -> !map.containsKey(suiteId)).collect(Collectors.toList());
        if (!missingSuiteIds.isEmpty()) {
            String idsAsString = missingSuiteIds.stream().map(Object::toString).collect(Collectors.joining(", "));
            throw new IllegalArgumentException("Following suite ids are missing in ALM Octane : " + idsAsString);
        }
        return map;
    }

    private Optional<Entity> getDefaultRelease(Long workspaceId) {
        List<Entity> entities = this.entitiesService.getEntities(workspaceId, "releases", null, "-id", Arrays.asList("is_default", "name"));
        return entities.stream().filter(e -> e.getBooleanValue("is_default")).findFirst();
    }

    private List<Entity> planSuiteRuns(Long workspaceId, List<Long> suiteIds, Entity release, String suiteRunName) {
        Map suiteNames = SdkStringUtils.isNotEmpty(suiteRunName) ? Collections.emptyMap() : this.validateAllSuiteIdsExistAndReturnSuiteNames(workspaceId, suiteIds);
        Entity status = ((Entity)dtoFactory.newDTO(Entity.class)).setType("list_node").setId("list_node.run_native_status.planned");
        List<Entity> suiteRuns = suiteIds.stream().map(suiteId -> {
            Entity test = ((Entity)dtoFactory.newDTO(Entity.class)).setType("test").setId(Long.toString(suiteId));
            Entity suiteRun = ((Entity)dtoFactory.newDTO(Entity.class)).setField("name", (Object)(SdkStringUtils.isNotEmpty(suiteRunName) ? suiteRunName : suiteNames.get(suiteId))).setField("subtype", (Object)"run_suite").setField("release", (Object)release).setField("test", (Object)test).setField("native_status", (Object)status);
            return suiteRun;
        }).collect(Collectors.toList());
        List<Entity> entities = this.entitiesService.postEntities(workspaceId, "runs", suiteRuns, Arrays.asList("test"), Collections.singletonMap("is_atomic_creation", "true"));
        return entities;
    }

    private void validateSuiteRun(Long workspaceId, Long suiteId) throws IOException {
        String url = this.configurer.octaneConfiguration.getUrl() + "/internal-api/shared_spaces/" + this.configurer.octaneConfiguration.getSharedSpace() + "/workspaces/" + workspaceId + "/je/executors/validate-auto-suite?force=false&rerun=false&suite_run_id=&test_suite_id=" + suiteId;
        OctaneRequest request = ((OctaneRequest)dtoFactory.newDTO(OctaneRequest.class)).setMethod(HttpMethod.GET).setUrl(url);
        OctaneResponse octaneResponse = this.restService.obtainOctaneRestClient().execute(request);
        if (octaneResponse.getStatus() != 200) {
            throw new RuntimeException(octaneResponse.getBody());
        }
    }

    private void runSuiteRun(Long workspaceId, Long suiteRunId) throws IOException {
        String url = this.configurer.octaneConfiguration.getUrl() + "/api/shared_spaces/" + this.configurer.octaneConfiguration.getSharedSpace() + "/workspaces/" + workspaceId + "/suite_runs/" + suiteRunId + "/run_auto";
        OctaneRequest request = ((OctaneRequest)dtoFactory.newDTO(OctaneRequest.class)).setMethod(HttpMethod.POST).setUrl(url);
        OctaneResponse octaneResponse = this.restService.obtainOctaneRestClient().execute(request);
        if (octaneResponse.getStatus() != 201) {
            throw new RuntimeException("runSuiteRun failed with status " + octaneResponse.getStatus() + ", message : " + octaneResponse.getBody());
        }
    }

    private List<Entity> getSuiteLinks(Long workspaceId, Long suiteId, SupportsConsoleLog supportsConsoleLog) {
        List<String> fields = Arrays.asList("test_runner", "id", "order", "test_id", "execution_parameters", "taxonomies", "run_mode", "data_table{relative_path}", "test_runner", "test{id,name,subtype,external_test_id,class_name,package,name,subtype,automation_identifier,bdd_spec}");
        String includeInNextCondition = QueryHelper.condition("include_in_next_run", true);
        String notManualCondition = "(test={(!(subtype='test_manual'))})";
        String suiteIdCondition = QueryHelper.conditionRef("test_suite", suiteId);
        List<String> conditions = Arrays.asList(includeInNextCondition, notManualCondition, suiteIdCondition);
        List<Entity> entities = this.entitiesService.getEntities(workspaceId, "test_suite_link_to_tests", conditions, "order,id", fields);
        List<Entity> bddLinks = entities.stream().filter(e -> e.getEntityValue("test").containsFieldAndValue("bdd_spec")).collect(Collectors.toList());
        if (!bddLinks.isEmpty()) {
            Set specIds = bddLinks.stream().map(e -> e.getEntityValue("test").getEntityValue("bdd_spec").getId()).collect(Collectors.toSet());
            List<Entity> bddSpecs = this.entitiesService.getEntitiesByIds(workspaceId, "bdd_specs", specIds, Collections.singleton("automation_identifier"));
            Map<String, String> bddId2automationIdentifier = bddSpecs.stream().collect(Collectors.toMap(Entity::getId, e -> e.getStringValue("automation_identifier")));
            bddLinks.forEach(bddLink -> {
                String bddSpecId = bddLink.getEntityValue("test").getEntityValue("bdd_spec").getId();
                String automationIdentifier = (String)bddId2automationIdentifier.get(bddSpecId);
                bddLink.getEntityValue("test").setField("automation_identifier", (Object)automationIdentifier);
            });
        }
        List<Entity> filteredEntities = entities.stream().filter(e -> e.getField("run_mode") == null || !"list_node.run_mode.manually".equals(((Entity)e.getField("run_mode")).getId())).collect(Collectors.toList());
        int countManual = entities.size() - filteredEntities.size();
        if (countManual > 0) {
            supportsConsoleLog.println(String.format("Suite %s: found %s gherkin/bdd tests with manual run mode. Such tests are skipped", suiteId, countManual));
        }
        return filteredEntities;
    }

    private String convertLinksToJson(List<Entity> links) throws JsonProcessingException {
        TestToRunDataCollection collection = new TestToRunDataCollection();
        for (Entity link : links) {
            TestToRunData data = new TestToRunData();
            Entity test = (Entity)link.getField("test");
            data.setPackageName(test.getStringValue("package"));
            data.setClassName(test.getStringValue("class_name"));
            data.setTestName(test.getStringValue("name"));
            if (test.containsFieldAndValue("automation_identifier")) {
                data.addParameters("featureFilePath", test.getStringValue("automation_identifier"));
            }
            if (test.containsFieldAndValue("external_test_id")) {
                data.addParameters("external_test_id", test.getStringValue("external_test_id"));
            }
            if (test.containsFieldAndValue("data_table")) {
                data.addParameters("featureFilePath", link.getEntityValue("data_table").getStringValue("relative_path"));
            }
            if (test.containsFieldAndValue("execution_parameters")) {
                String[] parts;
                for (String part : parts = link.getStringValue("execution_parameters").split("[\n;]")) {
                    String myPart = part.trim();
                    int splitterIndex = myPart.indexOf(61);
                    if (myPart.isEmpty() || myPart.startsWith("#") || splitterIndex == -1) continue;
                    String name = myPart.substring(0, splitterIndex).trim();
                    String value = myPart.substring(splitterIndex + 1).trim();
                    data.addParameters(name, value);
                }
            }
            collection.getTestsToRun().add(data);
        }
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        return objectMapper.writeValueAsString((Object)collection);
    }

    private List<Entity> getTestRunners(Long workspaceId, Collection<String> ids) {
        List<String> fields = Arrays.asList("ci_job", "name", "ci_server{instance_id}");
        List<Entity> entities = this.entitiesService.getEntitiesByIds(workspaceId, "executors", ids, fields);
        return entities;
    }
}

