/*
 * Decompiled with CFR 0.152.
 */
package com.hp.octane.integrations.services.sonar;

import com.fasterxml.jackson.databind.JsonNode;
import com.hp.octane.integrations.exceptions.PermanentException;
import com.hp.octane.integrations.exceptions.TemporaryException;
import java.io.InputStream;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthenticationException;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.conn.HttpHostConnectException;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SonarUtils {
    private static final Logger logger = LogManager.getLogger(SonarUtils.class);

    public static InputStream getDataFromSonar(String projectKey, String token, URIBuilder uriQuery) {
        StringBuilder errorMessage = new StringBuilder().append("failed to get data from sonar for project key: ").append(projectKey);
        try {
            CloseableHttpClient httpClient = HttpClientBuilder.create().build();
            HttpGet request = new HttpGet(uriQuery.build());
            SonarUtils.setTokenInHttpRequest((HttpRequest)request, token);
            HttpResponse httpResponse = httpClient.execute((HttpUriRequest)request);
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode == 200) {
                logger.info("SonarUtils success getDataFromSonar");
                return httpResponse.getEntity().getContent();
            }
            if (statusCode == 400) {
                errorMessage.append(" with status code: ").append(statusCode).append(" and response body: ").append(EntityUtils.toString((HttpEntity)httpResponse.getEntity(), (String)"UTF-8"));
                throw new TemporaryException(errorMessage.toString());
            }
            errorMessage.append(" with status code: ").append(statusCode).append(" and response body: ").append(EntityUtils.toString((HttpEntity)httpResponse.getEntity(), (String)"UTF-8"));
            throw new PermanentException(errorMessage.toString());
        }
        catch (HttpHostConnectException e) {
            throw new TemporaryException(errorMessage.toString(), e);
        }
        catch (Exception e) {
            throw new PermanentException(errorMessage.toString(), e);
        }
    }

    public static Boolean sonarReportHasAnotherPage(Integer pageIndex, JsonNode jsonContent) {
        JsonNode pagingNode = jsonContent.get("paging");
        Integer pageSize = pagingNode.get("pageSize").intValue();
        int total = pagingNode.get("total").intValue();
        return pageSize * pageIndex < total;
    }

    private static void setTokenInHttpRequest(HttpRequest request, String token) throws AuthenticationException {
        UsernamePasswordCredentials creds = new UsernamePasswordCredentials(token, "");
        request.addHeader(new BasicScheme().authenticate((Credentials)creds, request, null));
    }
}

