/*
 * Decompiled with CFR 0.152.
 */
package com.hp.octane.integrations.services.pullrequestsandbranches.rest;

import com.hp.octane.integrations.dto.DTOFactory;
import com.hp.octane.integrations.dto.configuration.CIProxyConfiguration;
import com.hp.octane.integrations.dto.connectivity.HttpMethod;
import com.hp.octane.integrations.dto.connectivity.OctaneRequest;
import com.hp.octane.integrations.dto.connectivity.OctaneResponse;
import com.hp.octane.integrations.services.pullrequestsandbranches.rest.authentication.AuthenticationStrategy;
import com.hp.octane.integrations.utils.CIPluginSDKUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CookieStore;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.GzipCompressingEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.client.utils.HttpClientUtils;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.client.SystemDefaultCredentialsProvider;
import org.apache.http.message.BasicHeader;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class GeneralRestClient {
    private final String CONTENT_ENCODING_HEADER = "content-encoding";
    private final String GZIP_ENCODING = "gzip";
    private static final Logger logger = LogManager.getLogger(GeneralRestClient.class);
    private final CloseableHttpClient httpClient;
    private final AuthenticationStrategy authentication;

    public GeneralRestClient(AuthenticationStrategy authentication) {
        this.authentication = authentication;
        this.httpClient = HttpClients.createDefault();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OctaneResponse executeRequest(OctaneRequest request) throws IOException {
        OctaneResponse result;
        if (this.authentication.isAuthenticationNeeded()) {
            this.authentication.authenticate((HttpClient)this.httpClient, false);
        }
        CloseableHttpResponse httpResponse = null;
        try {
            for (int i = 0; i < 2; ++i) {
                HttpUriRequest uriRequest = this.createHttpRequest(request);
                HttpClientContext context = this.createHttpContext(request.getUrl(), request.getTimeoutSec());
                httpResponse = this.httpClient.execute(uriRequest, (HttpContext)context);
                int statusCode = httpResponse.getStatusLine().getStatusCode();
                if (i == 0 && 401 == statusCode && this.authentication.supportAuthenticationOnUnauthorizedException()) {
                    EntityUtils.consumeQuietly((HttpEntity)httpResponse.getEntity());
                    HttpClientUtils.closeQuietly((HttpResponse)httpResponse);
                    if (this.authentication.authenticate((HttpClient)this.httpClient, true)) continue;
                    break;
                }
                this.authentication.onResponse((HttpResponse)httpResponse, context);
                break;
            }
            result = this.createResponse((HttpResponse)httpResponse);
        }
        finally {
            if (httpResponse != null) {
                EntityUtils.consumeQuietly((HttpEntity)httpResponse.getEntity());
                HttpClientUtils.closeQuietly(httpResponse);
            }
        }
        return result;
    }

    private OctaneResponse createResponse(HttpResponse response) throws IOException {
        OctaneResponse octaneResponse = ((OctaneResponse)DTOFactory.getInstance().newDTO(OctaneResponse.class)).setStatus(response.getStatusLine().getStatusCode());
        if (response.getEntity() != null) {
            octaneResponse.setBody(CIPluginSDKUtils.inputStreamToUTF8String(response.getEntity().getContent()));
        }
        if (response.getAllHeaders() != null && response.getAllHeaders().length > 0) {
            HashMap<String, String> mapHeaders = new HashMap<String, String>();
            for (Header header : response.getAllHeaders()) {
                mapHeaders.put(header.getName(), header.getValue());
            }
            octaneResponse.setHeaders(mapHeaders);
        }
        return octaneResponse;
    }

    private HttpUriRequest createHttpRequest(OctaneRequest octaneRequest) {
        RequestBuilder requestBuilder;
        if (octaneRequest.getMethod().equals((Object)HttpMethod.GET)) {
            requestBuilder = RequestBuilder.get((String)octaneRequest.getUrl());
        } else if (octaneRequest.getMethod().equals((Object)HttpMethod.DELETE)) {
            requestBuilder = RequestBuilder.delete((String)octaneRequest.getUrl());
        } else if (octaneRequest.getMethod().equals((Object)HttpMethod.POST)) {
            requestBuilder = RequestBuilder.post((String)octaneRequest.getUrl());
            requestBuilder.addHeader((Header)new BasicHeader("content-encoding", "gzip"));
            requestBuilder.setEntity((HttpEntity)new GzipCompressingEntity((HttpEntity)new InputStreamEntity(octaneRequest.getBody(), ContentType.APPLICATION_JSON)));
        } else if (octaneRequest.getMethod().equals((Object)HttpMethod.PUT)) {
            requestBuilder = RequestBuilder.put((String)octaneRequest.getUrl());
            requestBuilder.addHeader((Header)new BasicHeader("content-encoding", "gzip"));
            requestBuilder.setEntity((HttpEntity)new GzipCompressingEntity((HttpEntity)new InputStreamEntity(octaneRequest.getBody(), ContentType.APPLICATION_JSON)));
        } else {
            throw new RuntimeException("HTTP method " + octaneRequest.getMethod() + " not supported");
        }
        if (octaneRequest.getHeaders() != null) {
            for (Map.Entry e : octaneRequest.getHeaders().entrySet()) {
                requestBuilder.setHeader((String)e.getKey(), (String)e.getValue());
            }
        }
        this.authentication.onCreateHttpRequest(requestBuilder);
        HttpUriRequest request = requestBuilder.build();
        return request;
    }

    private HttpClientContext createHttpContext(String requestUrl, int requestTimeoutSec) {
        HttpClientContext context = HttpClientContext.create();
        context.setCookieStore((CookieStore)new BasicCookieStore());
        RequestConfig.Builder requestConfigBuilder = RequestConfig.custom().setCookieSpec("standard");
        CIProxyConfiguration proxyConfiguration = CIPluginSDKUtils.getProxyConfiguration(requestUrl, null);
        if (proxyConfiguration != null) {
            HttpHost proxyHost = new HttpHost(proxyConfiguration.getHost(), proxyConfiguration.getPort().intValue());
            if (proxyConfiguration.getUsername() != null && !proxyConfiguration.getUsername().isEmpty()) {
                AuthScope authScope = new AuthScope(proxyHost);
                UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(proxyConfiguration.getUsername(), proxyConfiguration.getPassword());
                SystemDefaultCredentialsProvider credentialsProvider = new SystemDefaultCredentialsProvider();
                credentialsProvider.setCredentials(authScope, (Credentials)credentials);
                context.setCredentialsProvider((CredentialsProvider)credentialsProvider);
            }
            requestConfigBuilder.setProxy(proxyHost);
        }
        if (requestTimeoutSec > 0) {
            int timeoutMs = requestTimeoutSec * 1000;
            requestConfigBuilder.setConnectTimeout(timeoutMs).setConnectionRequestTimeout(timeoutMs).setSocketTimeout(timeoutMs);
        }
        context.setRequestConfig(requestConfigBuilder.build());
        this.authentication.onCreateContext(context);
        return context;
    }

    public void shutdown() {
        HttpClientUtils.closeQuietly((HttpClient)this.httpClient);
    }
}

