/*
 * Decompiled with CFR 0.152.
 */
package com.hp.octane.integrations.services.pullrequestsandbranches.github;

import com.hp.octane.integrations.services.pullrequestsandbranches.github.GithubV3FetchHandler;
import com.hp.octane.integrations.services.pullrequestsandbranches.rest.authentication.AuthenticationStrategy;
import java.util.Arrays;
import java.util.List;

public class GithubCloudFetchHandler
extends GithubV3FetchHandler {
    public GithubCloudFetchHandler(AuthenticationStrategy authenticationStrategy) {
        super(authenticationStrategy);
    }

    @Override
    public String getRepoApiPath(String repoHttpCloneUrl) {
        this.validateHttpCloneUrl(repoHttpCloneUrl);
        if (!repoHttpCloneUrl.toLowerCase().startsWith("https://github.com/")) {
            throw new IllegalArgumentException("Unexpected github cloud repository URL : " + repoHttpCloneUrl + ". Git Cloud URL must start with : https://github.com/. ");
        }
        List<String> parts = Arrays.asList(repoHttpCloneUrl.trim().substring("https://github.com/".length()).split("/"));
        if (parts.size() != 2) {
            throw new IllegalArgumentException("Unexpected github cloud repository URL : " + repoHttpCloneUrl + ". Expected format : https://github.com/<user_name>/<repo_name>.git");
        }
        String user = parts.get(parts.size() - 2);
        String repoName = parts.get(parts.size() - 1);
        repoName = repoName.substring(0, repoName.length() - ".git".length());
        return String.format("https://api.github.com/repos/%s/%s", user, repoName);
    }

    @Override
    public String getApiPath(String repoHttpCloneUrl) {
        return "https://api.github.com";
    }
}

