/*
 * Decompiled with CFR 0.152.
 */
package com.hp.octane.integrations.services.logs;

import com.hp.octane.integrations.OctaneConfiguration;
import com.hp.octane.integrations.OctaneSDK;
import com.hp.octane.integrations.dto.DTOFactory;
import com.hp.octane.integrations.dto.connectivity.HttpMethod;
import com.hp.octane.integrations.dto.connectivity.OctaneRequest;
import com.hp.octane.integrations.dto.connectivity.OctaneResponse;
import com.hp.octane.integrations.exceptions.PermanentException;
import com.hp.octane.integrations.exceptions.TemporaryException;
import com.hp.octane.integrations.services.WorkerPreflight;
import com.hp.octane.integrations.services.configuration.ConfigurationService;
import com.hp.octane.integrations.services.configuration.ConfigurationServiceImpl;
import com.hp.octane.integrations.services.configurationparameters.factory.ConfigurationParameterFactory;
import com.hp.octane.integrations.services.logs.LogsService;
import com.hp.octane.integrations.services.queueing.QueueingService;
import com.hp.octane.integrations.services.rest.RestService;
import com.hp.octane.integrations.utils.CIPluginSDKUtils;
import com.squareup.tape.ObjectQueue;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

final class LogsServiceImpl
implements LogsService {
    private static final Logger logger = LogManager.getLogger(LogsServiceImpl.class);
    private static final DTOFactory dtoFactory = DTOFactory.getInstance();
    private static final String BUILD_LOG_QUEUE_FILE = "build-logs-queue.dat";
    private final ExecutorService logsPushExecutor = Executors.newSingleThreadExecutor(new BuildLogsPushWorkerThreadFactory());
    private final ObjectQueue<BuildLogQueueItem> buildLogsQueue;
    private final OctaneSDK.SDKServicesConfigurer configurer;
    private final RestService restService;
    private final WorkerPreflight workerPreflight;
    private final ConfigurationService configurationService;
    private int TEMPORARY_ERROR_BREATHE_INTERVAL = 15000;

    LogsServiceImpl(OctaneSDK.SDKServicesConfigurer configurer, QueueingService queueingService, RestService restService, ConfigurationService configurationService) {
        if (configurer == null || configurer.pluginServices == null || configurer.octaneConfiguration == null) {
            throw new IllegalArgumentException("invalid configurer");
        }
        if (queueingService == null) {
            throw new IllegalArgumentException("queue service MUST NOT be null");
        }
        if (restService == null) {
            throw new IllegalArgumentException("rest service MUST NOT be null");
        }
        if (configurationService == null) {
            throw new IllegalArgumentException("configuration service MUST NOT be null");
        }
        this.buildLogsQueue = queueingService.isPersistenceEnabled() ? queueingService.initFileQueue(BUILD_LOG_QUEUE_FILE, BuildLogQueueItem.class) : queueingService.initMemoQueue();
        this.configurer = configurer;
        this.restService = restService;
        this.configurationService = configurationService;
        this.workerPreflight = new WorkerPreflight(this, configurationService, logger);
        logger.info(configurer.octaneConfiguration.getLocationForLog() + "starting background worker...");
        this.logsPushExecutor.execute(this::worker);
        logger.info(configurer.octaneConfiguration.getLocationForLog() + "initialized SUCCESSFULLY (backed by " + this.buildLogsQueue.getClass().getSimpleName() + ")");
    }

    @Override
    public void enqueuePushBuildLog(String jobId, String buildId, String rootJobId) {
        if (jobId == null || jobId.isEmpty()) {
            throw new IllegalArgumentException("job ID MUST NOT be null nor empty");
        }
        if (buildId == null || buildId.isEmpty()) {
            throw new IllegalArgumentException("build ID MUST NOT be null nor empty");
        }
        if (this.configurer.octaneConfiguration.isDisabled()) {
            return;
        }
        if (!((ConfigurationServiceImpl)this.configurationService).isRelevantForOctane(rootJobId)) {
            return;
        }
        this.buildLogsQueue.add((Object)new BuildLogQueueItem(jobId, buildId, rootJobId));
        this.workerPreflight.itemAddedToQueue();
    }

    @Override
    public void shutdown() {
        this.logsPushExecutor.shutdown();
    }

    @Override
    public boolean isShutdown() {
        return this.logsPushExecutor.isShutdown();
    }

    private void worker() {
        while (!this.logsPushExecutor.isShutdown()) {
            if (!this.workerPreflight.preflight()) continue;
            BuildLogQueueItem buildLogQueueItem = null;
            try {
                buildLogQueueItem = (BuildLogQueueItem)this.buildLogsQueue.peek();
                this.pushBuildLog(this.configurer.octaneConfiguration.getInstanceId(), buildLogQueueItem);
                logger.debug(this.configurer.octaneConfiguration.getLocationForLog() + "successfully processed " + buildLogQueueItem);
                this.buildLogsQueue.remove();
            }
            catch (TemporaryException tque) {
                logger.error(this.configurer.octaneConfiguration.getLocationForLog() + "temporary error on " + buildLogQueueItem + ", breathing " + this.TEMPORARY_ERROR_BREATHE_INTERVAL + "ms and retrying");
                CIPluginSDKUtils.doWait(this.TEMPORARY_ERROR_BREATHE_INTERVAL);
            }
            catch (PermanentException pqie) {
                logger.error(this.configurer.octaneConfiguration.getLocationForLog() + "permanent error on " + buildLogQueueItem + ", passing over", (Throwable)pqie);
                this.buildLogsQueue.remove();
            }
            catch (Throwable t) {
                logger.error(this.configurer.octaneConfiguration.getLocationForLog() + "unexpected error on build log item '" + buildLogQueueItem + "', passing over", t);
                this.buildLogsQueue.remove();
            }
        }
    }

    private void pushBuildLog(String serverId, BuildLogQueueItem queueItem) {
        String encodedRootJobId;
        OctaneConfiguration octaneConfiguration = this.configurer.octaneConfiguration;
        String encodedServerId = CIPluginSDKUtils.urlEncodePathParam(serverId);
        String encodedBuildId = CIPluginSDKUtils.urlEncodePathParam(queueItem.buildId);
        boolean base64 = this.isEncodeBase64();
        String encodedJobId = base64 ? CIPluginSDKUtils.urlEncodeBase64(queueItem.jobId) : CIPluginSDKUtils.urlEncodePathParam(queueItem.jobId);
        String[] workspaceIDs = this.preflightRequest(octaneConfiguration, encodedServerId, encodedJobId, encodedRootJobId = base64 ? CIPluginSDKUtils.urlEncodeBase64(queueItem.rootJobId) : CIPluginSDKUtils.urlEncodeQueryParam(queueItem.rootJobId), base64);
        if (workspaceIDs.length == 0) {
            logger.info(this.configurer.octaneConfiguration.getLocationForLog() + "log of " + queueItem + ", no interested workspace is found");
            return;
        }
        logger.info(this.configurer.octaneConfiguration.getLocationForLog() + "log of " + queueItem + ", found " + workspaceIDs.length + " interested workspace/s");
        for (String workspaceId : workspaceIDs) {
            OctaneResponse response;
            InputStream log;
            String url = octaneConfiguration.getUrl() + "/internal-api/shared_spaces/" + octaneConfiguration.getSharedSpace() + "/workspaces/" + workspaceId + "/analytics/ci/" + encodedServerId + "/" + encodedJobId + "/" + encodedBuildId + "/logs";
            if (base64) {
                url = CIPluginSDKUtils.addParameterEncode64ToUrl(url);
            }
            String correlationId = CIPluginSDKUtils.getNextCorrelationId();
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("X-Correlation-ID", correlationId);
            OctaneRequest request = ((OctaneRequest)dtoFactory.newDTO(OctaneRequest.class)).setMethod(HttpMethod.POST).setHeaders(headers).setUrl(url);
            try {
                log = this.configurer.pluginServices.getBuildLog(queueItem.jobId, queueItem.buildId);
                if (log == null) {
                    logger.info(this.configurer.octaneConfiguration.getLocationForLog() + "no log for " + queueItem + " found, abandoning");
                    break;
                }
                request.setBody(log);
                response = this.restService.obtainOctaneRestClient().execute(request);
                if (response.getStatus() == 200) {
                    logger.info(this.configurer.octaneConfiguration.getLocationForLog() + "successfully pushed log of " + queueItem + " to WS " + workspaceId + ", correlation Id = " + correlationId);
                    continue;
                }
                logger.error(this.configurer.octaneConfiguration.getLocationForLog() + "failed to push log of " + queueItem + " to WS " + workspaceId + ", status: " + response.getStatus() + ", correlation Id = " + correlationId);
            }
            catch (IOException ioe) {
                logger.error(this.configurer.octaneConfiguration.getLocationForLog() + "failed to push log of " + queueItem + " to WS " + workspaceId + ", breathing " + this.TEMPORARY_ERROR_BREATHE_INTERVAL + "ms and retrying one more time due to IOException", (Throwable)ioe);
                CIPluginSDKUtils.doWait(this.TEMPORARY_ERROR_BREATHE_INTERVAL);
                log = this.configurer.pluginServices.getBuildLog(queueItem.jobId, queueItem.buildId);
                if (log == null) {
                    logger.info(this.configurer.octaneConfiguration.getLocationForLog() + "no log for " + queueItem + " found, abandoning");
                    break;
                }
                request.setBody(log);
                try {
                    response = this.restService.obtainOctaneRestClient().execute(request);
                    if (response.getStatus() == 200) {
                        logger.info(this.configurer.octaneConfiguration.getLocationForLog() + "successfully pushed log of " + queueItem + " to WS " + workspaceId);
                        continue;
                    }
                    logger.error(this.configurer.octaneConfiguration.getLocationForLog() + "failed to push log of " + queueItem + " to WS " + workspaceId + ", status: " + response.getStatus());
                }
                catch (IOException ioem) {
                    logger.error(this.configurer.octaneConfiguration.getLocationForLog() + "failed to push log of " + queueItem + " to WS " + workspaceId + " for the second time, abandoning", (Throwable)ioem);
                }
            }
        }
    }

    private boolean isEncodeBase64() {
        return ConfigurationParameterFactory.isEncodeCiJobBase64(this.configurer.octaneConfiguration);
    }

    private String[] preflightRequest(OctaneConfiguration octaneConfiguration, String encodedServerId, String encodedJobId, String encodedRootJobId, boolean base64) {
        OctaneResponse response;
        String[] result = new String[]{};
        String url = this.getAnalyticsContextPath(this.configurer.octaneConfiguration.getUrl(), octaneConfiguration.getSharedSpace()) + "servers/" + encodedServerId + "/jobs/" + encodedJobId + "/workspaceId";
        if (encodedRootJobId != null && !encodedRootJobId.isEmpty()) {
            url = url + "?rootJobId=" + encodedRootJobId;
        }
        if (base64) {
            url = CIPluginSDKUtils.addParameterEncode64ToUrl(url);
        }
        try {
            OctaneRequest preflightRequest = ((OctaneRequest)dtoFactory.newDTO(OctaneRequest.class)).setMethod(HttpMethod.GET).setUrl(url);
            response = this.restService.obtainOctaneRestClient().execute(preflightRequest);
            if (response.getStatus() == 503 || response.getStatus() == 502 || response.getStatus() == 429) {
                throw new TemporaryException("preflight request failed with status " + response.getStatus());
            }
            if (response.getStatus() == 401 || response.getStatus() == 403) {
                CIPluginSDKUtils.doWait(30000L);
                throw new PermanentException("preflight request failed with status " + response.getStatus());
            }
            if (response.getStatus() != 200 && response.getStatus() != 204) {
                throw new PermanentException("preflight request failed with status " + response.getStatus() + ". JobId: '" + encodedJobId + "'. Request URL : " + url);
            }
        }
        catch (IOException ioe) {
            throw new TemporaryException(ioe);
        }
        if (response.getBody() != null && !response.getBody().isEmpty()) {
            try {
                result = (String[])CIPluginSDKUtils.getObjectMapper().readValue(response.getBody(), String[].class);
            }
            catch (IOException ioe) {
                if (CIPluginSDKUtils.isServiceTemporaryUnavailable(response.getBody())) {
                    throw new TemporaryException("Saas service is temporary unavailable.");
                }
                throw new PermanentException("failed to parse preflight response '" + response.getBody() + "' for '" + encodedJobId + "'");
            }
        }
        return result;
    }

    private String getAnalyticsContextPath(String octaneBaseUrl, String sharedSpaceId) {
        return octaneBaseUrl + "/internal-api/shared_spaces/" + sharedSpaceId + "/analytics/ci/";
    }

    @Override
    public long getQueueSize() {
        return this.buildLogsQueue.size();
    }

    @Override
    public void clearQueue() {
        while (this.buildLogsQueue.size() > 0) {
            this.buildLogsQueue.remove();
        }
    }

    @Override
    public Map<String, Object> getMetrics() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("queueSize", this.getQueueSize());
        this.workerPreflight.addMetrics(map);
        return map;
    }

    private static final class BuildLogsPushWorkerThreadFactory
    implements ThreadFactory {
        private BuildLogsPushWorkerThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable runnable) {
            Thread result = new Thread(runnable);
            result.setName("BuildLogsPushWorker-" + result.getId());
            result.setDaemon(true);
            return result;
        }
    }

    private static final class BuildLogQueueItem
    implements QueueingService.QueueItem {
        private String jobId;
        private String buildId;
        private String rootJobId;

        private BuildLogQueueItem() {
        }

        private BuildLogQueueItem(String jobId, String buildId, String rootJobId) {
            this.jobId = jobId;
            this.buildId = buildId;
            this.rootJobId = rootJobId;
        }

        public String toString() {
            return "'" + this.jobId + " #" + this.buildId + "', root job : " + this.rootJobId;
        }
    }
}

