/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.sse.sdk.request;

import com.microfocus.application.automation.tools.sse.common.RestXmlUtils;
import com.microfocus.application.automation.tools.sse.sdk.Client;
import com.microfocus.application.automation.tools.sse.sdk.ResourceAccessLevel;
import com.microfocus.application.automation.tools.sse.sdk.Response;
import com.microfocus.application.automation.tools.sse.sdk.request.GeneralRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class GeneralPutBulkRequest
extends GeneralRequest {
    protected GeneralPutBulkRequest(Client client) {
        super(client);
    }

    protected abstract List<Map<String, String>> getFields();

    @Override
    protected Map<String, String> getHeaders() {
        HashMap<String, String> ret = new HashMap<String, String>();
        ret.put("Content-Type", "application/xml;type=collection");
        ret.put("Accept", "application/xml");
        ret.put("X-XSRF-TOKEN", this._client.getXsrfTokenValue());
        return ret;
    }

    @Override
    protected Response perform() {
        return this._client.httpPut(this.getUrl(), this.getDataBytes(), this.getHeaders(), ResourceAccessLevel.PROTECTED);
    }

    private byte[] getDataBytes() {
        StringBuilder builder = new StringBuilder("<Entities>");
        for (Map<String, String> values : this.getFields()) {
            builder.append("<Entity><Fields>");
            for (String key : values.keySet()) {
                builder.append(RestXmlUtils.fieldXml(key, values.get(key)));
            }
            builder.append("</Fields></Entity>");
        }
        return builder.append("</Entities>").toString().getBytes();
    }
}

