/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.sse.sdk.handler;

import com.microfocus.application.automation.tools.sse.sdk.Client;
import com.microfocus.application.automation.tools.sse.sdk.Logger;
import com.microfocus.application.automation.tools.sse.sdk.Response;
import com.microfocus.application.automation.tools.sse.sdk.handler.Handler;

public abstract class PollHandler
extends Handler {
    private int _interval = 5000;

    public PollHandler(Client client, String entityId) {
        super(client, entityId);
    }

    public PollHandler(Client client, String entityId, int interval) {
        super(client, entityId);
        this._interval = interval;
    }

    public PollHandler(Client client, String entityId, String runId) {
        super(client, entityId, runId);
    }

    public boolean poll(Logger logger) throws InterruptedException {
        logger.log(String.format("Polling... Run ID: %s", this._runId));
        return this.doPoll(logger);
    }

    protected boolean doPoll(Logger logger) throws InterruptedException {
        boolean ret = false;
        int failures = 0;
        while (failures < 3) {
            Response response = this.getResponse();
            if (this.isOk(response, logger)) {
                this.log(logger);
                if (this.isFinished(response, logger)) {
                    ret = true;
                    this.logRunEntityResults(this.getRunEntityResultsResponse(), logger);
                    break;
                }
            } else {
                ++failures;
            }
            if (!this.sleep(logger)) continue;
            break;
        }
        return ret;
    }

    protected abstract Response getRunEntityResultsResponse();

    protected abstract boolean logRunEntityResults(Response var1, Logger var2);

    protected abstract boolean isFinished(Response var1, Logger var2);

    protected abstract Response getResponse();

    protected boolean isOk(Response response, Logger logger) {
        boolean ret = false;
        if (!response.isOk()) {
            Throwable cause = response.getFailure();
            logger.log(String.format("Polling try failed. Status code: %s, Exception: %s", response.getStatusCode(), cause != null ? cause.getMessage() : "Not Available"));
        } else {
            ret = true;
        }
        return ret;
    }

    protected boolean sleep(Logger logger) throws InterruptedException {
        boolean ret = false;
        try {
            Thread.sleep(this._interval);
        }
        catch (InterruptedException ex) {
            logger.log("Interrupted while polling");
            throw ex;
        }
        return ret;
    }

    protected void log(Logger logger) {
    }
}

