/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.sse.sdk.authenticator;

import com.microfocus.application.automation.tools.sse.sdk.Client;
import com.microfocus.application.automation.tools.sse.sdk.Logger;
import com.microfocus.application.automation.tools.sse.sdk.ResourceAccessLevel;
import com.microfocus.application.automation.tools.sse.sdk.Response;
import com.microfocus.application.automation.tools.sse.sdk.authenticator.Authenticator;
import java.util.HashMap;

public class ApiKeyAuthenticator
implements Authenticator {
    private static final String APIKEY_LOGIN_API = "rest/oauth2/login";
    private static final String CLIENT_TYPE = "ALM-CLIENT-TYPE";

    @Override
    public boolean login(Client client, String clientId, String secret, String clientType, Logger logger) {
        logger.log("Start login to ALM server with APIkey...");
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put(CLIENT_TYPE, clientType);
        headers.put("Accept", "application/json");
        headers.put("Content-Type", "application/json");
        Response response = client.httpPost(client.build(APIKEY_LOGIN_API), String.format("{clientId:%s, secret:%s}", clientId, secret).getBytes(), headers, ResourceAccessLevel.PUBLIC);
        boolean result = response.isOk();
        logger.log(result ? String.format("Logged in successfully to ALM Server %s using %s", client.getServerUrl(), clientId) : String.format("Login to ALM Server at %s failed. Status Code: %s", client.getServerUrl(), response.getStatusCode()));
        return result;
    }

    @Override
    public boolean logout(Client client, String username) {
        return true;
    }
}

