/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.sse.sdk;

import com.microfocus.application.automation.tools.common.SSEException;
import com.microfocus.application.automation.tools.sse.sdk.ResourceAccessLevel;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Map;

public class HttpRequestDecorator {
    public static void decorateHeaderWithUserInfo(Map<String, String> headers, String userName, ResourceAccessLevel resourceAccessLevel) {
        if (headers == null) {
            throw new IllegalArgumentException("header must not be null");
        }
        if (resourceAccessLevel.equals((Object)ResourceAccessLevel.PROTECTED) || resourceAccessLevel.equals((Object)ResourceAccessLevel.PRIVATE)) {
            String userHeaderName = resourceAccessLevel.getUserHeaderName();
            String encryptedUserName = HttpRequestDecorator.getDigestString("MD5", userName);
            if (userHeaderName != null) {
                headers.put(userHeaderName, encryptedUserName);
            }
        }
    }

    private static String getDigestString(String algorithmName, String dataToDigest) {
        try {
            MessageDigest md = MessageDigest.getInstance(algorithmName);
            byte[] digested = md.digest(dataToDigest.getBytes());
            return HttpRequestDecorator.digestToString(digested);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new SSEException(ex);
        }
    }

    private static String digestToString(byte[] b) {
        StringBuilder result = new StringBuilder(128);
        for (byte aB : b) {
            result.append(Integer.toString((aB & 0xFF) + 256, 16).substring(1));
        }
        return result.toString();
    }
}

