/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.settings;

import hudson.EnvVars;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.TaskListener;
import hudson.tasks.BuildWrapper;
import hudson.tasks.BuildWrapperDescriptor;
import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class OutputEnvironmentVariablesBuildWrapper
extends BuildWrapper
implements Serializable {
    private String outputEnvironmentParameters;

    @DataBoundConstructor
    public OutputEnvironmentVariablesBuildWrapper(String outputEnvironmentParameters) {
        this.setOutputEnvironmentParameters(outputEnvironmentParameters);
    }

    public String getOutputEnvironmentParameters() {
        return this.outputEnvironmentParameters;
    }

    @DataBoundSetter
    public void setOutputEnvironmentParameters(String outputEnvironmentParameters) {
        this.outputEnvironmentParameters = outputEnvironmentParameters;
    }

    public BuildWrapper.Environment setUp(AbstractBuild build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        final EnvVars envVars = build.getEnvironment((TaskListener)listener);
        return new BuildWrapper.Environment(){

            public void buildEnvVars(Map<String, String> env) {
                env.putAll((Map<String, String>)envVars);
            }
        };
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildWrapperDescriptor {
        public boolean isApplicable(AbstractProject<?, ?> item) {
            return true;
        }

        public String getDisplayName() {
            return "Define a list of environment variables to store in ValueEdge / Software Delivery Management";
        }
    }
}

