/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.settings;

import com.microfocus.application.automation.tools.model.MCServerSettingsModel;
import com.microfocus.application.automation.tools.settings.ConfigurationMigrationUtil;
import hudson.Extension;
import hudson.XmlFile;
import hudson.model.Descriptor;
import hudson.util.FormValidation;
import java.io.Serializable;
import jenkins.model.GlobalConfiguration;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

@Extension(ordinal=1.0)
public class MCServerSettingsGlobalConfiguration
extends GlobalConfiguration
implements Serializable {
    private MCServerSettingsModel[] installations = new MCServerSettingsModel[0];

    public MCServerSettingsGlobalConfiguration() {
        this.load();
    }

    public static MCServerSettingsGlobalConfiguration getInstance() {
        return (MCServerSettingsGlobalConfiguration)GlobalConfiguration.all().get(MCServerSettingsGlobalConfiguration.class);
    }

    protected XmlFile getConfigFile() {
        XmlFile xmlFile = super.getConfigFile();
        ConfigurationMigrationUtil.migrateConfigurationFileIfRequired(xmlFile, "com.microfocus.application.automation.tools.settings.MCServerSettingsBuilder.xml", "MCServerSettingsBuilder_-MCDescriptorImpl", "MCServerSettingsGlobalConfiguration");
        return xmlFile;
    }

    public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
        this.setInstallations(req.bindParametersToList(MCServerSettingsModel.class, "mc.").toArray(new MCServerSettingsModel[0]));
        this.save();
        return super.configure(req, formData);
    }

    public FormValidation doCheckMCServerName(@QueryParameter String value) {
        FormValidation ret = FormValidation.ok();
        if (StringUtils.isBlank((String)value)) {
            ret = FormValidation.error((String)"Functional Testing Lab server name cannot be empty");
        }
        return ret;
    }

    public FormValidation doCheckMCServerURL(@QueryParameter String value) {
        FormValidation ret = FormValidation.ok();
        if (StringUtils.isBlank((String)value)) {
            ret = FormValidation.error((String)"Functional Testing Lab server cannot be empty");
        }
        return ret;
    }

    public MCServerSettingsModel[] getInstallations() {
        return this.installations;
    }

    public void setInstallations(MCServerSettingsModel ... installations) {
        this.installations = installations;
    }

    public Boolean hasMCServers() {
        return this.installations.length > 0;
    }
}

