/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.run;

import com.microfocus.application.automation.tools.model.SvServerSettingsModel;
import com.microfocus.application.automation.tools.model.SvServiceSelectionModel;
import com.microfocus.application.automation.tools.model.SvUndeployModel;
import com.microfocus.application.automation.tools.sv.runner.AbstractSvRemoteRunner;
import com.microfocus.application.automation.tools.sv.runner.AbstractSvRunBuilder;
import com.microfocus.application.automation.tools.sv.runner.AbstractSvRunDescriptor;
import com.microfocus.application.automation.tools.sv.runner.ServiceInfo;
import com.microfocus.sv.svconfigurator.processor.UndeployProcessor;
import com.microfocus.sv.svconfigurator.processor.UndeployProcessorInput;
import com.microfocus.sv.svconfigurator.serverclient.ICommandExecutor;
import hudson.Extension;
import hudson.FilePath;
import hudson.model.TaskListener;
import java.io.PrintStream;
import javax.annotation.Nonnull;
import org.kohsuke.stapler.DataBoundConstructor;

public class SvUndeployBuilder
extends AbstractSvRunBuilder<SvUndeployModel> {
    @DataBoundConstructor
    public SvUndeployBuilder(String serverName, boolean continueIfNotDeployed, boolean force, SvServiceSelectionModel serviceSelection) {
        super(new SvUndeployModel(serverName, continueIfNotDeployed, force, serviceSelection));
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    protected RemoteRunner getRemoteRunner(@Nonnull FilePath workspace, TaskListener listener, SvServerSettingsModel server) {
        return new RemoteRunner((SvUndeployModel)this.model, workspace, listener, server);
    }

    @Override
    protected void logConfig(PrintStream logger, String prefix) {
        super.logConfig(logger, prefix);
        logger.println(prefix + "Continue if not deployed: " + ((SvUndeployModel)this.model).isContinueIfNotDeployed());
    }

    @Extension
    public static final class DescriptorImpl
    extends AbstractSvRunDescriptor {
        public DescriptorImpl() {
            super("SV: Undeploy Virtual Service");
        }
    }

    private static class RemoteRunner
    extends AbstractSvRemoteRunner<SvUndeployModel> {
        private RemoteRunner(SvUndeployModel model, FilePath workspace, TaskListener listener, SvServerSettingsModel server) {
            super(listener, model, workspace, server);
        }

        public String call() throws Exception {
            PrintStream logger = this.listener.getLogger();
            UndeployProcessor processor = new UndeployProcessor(null);
            ICommandExecutor exec = this.createCommandExecutor();
            for (ServiceInfo service : this.getServiceList(((SvUndeployModel)this.model).isContinueIfNotDeployed(), logger, this.workspace)) {
                logger.printf("  Undeploying service '%s' [%s] %n", service.getName(), service.getId());
                UndeployProcessorInput undeployProcessorInput = new UndeployProcessorInput(((SvUndeployModel)this.model).isForce(), null, service.getId());
                processor.process(undeployProcessorInput, exec);
            }
            return null;
        }
    }
}

