/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.run;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardUsernameListBoxModel;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.cloudbees.plugins.credentials.common.UsernamePasswordCredentials;
import com.cloudbees.plugins.credentials.domains.URIRequirementBuilder;
import com.cloudbees.plugins.credentials.matchers.IdMatcher;
import com.microfocus.application.automation.tools.JenkinsUtils;
import com.microfocus.application.automation.tools.Messages;
import com.microfocus.application.automation.tools.model.AlmServerSettingsModel;
import com.microfocus.application.automation.tools.model.CdaDetails;
import com.microfocus.application.automation.tools.model.EnumDescription;
import com.microfocus.application.automation.tools.model.SseModel;
import com.microfocus.application.automation.tools.settings.AlmServerSettingsGlobalConfiguration;
import com.microfocus.application.automation.tools.sse.SSEBuilderPerformer;
import com.microfocus.application.automation.tools.sse.result.model.junit.Testcase;
import com.microfocus.application.automation.tools.sse.result.model.junit.Testsuite;
import com.microfocus.application.automation.tools.sse.result.model.junit.Testsuites;
import com.microfocus.application.automation.tools.sse.sdk.Logger;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Item;
import hudson.model.ParametersAction;
import hudson.model.Queue;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.StringParameterValue;
import hudson.model.TaskListener;
import hudson.model.queue.Tasks;
import hudson.security.ACL;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import hudson.util.VariableResolver;
import java.io.IOException;
import java.io.PrintStream;
import java.io.StringWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import jenkins.tasks.SimpleBuildStep;
import org.acegisecurity.Authentication;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class SseBuilder
extends Builder
implements SimpleBuildStep {
    private SseModel _sseModel;
    private String _fileName;
    private String almServerName;
    private String credentialsId;
    private String clientType;
    private String almDomain;
    private String almProject;
    private String description;
    private String runType;
    private String almEntityId;
    private String timeslotDuration;
    private String postRunAction;
    private String environmentConfigurationId;
    private CdaDetails cdaDetails;

    public String getAlmServerName() {
        return this.almServerName;
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    public String getClientType() {
        return this.clientType;
    }

    public String getAlmDomain() {
        return this.almDomain;
    }

    public String getAlmProject() {
        return this.almProject;
    }

    public String getDescription() {
        return this.description;
    }

    public String getRunType() {
        return this.runType;
    }

    public String getAlmEntityId() {
        return this.almEntityId;
    }

    public String getTimeslotDuration() {
        return this.timeslotDuration;
    }

    public String getPostRunAction() {
        return this.postRunAction;
    }

    public String getEnvironmentConfigurationId() {
        return this.environmentConfigurationId;
    }

    public CdaDetails getCdaDetails() {
        return this.cdaDetails;
    }

    public boolean isCdaDetailsChecked() {
        return this.cdaDetails != null;
    }

    @DataBoundSetter
    public void setDescription(String description) {
        this.description = description;
    }

    @DataBoundSetter
    public void setPostRunAction(String postRunAction) {
        this.postRunAction = postRunAction;
    }

    @DataBoundSetter
    public void setEnvironmentConfigurationId(String environmentConfigurationId) {
        this.environmentConfigurationId = environmentConfigurationId;
    }

    @DataBoundSetter
    public void setCdaDetails(CdaDetails cdaDetails) {
        this.cdaDetails = cdaDetails;
    }

    @DataBoundConstructor
    public SseBuilder(String almServerName, String almProject, String credentialsId, String clientType, String almDomain, String runType, String almEntityId, String timeslotDuration) {
        this.almServerName = almServerName;
        this.credentialsId = credentialsId;
        this.almProject = almProject;
        this.almDomain = almDomain;
        this.timeslotDuration = timeslotDuration;
        this.runType = runType;
        this.almEntityId = almEntityId;
        this.clientType = clientType;
    }

    public void perform(Run<?, ?> build, FilePath workspace, Launcher launcher, TaskListener listener) throws InterruptedException, IOException {
        PrintStream logger = listener.getLogger();
        UsernamePasswordCredentials credentials = this.getCredentialsById(this.credentialsId, build, logger);
        this._sseModel = new SseModel(this.almServerName, credentials.getUsername(), credentials.getPassword().getPlainText(), this.almDomain, this.clientType, this.almProject, this.runType, this.almEntityId, this.timeslotDuration, this.description, this.postRunAction, this.environmentConfigurationId, this.cdaDetails);
        this._sseModel.setAlmServerUrl(this.getServerUrl(this._sseModel.getAlmServerName()));
        VariableResolver.ByMap varResolver = new VariableResolver.ByMap((Map)build.getEnvironment(listener));
        Testsuites testsuites = this.execute(build, logger, (VariableResolver<String>)varResolver);
        String resultsFilename = this.generateResultsFilename();
        FilePath resultsFilePath = workspace.child(resultsFilename);
        Result resultStatus = this.createRunResults(resultsFilePath, testsuites, logger);
        this.provideStepResultStatus(resultStatus, build, logger);
        ParametersAction parameterAction = (ParametersAction)build.getAction(ParametersAction.class);
        ArrayList<StringParameterValue> newParams = parameterAction != null ? new ArrayList<StringParameterValue>(parameterAction.getAllParameters()) : new ArrayList();
        newParams.add(new StringParameterValue("buildStepName", "RunFromAlmLabManagementBuilder"));
        newParams.add(new StringParameterValue("resultsFilename", resultsFilename));
        build.addOrReplaceAction((Action)new ParametersAction(newParams));
    }

    private UsernamePasswordCredentials getCredentialsById(String credentialsId, Run<?, ?> run, PrintStream logger) {
        if (StringUtils.isBlank((String)credentialsId)) {
            throw new NullPointerException("credentials is not configured.");
        }
        UsernamePasswordCredentials credentials = (UsernamePasswordCredentials)CredentialsProvider.findCredentialById((String)credentialsId, StandardUsernamePasswordCredentials.class, run, (List)URIRequirementBuilder.create().build());
        if (credentials == null) {
            logger.println("Can not find credentials with the credentialsId:" + credentialsId);
        }
        return credentials;
    }

    public AlmServerSettingsModel getAlmServerSettingsModel() {
        AlmServerSettingsModel ret = null;
        for (AlmServerSettingsModel almServer : this.getDescriptor().getAlmServers()) {
            if (!this.almServerName.equals(almServer.getAlmServerName())) continue;
            ret = almServer;
            break;
        }
        return ret;
    }

    private void provideStepResultStatus(Result resultStatus, Run<?, ?> build, PrintStream logger) {
        logger.println(String.format("Result Status: %s", resultStatus.toString()));
        build.setResult(resultStatus);
    }

    private Testsuites execute(Run<?, ?> build, PrintStream logger, VariableResolver<String> buildVariableResolver) throws InterruptedException {
        Testsuites ret = null;
        SSEBuilderPerformer performer = null;
        try {
            performer = new SSEBuilderPerformer();
            ret = this.execute(performer, logger, buildVariableResolver);
        }
        catch (InterruptedException e) {
            build.setResult(Result.ABORTED);
            this.stop(performer, logger);
            throw e;
        }
        catch (Exception cause) {
            build.setResult(Result.FAILURE);
            logger.print(String.format("Failed to execute test, Exception: %s", cause.getMessage()));
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Result createRunResults(FilePath filePath, Testsuites testsuites, PrintStream logger) {
        Result ret;
        block8: {
            ret = Result.SUCCESS;
            try {
                if (testsuites != null && !testsuites.getTestsuite().isEmpty()) {
                    JAXBContext context;
                    StringWriter writer = new StringWriter();
                    Thread t = Thread.currentThread();
                    ClassLoader orig = t.getContextClassLoader();
                    t.setContextClassLoader(SseBuilder.class.getClassLoader());
                    try {
                        context = JAXBContext.newInstance((Class[])new Class[]{Testsuites.class});
                    }
                    finally {
                        t.setContextClassLoader(orig);
                    }
                    Marshaller marshaller = context.createMarshaller();
                    marshaller.marshal((Object)testsuites, (Writer)writer);
                    filePath.write(writer.toString(), null);
                    if (this.containsErrors(testsuites.getTestsuite())) {
                        ret = Result.UNSTABLE;
                    }
                    break block8;
                }
                logger.println("Empty Results");
                ret = Result.FAILURE;
            }
            catch (Exception cause) {
                logger.print(String.format("Failed to create run results, Exception: %s", cause.getMessage()));
                ret = Result.FAILURE;
            }
        }
        return ret;
    }

    private boolean containsErrors(List<Testsuite> testsuites) {
        boolean ret = false;
        block0: for (Testsuite testsuite : testsuites) {
            for (Testcase testcase : testsuite.getTestcase()) {
                if (!"error".equals(testcase.getStatus())) continue;
                ret = true;
                continue block0;
            }
        }
        return ret;
    }

    private String generateResultsFilename() {
        SimpleDateFormat formatter = new SimpleDateFormat("ddMMyyyyHHmmssSSS");
        String time = formatter.format((Object)new Date());
        this._fileName = String.format("Results%s.xml", time);
        return this._fileName;
    }

    private void stop(SSEBuilderPerformer performer, PrintStream logger) {
        try {
            if (performer != null) {
                performer.stop();
            }
        }
        catch (Exception cause) {
            logger.println(String.format("Failed to stop BVS. Exception: %s", cause.getMessage()));
        }
    }

    private Testsuites execute(SSEBuilderPerformer performer, final PrintStream logger, VariableResolver<String> buildVariableResolver) throws InterruptedException, IOException {
        return performer.start(this._sseModel, new Logger(){

            @Override
            public void log(String message) {
                logger.println(message);
            }

            @Override
            public void error(String message) {
                this.log(message);
            }
        }, buildVariableResolver);
    }

    public String getServerUrl(String almServerName) {
        String ret = "";
        AlmServerSettingsModel[] almServers = this.getDescriptor().getAlmServers();
        if (almServers != null && almServers.length > 0) {
            for (AlmServerSettingsModel almServer : almServers) {
                if (!almServerName.equals(almServer.getAlmServerName())) continue;
                ret = almServer.getAlmServerUrl();
                break;
            }
        }
        return ret;
    }

    public SseModel getSseModel() {
        return this._sseModel;
    }

    public String getRunResultsFileName() {
        return this._fileName;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    @Extension
    @Symbol(value={"sseBuild"})
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public DescriptorImpl() {
            this.load();
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public String getDisplayName() {
            return Messages.SseBuilderStepName(Messages.CompanyName());
        }

        public boolean hasAlmServers() {
            return AlmServerSettingsGlobalConfiguration.getInstance().hasAlmServers();
        }

        public AlmServerSettingsModel[] getAlmServers() {
            return AlmServerSettingsGlobalConfiguration.getInstance().getInstallations();
        }

        public FormValidation doCheckTimeslotDuration(@QueryParameter String value) {
            if (StringUtils.isBlank((String)value)) {
                return FormValidation.error((String)"Timeslot duration must be set");
            }
            String val1 = value.trim();
            if (!StringUtils.isNumeric((String)val1)) {
                return FormValidation.error((String)"Timeslot duration must be a number");
            }
            if (Integer.valueOf(val1) < 30) {
                return FormValidation.error((String)"Timeslot duration must be higher than 30");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckAlmDomain(@QueryParameter String value) {
            FormValidation ret = FormValidation.ok();
            if (StringUtils.isBlank((String)value)) {
                ret = FormValidation.error((String)"Domain must be set");
            }
            return ret;
        }

        public FormValidation doCheckAlmProject(@QueryParameter String value) {
            FormValidation ret = FormValidation.ok();
            if (StringUtils.isBlank((String)value)) {
                ret = FormValidation.error((String)"Project must be set");
            }
            return ret;
        }

        public FormValidation doCheckAlmEntityId(@QueryParameter String value) {
            FormValidation ret = FormValidation.ok();
            if (StringUtils.isBlank((String)value)) {
                ret = FormValidation.error((String)"Entity must be set.");
            }
            return ret;
        }

        public List<EnumDescription> getRunTypes() {
            return SseModel.getRunTypes();
        }

        public List<EnumDescription> getPostRunActions() {
            return SseModel.getPostRunActions();
        }

        public List<EnumDescription> getDeploymentActions() {
            return CdaDetails.getDeploymentActions();
        }

        public static List<EnumDescription> getDeprovisioningActions() {
            return CdaDetails.getDeprovisioningActions();
        }

        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath Item project, @QueryParameter String credentialsId) {
            if (project == null || !project.hasPermission(Item.CONFIGURE)) {
                return new StandardUsernameListBoxModel().includeCurrentValue(credentialsId);
            }
            return new StandardUsernameListBoxModel().includeEmptyValue().includeAs(project instanceof Queue.Task ? Tasks.getAuthenticationOf((Queue.Task)((Queue.Task)project)) : ACL.SYSTEM, project, StandardUsernamePasswordCredentials.class, URIRequirementBuilder.create().build()).includeCurrentValue(credentialsId);
        }

        public FormValidation doCheckCredentialsId(@AncestorInPath Item project, @QueryParameter String url, @QueryParameter String value) {
            if (project == null || !project.hasPermission(Item.EXTENDED_READ)) {
                return FormValidation.ok();
            }
            if ((value = Util.fixEmptyAndTrim((String)value)) == null) {
                return FormValidation.ok();
            }
            if ((url = Util.fixEmptyAndTrim((String)url)) == null) {
                return FormValidation.ok();
            }
            if (url.indexOf(36) >= 0) {
                return FormValidation.ok();
            }
            for (ListBoxModel.Option o : CredentialsProvider.listCredentials(StandardUsernamePasswordCredentials.class, (Item)project, (Authentication)(project instanceof Queue.Task ? Tasks.getAuthenticationOf((Queue.Task)((Queue.Task)project)) : ACL.SYSTEM), (List)URIRequirementBuilder.create().build(), (CredentialsMatcher)new IdMatcher(value))) {
                if (!StringUtils.equals((String)value, (String)o.value)) continue;
                return FormValidation.ok();
            }
            return FormValidation.warning((String)("Cannot find any credentials with id " + value));
        }

        public boolean getHasConfigurePermission() {
            return JenkinsUtils.hasItemConfigurePermission();
        }
    }
}

