/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.run;

import com.microfocus.application.automation.tools.results.lrscriptresultparser.LrScriptHtmlReportAction;
import com.microfocus.application.automation.tools.results.lrscriptresultparser.LrScriptResultsSanitizer;
import com.microfocus.application.automation.tools.run.LrScriptResultsParser;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Builder;
import hudson.tasks.junit.JUnitResultArchiver;
import hudson.util.ArgumentListBuilder;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nonnull;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import jenkins.model.Jenkins;
import jenkins.tasks.SimpleBuildStep;
import jenkins.util.VirtualFile;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.input.BOMInputStream;
import org.kohsuke.stapler.DataBoundConstructor;

public class RunLoadRunnerScript
extends Builder
implements SimpleBuildStep {
    public static final String LR_SCRIPT_HTML_REPORT_CSS = "PResults.css";
    private static final String LINUX_MDRV_PATH = "/bin/mdrv";
    private static final String WIN_MDRV_PATH = "\\bin\\mmdrv.exe";
    private static final String LR_SCRIPT_HTML_XSLT = "PDetails.xsl";
    private static final String LR_SCRIPT_HTML_CSS = "LR_SCRIPT_REPORT.css";
    private String scriptsPath;
    private Jenkins jenkinsInstance;
    private PrintStream logger;
    private EnvVars slaveEnvVars;

    @DataBoundConstructor
    public RunLoadRunnerScript(@Nonnull String scriptsPath) {
        this.scriptsPath = scriptsPath.equals("") ? "" : scriptsPath;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public void perform(@Nonnull Run<?, ?> build, @Nonnull FilePath workspace, @Nonnull Launcher launcher, @Nonnull TaskListener listener, @Nonnull EnvVars envVars) throws InterruptedException, IOException {
        this.slaveEnvVars = envVars;
        this.perform(build, workspace, launcher, listener);
    }

    public void perform(@Nonnull Run<?, ?> build, @Nonnull FilePath workspace, @Nonnull Launcher launcher, @Nonnull TaskListener listener) throws InterruptedException, IOException {
        try {
            this.jenkinsInstance = Jenkins.getInstance();
            if (this.jenkinsInstance == null) {
                listener.error("Failed loading Jenkins instance ");
                build.setResult(Result.FAILURE);
                return;
            }
            this.logger = listener.getLogger();
            ArgumentListBuilder args = new ArgumentListBuilder();
            String scriptName = FilenameUtils.getBaseName((String)this.scriptsPath);
            FilePath buildWorkDir = workspace.child(build.getId());
            buildWorkDir.mkdirs();
            buildWorkDir = buildWorkDir.absolutize();
            if (build instanceof AbstractBuild) {
                this.slaveEnvVars = build.getEnvironment(listener);
            }
            FilePath scriptPath = workspace.child(this.slaveEnvVars.expand(this.scriptsPath));
            FilePath scriptWorkDir = buildWorkDir.child(scriptName);
            scriptWorkDir.mkdirs();
            scriptWorkDir = scriptWorkDir.absolutize();
            if (this.runScriptMdrv(launcher, args, this.slaveEnvVars, scriptPath, scriptWorkDir)) {
                build.setResult(Result.FAILURE);
                return;
            }
            VirtualFile root = build.getArtifactManager().root();
            File masterBuildWorkspace = new File(new File(root.toURI()), "LRReport");
            if (!masterBuildWorkspace.exists()) {
                if (!root.exists()) {
                    new File(root.toURI()).mkdirs();
                }
                masterBuildWorkspace.mkdirs();
            }
            FilePath outputHTML = buildWorkDir.child(scriptName);
            outputHTML.mkdirs();
            outputHTML = outputHTML.child("result.html");
            FilePath xsltOnNode = this.copyXsltToNode(workspace);
            this.createHtmlReports(buildWorkDir, scriptName, outputHTML, xsltOnNode);
            LrScriptResultsParser lrScriptResultsParser = new LrScriptResultsParser(listener);
            lrScriptResultsParser.parseScriptResult(scriptName, buildWorkDir);
            RunLoadRunnerScript.copyScriptsResultToMaster(build, listener, buildWorkDir, new FilePath(masterBuildWorkspace));
            RunLoadRunnerScript.parseJunitResult(build, launcher, listener, buildWorkDir, scriptName);
            this.addLrScriptHtmlReportAcrion(build, scriptName);
            build.setResult(Result.SUCCESS);
        }
        catch (IllegalArgumentException e) {
            build.setResult(Result.FAILURE);
            this.logger.println(e);
        }
        catch (IOException | InterruptedException e) {
            listener.error("Failed loading build environment " + String.valueOf(e));
            build.setResult(Result.FAILURE);
        }
        catch (XMLStreamException e) {
            listener.error(e.getMessage(), new Object[]{e});
            build.setResult(Result.FAILURE);
        }
    }

    private FilePath copyXsltToNode(@Nonnull FilePath workspace) throws IOException, InterruptedException {
        URL xsltPath = this.jenkinsInstance.pluginManager.uberClassLoader.getResource(LR_SCRIPT_HTML_XSLT);
        this.logger.println("loading XSLT from " + xsltPath.getFile());
        FilePath xsltOnNode = workspace.child("resultsHtml.xslt");
        if (!xsltOnNode.exists()) {
            xsltOnNode.copyFrom(xsltPath);
        }
        return xsltOnNode;
    }

    private boolean runScriptMdrv(@Nonnull Launcher launcher, ArgumentListBuilder args, EnvVars env, FilePath scriptPath, FilePath scriptWorkDir) throws IOException, InterruptedException {
        FilePath mdrv = RunLoadRunnerScript.getMDRVPath(launcher, env);
        args.add((Object)mdrv);
        args.add("-usr");
        args.add((Object)scriptPath);
        args.add("-extra_ext NVReportExt");
        args.add("-qt_result_dir");
        args.add((Object)scriptWorkDir);
        int returnCode = launcher.launch().cmds(args).stdout((OutputStream)this.logger).pwd(scriptWorkDir).join();
        return returnCode != 0;
    }

    private static FilePath getMDRVPath(@Nonnull Launcher launcher, EnvVars env) {
        FilePath mdrv;
        if (launcher.isUnix()) {
            Object lrPath = env.get("M_LROOT", "");
            if ("".equals(lrPath)) {
                throw new LrScriptParserException("Please make sure environment variables are set correctly on the running node - M_LROOT for linux");
            }
            lrPath = (String)lrPath + LINUX_MDRV_PATH;
            mdrv = new FilePath(launcher.getChannel(), (String)lrPath);
        } else {
            Object lrPath = env.get("LR_PATH", "");
            if ("".equals(lrPath)) {
                throw new LrScriptParserException("Please make sure environment variables are set correctly on the running node - LR_PATH for windows");
            }
            lrPath = (String)lrPath + WIN_MDRV_PATH;
            mdrv = new FilePath(launcher.getChannel(), (String)lrPath);
        }
        return mdrv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addLrScriptHtmlReportAcrion(@Nonnull Run<?, ?> build, String scriptName) {
        Run<?, ?> run = build;
        synchronized (run) {
            LrScriptHtmlReportAction action = (LrScriptHtmlReportAction)build.getAction(LrScriptHtmlReportAction.class);
            if (action == null) {
                action = new LrScriptHtmlReportAction(build);
                action.mergeResult(build, scriptName);
                build.addAction((Action)action);
            } else {
                action.mergeResult(build, scriptName);
            }
        }
    }

    private static void parseJunitResult(@Nonnull Run<?, ?> build, @Nonnull Launcher launcher, @Nonnull TaskListener listener, FilePath buildWorkDir, String scriptName) throws InterruptedException, IOException {
        JUnitResultArchiver jUnitResultArchiver = new JUnitResultArchiver("JunitResult.xml");
        jUnitResultArchiver.setKeepLongStdio(true);
        jUnitResultArchiver.setAllowEmptyResults(true);
        jUnitResultArchiver.perform(build, buildWorkDir.child(scriptName), launcher, listener);
    }

    private void createHtmlReports(FilePath buildWorkDir, String scriptName, FilePath outputHTML, FilePath xsltOnNode) throws IOException, InterruptedException, XMLStreamException {
        if (!buildWorkDir.exists()) {
            throw new IllegalArgumentException("Build worker doesn't exist");
        }
        if ("".equals(scriptName)) {
            throw new IllegalArgumentException("Script name is empty");
        }
        if (!xsltOnNode.exists()) {
            throw new IllegalArgumentException("LR Html report doesn't exist on the node");
        }
        try {
            TransformerFactory factory = TransformerFactory.newInstance();
            factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            StreamSource xslStream = new StreamSource(xsltOnNode.read());
            Transformer transformer = factory.newTransformer(xslStream);
            CharsetDecoder decoder = StandardCharsets.UTF_8.newDecoder();
            decoder.onMalformedInput(CodingErrorAction.REPLACE).replacement();
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)new BOMInputStream(buildWorkDir.child(scriptName).child("Results.xml").read()), decoder);
            StreamSource in = new StreamSource(new LrScriptResultsSanitizer(inputStreamReader));
            StreamResult out = new StreamResult(outputHTML.write());
            transformer.transform(in, out);
            URL lrHtmlCSSPath = this.jenkinsInstance.pluginManager.uberClassLoader.getResource(LR_SCRIPT_HTML_CSS);
            if (lrHtmlCSSPath == null) {
                throw new LrScriptParserException("For some reason the jenkins instance is null - is it an improper set tests?");
            }
            FilePath lrScriptHtmlReportCss = buildWorkDir.child(scriptName).child(LR_SCRIPT_HTML_REPORT_CSS);
            lrScriptHtmlReportCss.copyFrom(lrHtmlCSSPath);
            this.logger.println("The generated HTML file is:" + String.valueOf(outputHTML));
        }
        catch (TransformerConfigurationException e) {
            this.logger.println("TransformerConfigurationException");
            this.logger.println(e);
        }
        catch (TransformerException e) {
            this.logger.println("TransformerException");
            this.logger.println(e);
        }
        catch (LrScriptParserException e) {
            this.logger.println("General exception");
            this.logger.println(e);
        }
    }

    private static void copyScriptsResultToMaster(@Nonnull Run<?, ?> build, @Nonnull TaskListener listener, FilePath buildWorkDir, FilePath masterBuildWorkspace) throws IOException, InterruptedException {
        listener.getLogger().printf("Copying script results, from '%s' on node to '%s' on the master. %n", buildWorkDir.toURI(), build.getRootDir().toURI());
        buildWorkDir.copyRecursiveTo(masterBuildWorkspace);
    }

    @Nonnull
    public String getScriptsPath() {
        return this.scriptsPath == null ? "" : this.scriptsPath;
    }

    @Extension
    public static class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public static final String DEFAULT_SCRIPTS_PATH = "";

        public String getDisplayName() {
            return "Run LoadRunner script";
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }
    }

    public static final class LrScriptParserException
    extends IllegalArgumentException {
        public LrScriptParserException(String s) {
            super(s);
        }
    }
}

