/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.run;

import hudson.EnvVars;
import hudson.Extension;
import hudson.model.EnvironmentContributor;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.IOException;
import java.util.Collections;
import java.util.List;

public class AdditionalParametersAction
extends ParametersAction {
    private List<ParameterValue> parameters;

    public AdditionalParametersAction(List<ParameterValue> cparameters) {
        super(new ParameterValue[0]);
        this.parameters = Collections.unmodifiableList(cparameters);
    }

    public List<ParameterValue> getParameters() {
        return Collections.unmodifiableList(this.parameters);
    }

    public List<ParameterValue> getAllParameters() {
        return Collections.unmodifiableList(this.parameters);
    }

    public ParameterValue getParameter(String name) {
        for (ParameterValue p : this.parameters) {
            if (p == null || !p.getName().equals(name)) continue;
            return p;
        }
        return null;
    }

    @Extension
    public static final class AdditionalParametersActionEnvironmentContributor
    extends EnvironmentContributor {
        public void buildEnvironmentFor(Run r, EnvVars envs, TaskListener listener) throws IOException, InterruptedException {
            AdditionalParametersAction action = (AdditionalParametersAction)r.getAction(AdditionalParametersAction.class);
            if (action != null) {
                for (ParameterValue p : action.getParameters()) {
                    envs.putIfNotNull(p.getName(), String.valueOf(p.getValue()));
                }
            }
        }
    }
}

