/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.results.parser.jenkinsjunit;

import com.microfocus.application.automation.tools.results.parser.ReportParseException;
import com.microfocus.application.automation.tools.results.parser.ReportParser;
import com.microfocus.application.automation.tools.results.parser.jenkinsjunit.Result;
import com.microfocus.application.automation.tools.results.parser.util.ParserUtil;
import com.microfocus.application.automation.tools.results.service.almentities.AlmRun;
import com.microfocus.application.automation.tools.results.service.almentities.AlmTest;
import com.microfocus.application.automation.tools.results.service.almentities.AlmTestInstanceImpl;
import com.microfocus.application.automation.tools.results.service.almentities.AlmTestSet;
import com.microfocus.application.automation.tools.results.service.almentities.AlmTestSetImpl;
import com.microfocus.application.automation.tools.results.service.almentities.IAlmConsts;
import com.microfocus.application.automation.tools.sse.sdk.Base64Encoder;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;

public class JenkinsJUnitReportParserImpl
implements ReportParser {
    @Override
    public List<AlmTestSet> parseTestSets(InputStream reportInputStream, String testingFramework, String testingTool) throws ReportParseException {
        try {
            return this.parseTestSetsFromJenkinsPluginJUnitReport(reportInputStream, testingFramework, testingTool);
        }
        catch (Exception e) {
            throw new ReportParseException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Result parseFromJenkinsPluginJUnitReport(InputStream reportInputStream) throws JAXBException {
        JAXBContext jaxbContext;
        Thread t = Thread.currentThread();
        ClassLoader orig = t.getContextClassLoader();
        t.setContextClassLoader(JenkinsJUnitReportParserImpl.class.getClassLoader());
        try {
            jaxbContext = JAXBContext.newInstance((Class[])new Class[]{Result.class});
        }
        finally {
            t.setContextClassLoader(orig);
        }
        Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
        return (Result)unmarshaller.unmarshal(reportInputStream);
    }

    private AlmTest createExternalTestForJenkinsPluginJUnit(Result.Suites.Suite.Cases.Case c, String testingFramework, String testingTool) {
        return ParserUtil.createExternalTest(c.getClassName(), c.getTestName(), testingFramework, testingTool);
    }

    private String getRunDetail(Result.Suites.Suite.Cases.Case c) {
        String detail = ParserUtil.marshallerObject(Result.Suites.Suite.Cases.Case.class, c);
        return Base64Encoder.encode(detail.getBytes());
    }

    private ArrayList<AlmTestSet> parseTestSetsFromJenkinsPluginJUnitReport(InputStream reportInputStream, String testingFramework, String testingTool) throws JAXBException {
        Result result = this.parseFromJenkinsPluginJUnitReport(reportInputStream);
        ArrayList<AlmTestSet> testSets = new ArrayList<AlmTestSet>();
        for (Result.Suites suites : result.getSuites()) {
            for (Result.Suites.Suite suite : suites.getSuite()) {
                AlmTestSetImpl testSet = new AlmTestSetImpl();
                testSet.setFieldValue("name", ParserUtil.replaceInvalidCharsForTestSetName(suite.getName()));
                testSet.setFieldValue("subtype-id", "hp.qc.test-set.external");
                testSets.add(testSet);
                for (Result.Suites.Suite.Cases cases : suite.getCases()) {
                    for (Result.Suites.Suite.Cases.Case c : cases.getCase()) {
                        AlmTestInstanceImpl testInstance = new AlmTestInstanceImpl();
                        testInstance.setFieldValue("subtype-id", "hp.qc.test-instance.external-test");
                        testSet.addRelatedEntity("TESTSET_TO_TESTINSTANCE_CONTAINMENT_RELATION", testInstance);
                        AlmTest test = this.createExternalTestForJenkinsPluginJUnit(c, testingFramework, testingTool);
                        testInstance.addRelatedEntity("TEST_TO_TESTINSTANCE_REALIZATION_RELATION", test);
                        AlmRun run = ParserUtil.createRun(this.getRunStatus(c), suite.getTimestamp(), c.getDuration(), this.getRunDetail(c));
                        testInstance.addRelatedEntity("TESTINSTANCE_TO_RUN_REALIZATION_RELATION", run);
                    }
                }
            }
        }
        return testSets;
    }

    private String getRunStatus(Result.Suites.Suite.Cases.Case c) {
        String result = c.getSkipped() != null && c.getSkipped().equals("true") ? IAlmConsts.IStatuses.NO_RUN.value() : (c.getErrorStackTrace() != null && c.getErrorStackTrace().length() > 0 ? IAlmConsts.IStatuses.FAILED.value() : (c.getErrorDetails() != null && c.getErrorDetails().length() > 0 ? IAlmConsts.IStatuses.FAILED.value() : (c.getFailedSince() != null && c.getFailedSince().equals("0") ? IAlmConsts.IStatuses.PASSED.value() : IAlmConsts.IStatuses.FAILED.value())));
        return result;
    }
}

