/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.results.parser;

import com.microfocus.application.automation.tools.results.parser.ReportParser;
import com.microfocus.application.automation.tools.results.parser.antjunit.AntJUnitReportParserImpl;
import com.microfocus.application.automation.tools.results.parser.jenkinsjunit.JenkinsJUnitReportParserImpl;
import com.microfocus.application.automation.tools.results.parser.mavensurefire.MavenSureFireReportParserImpl;
import com.microfocus.application.automation.tools.results.parser.nunit.NUnitReportParserImpl;
import com.microfocus.application.automation.tools.results.parser.nunit3.NUnit3ReportParserImpl;
import com.microfocus.application.automation.tools.results.parser.testngxml.TestNGXmlReportParserImpl;
import com.microfocus.application.automation.tools.results.service.almentities.AlmTestSet;
import com.microfocus.application.automation.tools.sse.sdk.Logger;
import hudson.FilePath;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.List;

public class ReportParserManager {
    private static ReportParserManager instance = new ReportParserManager();
    private List<ReportParser> parserList;
    private FilePath workspace;
    private Logger logger;

    private ReportParserManager() {
    }

    public static ReportParserManager getInstance(FilePath workspace, Logger logger) {
        if (ReportParserManager.instance.workspace == null) {
            ReportParserManager.instance.workspace = workspace;
        }
        if (ReportParserManager.instance.logger == null) {
            ReportParserManager.instance.logger = logger;
        }
        return instance;
    }

    public List<AlmTestSet> parseTestSets(String reportFilePath, String testingFramework, String testingTool) {
        this.init();
        List<AlmTestSet> testsets = null;
        for (ReportParser reportParser : this.parserList) {
            try {
                FileInputStream in = new FileInputStream(reportFilePath);
                testsets = reportParser.parseTestSets(in, testingFramework, testingTool);
                break;
            }
            catch (Exception e) {
                this.logger.log("Failed to parse file with: " + reportParser.getClass().getName());
            }
        }
        return testsets;
    }

    private void init() {
        if (this.parserList == null) {
            this.parserList = new ArrayList<ReportParser>();
        }
        if (this.parserList.isEmpty()) {
            this.parserList.add(new JenkinsJUnitReportParserImpl());
            this.parserList.add(new MavenSureFireReportParserImpl());
            this.parserList.add(new TestNGXmlReportParserImpl());
            this.parserList.add(new NUnit3ReportParserImpl(this.workspace));
            this.parserList.add(new NUnitReportParserImpl());
            this.parserList.add(new AntJUnitReportParserImpl());
        }
    }
}

