/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.pipelineSteps;

import com.microfocus.application.automation.tools.lr.model.ScriptRTSSetModel;
import com.microfocus.application.automation.tools.lr.model.SummaryDataLogModel;
import com.microfocus.application.automation.tools.model.EnumDescription;
import com.microfocus.application.automation.tools.model.ResultsPublisherModel;
import com.microfocus.application.automation.tools.pipelineSteps.LrScenarioLoadStepExecution;
import com.microfocus.application.automation.tools.results.RunResultRecorder;
import com.microfocus.application.automation.tools.run.RunFromFileBuilder;
import hudson.Extension;
import hudson.util.FormValidation;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class LoadRunnerTestStep
extends AbstractStepImpl {
    private final RunFromFileBuilder runFromFileBuilder;
    private final RunResultRecorder runResultRecorder;

    @DataBoundConstructor
    public LoadRunnerTestStep(String testPaths, String archiveTestResultsMode) {
        this.runFromFileBuilder = new RunFromFileBuilder(testPaths);
        this.runResultRecorder = new RunResultRecorder(archiveTestResultsMode);
    }

    public String getArchiveTestResultsMode() {
        return this.runResultRecorder.getResultsPublisherModel().getArchiveTestResultsMode();
    }

    public String getControllerPollingInterval() {
        return this.runFromFileBuilder.getRunFromFileModel().getControllerPollingInterval();
    }

    @DataBoundSetter
    public void setControllerPollingInterval(String controllerPollingInterval) {
        this.runFromFileBuilder.setControllerPollingInterval(controllerPollingInterval);
    }

    public String getFsTimeout() {
        return this.runFromFileBuilder.getRunFromFileModel().getFsTimeout();
    }

    @DataBoundSetter
    public void setFsTimeout(String fsTimeout) {
        this.runFromFileBuilder.setFsTimeout(fsTimeout);
    }

    public String getPerScenarioTimeOut() {
        return this.runFromFileBuilder.getRunFromFileModel().getPerScenarioTimeOut();
    }

    @DataBoundSetter
    public void setPerScenarioTimeOut(String perScenarioTimeOut) {
        this.runFromFileBuilder.setPerScenarioTimeOut(perScenarioTimeOut);
    }

    public String getTestPaths() {
        return this.runFromFileBuilder.getRunFromFileModel().getFsTests();
    }

    public String getIgnoreErrorStrings() {
        return this.runFromFileBuilder.getRunFromFileModel().getIgnoreErrorStrings();
    }

    @DataBoundSetter
    public void setIgnoreErrorStrings(String ignoreErrorStrings) {
        this.runFromFileBuilder.setIgnoreErrorStrings(ignoreErrorStrings);
    }

    public String getAnalysisTemplate() {
        return this.runFromFileBuilder.getRunFromFileModel().getAnalysisTemplate();
    }

    @DataBoundSetter
    public void setAnalysisTemplate(String analysisTemplate) {
        this.runFromFileBuilder.setAnalysisTemplate(analysisTemplate);
    }

    public String getDisplayController() {
        return this.runFromFileBuilder.getRunFromFileModel().getDisplayController();
    }

    @DataBoundSetter
    public void setDisplayController(String displayController) {
        this.runFromFileBuilder.setDisplayController(displayController);
    }

    public SummaryDataLogModel getSummaryDataLogModel() {
        return this.runFromFileBuilder.getSummaryDataLogModel();
    }

    @DataBoundSetter
    public void setSummaryDataLogModel(SummaryDataLogModel summaryDataLogModel) {
        this.runFromFileBuilder.setSummaryDataLogModel(summaryDataLogModel);
    }

    public ScriptRTSSetModel getScriptRTSSetModel() {
        return this.runFromFileBuilder.getScriptRTSSetModel();
    }

    @DataBoundSetter
    public void setScriptRTSSetModel(ScriptRTSSetModel scriptRTSSetModel) {
        this.runFromFileBuilder.setScriptRTSSetModel(scriptRTSSetModel);
    }

    public RunFromFileBuilder getRunFromFileBuilder() {
        return this.runFromFileBuilder;
    }

    public RunResultRecorder getRunResultRecorder() {
        return this.runResultRecorder;
    }

    @Extension
    @Symbol(value={"loadRunnerTest"})
    public static class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public DescriptorImpl() {
            super(LrScenarioLoadStepExecution.class);
        }

        public String getFunctionName() {
            return "loadRunnerTest";
        }

        @Nonnull
        public String getDisplayName() {
            return "Run LoadRunner performance scenario tests";
        }

        public List<EnumDescription> getReportArchiveModes() {
            return ResultsPublisherModel.archiveModes;
        }

        public FormValidation doCheckFsTests(@QueryParameter String value) {
            return FormValidation.ok();
        }

        public FormValidation doCheckIgnoreErrorStrings(@QueryParameter String value) {
            return FormValidation.ok();
        }

        public FormValidation doCheckFsTimeout(@QueryParameter String value) {
            if (StringUtils.isEmpty((String)value)) {
                return FormValidation.ok();
            }
            String val1 = value.trim();
            if (val1.length() > 0 && val1.charAt(0) == '-') {
                val1 = val1.substring(1);
            }
            if (!StringUtils.isNumeric((String)val1) && !Objects.equals(val1, "")) {
                return FormValidation.error((String)"Timeout name must be a number");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckControllerPollingInterval(@QueryParameter String value) {
            if (StringUtils.isEmpty((String)value)) {
                return FormValidation.ok();
            }
            if (!StringUtils.isNumeric((String)value)) {
                return FormValidation.error((String)"Controller Polling Interval must be a number");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckPerScenarioTimeOut(@QueryParameter String value) {
            if (StringUtils.isEmpty((String)value)) {
                return FormValidation.ok();
            }
            if (!StringUtils.isNumeric((String)value)) {
                return FormValidation.error((String)"Per Scenario Timeout must be a number");
            }
            return FormValidation.ok();
        }
    }
}

