/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.pc.helper;

import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;

public class DateFormatter {
    public static final String DEFAULT_PATTERN = "E yyyy MMM dd 'at' HH:mm:ss.SSS a zzz";
    private DateTimeFormatter dateTimeFormatter;
    private String pattern;
    private String date;

    public DateFormatter(String pattern) {
        this.pattern = pattern.isEmpty() ? DEFAULT_PATTERN : pattern;
        this.dateTimeFormatter = DateTimeFormatter.ofPattern(this.pattern);
        this.renewDate();
    }

    public void renewDate() {
        try {
            this.date = ZonedDateTime.now().format(this.dateTimeFormatter);
        }
        catch (Exception ex) {
            this.pattern = DEFAULT_PATTERN;
            this.dateTimeFormatter = DateTimeFormatter.ofPattern(this.pattern);
            this.date = ZonedDateTime.now().format(this.dateTimeFormatter);
        }
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern.isEmpty() ? DEFAULT_PATTERN : pattern;
        this.dateTimeFormatter = DateTimeFormatter.ofPattern(this.pattern);
    }

    public String getDate() {
        try {
            this.renewDate();
            return this.date;
        }
        catch (Exception ex) {
            return "";
        }
    }

    public static String getDateTime() {
        try {
            DateTimeFormatter customDateTimeFormatter = DateTimeFormatter.ofPattern(DEFAULT_PATTERN);
            String dateTime = ZonedDateTime.now().format(customDateTimeFormatter);
            return dateTime;
        }
        catch (Exception ex) {
            return "";
        }
    }
}

