/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.pc;

import com.cloudbees.plugins.credentials.common.UsernamePasswordCredentials;
import com.microfocus.adm.performancecenter.plugins.common.pcentities.PcException;
import com.microfocus.adm.performancecenter.plugins.common.pcentities.PcRunEventLog;
import com.microfocus.adm.performancecenter.plugins.common.pcentities.PcRunResponse;
import com.microfocus.adm.performancecenter.plugins.common.pcentities.PcRunResult;
import com.microfocus.adm.performancecenter.plugins.common.pcentities.PcRunResults;
import com.microfocus.adm.performancecenter.plugins.common.pcentities.PcTest;
import com.microfocus.adm.performancecenter.plugins.common.pcentities.PcTestInstance;
import com.microfocus.adm.performancecenter.plugins.common.pcentities.PcTestInstances;
import com.microfocus.adm.performancecenter.plugins.common.pcentities.PcTestSet;
import com.microfocus.adm.performancecenter.plugins.common.pcentities.PcTestSets;
import com.microfocus.adm.performancecenter.plugins.common.pcentities.PcTrendedRun;
import com.microfocus.adm.performancecenter.plugins.common.pcentities.PostRunAction;
import com.microfocus.adm.performancecenter.plugins.common.pcentities.RunState;
import com.microfocus.adm.performancecenter.plugins.common.pcentities.TimeslotDuration;
import com.microfocus.adm.performancecenter.plugins.common.pcentities.TrendReportRequest;
import com.microfocus.adm.performancecenter.plugins.common.pcentities.TrendReportTransactionDataRoot;
import com.microfocus.adm.performancecenter.plugins.common.pcentities.TrendReportTypes;
import com.microfocus.adm.performancecenter.plugins.common.rest.PcRestProxy;
import com.microfocus.application.automation.tools.pc.Messages;
import com.microfocus.application.automation.tools.pc.PcModel;
import com.microfocus.application.automation.tools.pc.helper.DateFormatter;
import com.microfocus.application.automation.tools.run.PcBuilder;
import hudson.FilePath;
import hudson.console.HyperlinkNote;
import java.beans.IntrospectionException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.http.client.ClientProtocolException;

public class PcClient {
    private PcModel model;
    private PcRestProxy restProxy;
    private boolean loggedIn;
    private PrintStream logger;

    public PcClient(PcModel pcModel, PrintStream logger) {
        try {
            String proxyOutPassword;
            this.model = pcModel;
            String credentialsProxyId = this.model.getCredentialsProxyId(true);
            UsernamePasswordCredentials usernamePCPasswordCredentialsForProxy = PcBuilder.getCredentialsId(credentialsProxyId);
            String proxyOutUser = usernamePCPasswordCredentialsForProxy == null || this.model.getProxyOutURL(true).isEmpty() ? "" : usernamePCPasswordCredentialsForProxy.getUsername();
            String string = proxyOutPassword = usernamePCPasswordCredentialsForProxy == null || this.model.getProxyOutURL(true).isEmpty() ? "" : usernamePCPasswordCredentialsForProxy.getPassword().getPlainText();
            if (this.model.getProxyOutURL(true) != null && !this.model.getProxyOutURL(true).isEmpty()) {
                logger.println(String.format("%s - %s: %s", DateFormatter.getDateTime(), Messages.UsingProxy(), this.model.getProxyOutURL(true)));
                if (!proxyOutUser.isEmpty()) {
                    if (this.model.getCredentialsProxyId().startsWith("$")) {
                        logger.println(String.format("%s - %s  %s.", DateFormatter.getDateTime(), Messages.UsingProxyCredentialsBuildParameters(), proxyOutUser));
                    } else {
                        logger.println(String.format("%s - %s %s.", DateFormatter.getDateTime(), Messages.UsingProxyCredentialsConfiguration(), proxyOutUser));
                    }
                }
            }
            this.restProxy = new PcRestProxy(this.model.isHTTPSProtocol(), this.model.getPcServerName(true), this.model.isAuthenticateWithToken(), this.model.getAlmDomain(true), this.model.getAlmProject(true), this.model.getProxyOutURL(true), proxyOutUser, proxyOutPassword);
            this.logger = logger;
        }
        catch (PcException e) {
            logger.println(String.format("%s - %s", DateFormatter.getDateTime(), e.getMessage()));
        }
    }

    public <T extends PcRestProxy> PcClient(PcModel pcModel, PrintStream logger, T proxy) {
        this.model = pcModel;
        this.restProxy = proxy;
        this.logger = logger;
    }

    public boolean login() {
        try {
            String credentialsId = this.model.getCredentialsId(true);
            UsernamePasswordCredentials usernamePCPasswordCredentials = PcBuilder.getCredentialsId(credentialsId);
            if (usernamePCPasswordCredentials != null) {
                if (this.model.getCredentialsId().startsWith("$")) {
                    this.logger.println(String.format("%s - %s", DateFormatter.getDateTime(), Messages.UsingPCCredentialsBuildParameters()));
                } else {
                    this.logger.println(String.format("%s - %s", DateFormatter.getDateTime(), Messages.UsingPCCredentialsConfiguration()));
                }
                this.logger.println(String.format("%s - %s\n[Server='%s://%s/loadtest/%s', %s='%s']", DateFormatter.getDateTime(), Messages.TryingToLogin(), this.model.isHTTPSProtocol(), this.restProxy.GetPcServer(), this.restProxy.GetTenant(), this.model.isAuthenticateWithToken() ? "ClientIdKey" : "User", usernamePCPasswordCredentials.getUsername()));
                this.loggedIn = this.restProxy.authenticate(usernamePCPasswordCredentials.getUsername(), usernamePCPasswordCredentials.getPassword().getPlainText());
            } else {
                this.logger.println(String.format("%s - %s\n[Server='%s://%s/loadtest/%s', %s='%s']", DateFormatter.getDateTime(), Messages.TryingToLogin(), this.model.isHTTPSProtocol(), this.restProxy.GetPcServer(), this.restProxy.GetTenant(), this.model.isAuthenticateWithToken() ? "ClientIdKey" : "User", PcBuilder.usernamePCPasswordCredentials.getUsername()));
                this.loggedIn = this.restProxy.authenticate(PcBuilder.usernamePCPasswordCredentials.getUsername(), PcBuilder.usernamePCPasswordCredentials.getPassword().getPlainText());
            }
        }
        catch (PcException e) {
            this.logger.println(String.format("%s - %s", DateFormatter.getDateTime(), e.getMessage()));
        }
        catch (Exception e) {
            this.logger.println(String.format("%s - %s", DateFormatter.getDateTime(), e));
        }
        this.logger.println(String.format("%s - %s", DateFormatter.getDateTime(), this.loggedIn ? Messages.LoginSucceeded() : Messages.LoginFailed()));
        return this.loggedIn;
    }

    public boolean isLoggedIn() {
        return this.loggedIn;
    }

    public int startRun() throws NumberFormatException, ClientProtocolException, PcException, IOException {
        int testID = Integer.parseInt(this.model.getTestId(true));
        int testInstance = this.getCorrectTestInstanceID(testID);
        this.setCorrectTrendReportID();
        this.logger.println(String.format("%s - \n%s \n====================\n%s: %s \n%s: %s \n%s: %s \n%s: %s \n%s: %s \n%s: %s \n%s: %s \n====================\n", DateFormatter.getDateTime(), Messages.ExecutingLoadTest(), Messages.Domain(), this.model.getAlmDomain(true), Messages.Project(), this.model.getAlmProject(true), Messages.TestID(), Integer.parseInt(this.model.getTestId(true)), Messages.TestInstanceID(), testInstance, Messages.TimeslotDuration(), new TimeslotDuration(this.model.getTimeslotDurationHours(true), this.model.getTimeslotDurationMinutes(true)), Messages.PostRunAction(), this.model.getPostRunAction().getValue(), Messages.UseVUDS(), this.model.isVudsMode()));
        PcRunResponse response = null;
        try {
            response = this.restProxy.startRun(testID, testInstance, new TimeslotDuration(this.model.getTimeslotDurationHours(true), this.model.getTimeslotDurationMinutes(true)), this.model.getPostRunAction().getValue(), this.model.isVudsMode(), 0);
            this.logger.println(String.format("%s - %s (TestID: %s, RunID: %s, TimeslotID: %s)", DateFormatter.getDateTime(), Messages.RunStarted(), response.getTestID(), response.getID(), response.getTimeslotID()));
            return response.getID();
        }
        catch (PcException | NumberFormatException | ClientProtocolException ex) {
            Integer result = this.checkError1310(ex.getMessage());
            if (result != null) {
                return result;
            }
            this.logger.println(String.format("%s - %s. Error: %s", DateFormatter.getDateTime(), Messages.StartRunFailed(), ex.getMessage()));
        }
        catch (IOException ex) {
            this.logger.println(String.format("%s - %s. IOException Error: %s", DateFormatter.getDateTime(), Messages.StartRunFailed(), ex.getMessage()));
        }
        if (!"RETRY".equals(this.model.getRetry())) {
            return 0;
        }
        int retryCount = 0;
        int retryDelay = Integer.parseInt(this.model.getRetryDelay());
        int retryOccurrences = Integer.parseInt(this.model.getRetryOccurrences());
        while (retryCount <= retryOccurrences) {
            ++retryCount;
            try {
                if (retryCount <= retryOccurrences) {
                    this.logger.println(String.format("%s - %s. %s (%s %s). %s: %s.", DateFormatter.getDateTime(), Messages.StartRunRetryFailed(), Messages.AttemptingStartAgainSoon(), retryDelay, Messages.Minutes(), Messages.AttemptsRemaining(), retryOccurrences - retryCount + 1));
                    Thread.sleep(retryDelay * 60 * 1000);
                }
            }
            catch (InterruptedException ex) {
                this.logger.println(String.format("%s - wait failed", DateFormatter.getDateTime()));
            }
            try {
                response = this.restProxy.startRun(testID, testInstance, new TimeslotDuration(this.model.getTimeslotDurationHours(true), this.model.getTimeslotDurationMinutes(true)), this.model.getPostRunAction().getValue(), this.model.isVudsMode(), 0);
            }
            catch (PcException | NumberFormatException | ClientProtocolException ex) {
                Integer result = this.checkError1310(ex.getMessage());
                if (result != null) {
                    return result;
                }
                this.logger.println(String.format("%s -%s. %s: %s", DateFormatter.getDateTime(), Messages.StartRunRetryFailed(), Messages.Error(), ex.getMessage()));
            }
            catch (IOException ex) {
                this.logger.println(String.format("%s -%s. %s: %s", DateFormatter.getDateTime(), Messages.StartRunRetryFailed(), Messages.Error(), ex.getMessage()));
            }
            int ret = 0;
            if (response != null) {
                try {
                    ret = response.getID();
                }
                catch (Exception ex) {
                    this.logger.println(String.format("%s - %s. %s: %s", DateFormatter.getDateTime(), Messages.RetrievingIDFailed(), Messages.Error(), ex.getMessage()));
                }
            }
            if (ret == 0) continue;
            this.logger.println(String.format("%s - %s (TestID: %s, RunID: %s, TimeslotID: %s)\n", DateFormatter.getDateTime(), Messages.RunStarted(), response.getTestID(), response.getID(), response.getTimeslotID()));
            return ret;
        }
        return 0;
    }

    private Integer checkError1310(String msg) {
        Pattern p = Pattern.compile("executeRequest exception: Run was started with ID (\\d+), but.*Error code: 1310");
        Matcher m = p.matcher(msg);
        if (m.matches()) {
            this.logger.println(String.format("%s - %s. Recovered-error: %s", DateFormatter.getDateTime(), Messages.StartRunFailed(), msg));
            this.logger.println(String.format("%s - %s (TestID: %s, RunID: %s, TimeslotID: %s)", DateFormatter.getDateTime(), Messages.RunStarted(), Integer.parseInt(this.model.getTestId(true)), m.group(1), "0"));
            return Integer.parseInt(m.group(1));
        }
        return null;
    }

    private int getCorrectTestInstanceID(int testID) throws IOException, PcException {
        if ("AUTO".equals(this.model.getAutoTestInstanceID())) {
            try {
                int testInstanceID;
                this.logger.println(String.format("%s - %s.", DateFormatter.getDateTime(), Messages.SearchingTestInstance()));
                PcTestInstances pcTestInstances = null;
                try {
                    pcTestInstances = this.restProxy.getTestInstancesByTestId(testID);
                }
                catch (PcException ex) {
                    this.logger.println(String.format("%s - getTestInstancesByTestId %s. %s: %s", DateFormatter.getDateTime(), Messages.Failure(), Messages.Error(), ex.getMessage()));
                }
                if (pcTestInstances != null && pcTestInstances.getTestInstancesList() != null) {
                    PcTestInstance pcTestInstance = (PcTestInstance)pcTestInstances.getTestInstancesList().get(pcTestInstances.getTestInstancesList().size() - 1);
                    testInstanceID = pcTestInstance.getInstanceId();
                    this.logger.println(String.format("%s - %s: %s", DateFormatter.getDateTime(), Messages.FoundTestInstanceID(), testInstanceID));
                } else {
                    this.logger.println(String.format("%s - %s", DateFormatter.getDateTime(), Messages.NotFoundTestInstanceID()));
                    this.logger.println(String.format("%s - %s", DateFormatter.getDateTime(), Messages.SearchingAvailableTestSet()));
                    PcTestSets pcTestSets = this.restProxy.GetAllTestSets();
                    if (pcTestSets != null && pcTestSets.getPcTestSetsList() != null) {
                        PcTestSet pcTestSet = (PcTestSet)pcTestSets.getPcTestSetsList().get(pcTestSets.getPcTestSetsList().size() - 1);
                        int testSetID = pcTestSet.getTestSetID();
                        this.logger.println(String.format("%s - %s (testID: %s, TestSetID: %s)", DateFormatter.getDateTime(), Messages.CreatingNewTestInstance(), testID, testSetID));
                        testInstanceID = this.restProxy.createTestInstance(testID, testSetID);
                        this.logger.println(String.format("%s - %s: %s", DateFormatter.getDateTime(), Messages.TestInstanceCreatedSuccessfully(), testInstanceID));
                    } else {
                        String msg = Messages.NoTestSetAvailable();
                        this.logger.println(String.format("%s - %s", DateFormatter.getDateTime(), msg));
                        throw new PcException(msg);
                    }
                }
                return testInstanceID;
            }
            catch (Exception e) {
                this.logger.println(String.format("%s - getCorrectTestInstanceID %s. %s: %s", DateFormatter.getDateTime(), Messages.Failure(), Messages.Error(), e.getMessage()));
                return Integer.parseInt(null);
            }
        }
        return Integer.parseInt(this.model.getTestInstanceId(true));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setCorrectTrendReportID() throws IOException, PcException {
        String msg = Messages.NoTrendReportAssociated() + "\n" + Messages.PleaseTurnAutomaticTrendOn() + "\n" + Messages.PleaseTurnAutomaticTrendOnAlternative();
        if (!"ASSOCIATED".equals(this.model.getAddRunToTrendReport()) || this.model.getPostRunAction() == PostRunAction.DO_NOTHING) return;
        PcTest pcTest = this.restProxy.getTestData(Integer.parseInt(this.model.getTestId(true)));
        if (!this.model.getTrendReportId().startsWith("$")) {
            if (pcTest.getTrendReportId() <= -1) throw new PcException(msg);
            this.model.setTrendReportId(String.valueOf(pcTest.getTrendReportId()));
            return;
        }
        try {
            if (Integer.parseInt(this.model.getTrendReportId(true)) <= -1) {
                throw new PcException(msg);
            }
            this.model.setTrendReportId(String.valueOf(this.model.getTrendReportId(true)));
            return;
        }
        catch (Exception ex) {
            throw new PcException(msg + System.getProperty("line.separator") + String.valueOf(ex));
        }
    }

    public String getTestName() throws IOException, PcException {
        try {
            PcTest pcTest = this.restProxy.getTestData(Integer.parseInt(this.model.getTestId(true)));
            return pcTest.getTestName();
        }
        catch (PcException | IOException ex) {
            this.logger.println(String.format("%s - getTestData %s (testId : %s)", DateFormatter.getDateTime(), Messages.Failure(), this.model.getTestId(true)));
            throw ex;
        }
    }

    public PcRunResponse waitForRunCompletion(int runId) throws InterruptedException, ClientProtocolException, PcException, IOException {
        return this.waitForRunCompletion(runId, 5000);
    }

    public PcRunResponse waitForRunCompletion(int runId, int interval) throws InterruptedException, ClientProtocolException, PcException, IOException {
        RunState state = RunState.UNDEFINED;
        switch (this.model.getPostRunAction()) {
            case DO_NOTHING: {
                state = RunState.BEFORE_COLLATING_RESULTS;
                break;
            }
            case COLLATE: {
                state = RunState.BEFORE_CREATING_ANALYSIS_DATA;
                break;
            }
            case COLLATE_AND_ANALYZE: {
                state = RunState.FINISHED;
            }
        }
        return this.waitForRunState(runId, state, interval);
    }

    private PcRunResponse waitForRunState(int runId, RunState completionState, int interval) throws InterruptedException, ClientProtocolException, PcException, IOException {
        int counter = 0;
        RunState[] states = new RunState[]{RunState.BEFORE_COLLATING_RESULTS, RunState.BEFORE_CREATING_ANALYSIS_DATA};
        PcRunResponse response = null;
        RunState lastState = RunState.UNDEFINED;
        int threeStrikes = 3;
        do {
            try {
                if (threeStrikes < 3) {
                    this.logger.println(String.format("%s - Cannot get response from the server about the state of the Run (ID=%s) %s time(s) consecutively", DateFormatter.getDateTime(), runId, 3 - threeStrikes));
                    if (threeStrikes == 0) {
                        this.logger.println(String.format("%s - %s: %s", DateFormatter.getDateTime(), Messages.StoppingMonitoringOnRun(), runId));
                        break;
                    }
                    Thread.sleep(2000L);
                    this.login();
                }
                response = this.restProxy.getRunData(runId);
                RunState currentState = RunState.get((String)response.getRunState());
                if (lastState.ordinal() < currentState.ordinal()) {
                    lastState = currentState;
                    this.logger.println(String.format("%s - RunID: %s - State = %s", DateFormatter.getDateTime(), runId, currentState.value()));
                }
                if (Arrays.asList(states).contains(currentState)) {
                    Thread.sleep(1000L);
                    if (++counter > 60) {
                        this.logger.println(String.format("%s - Run ID: %s  - %s = %s", DateFormatter.getDateTime(), runId, Messages.StoppedFromPC(), currentState.value()));
                        break;
                    }
                } else {
                    counter = 0;
                    Thread.sleep(interval);
                }
                threeStrikes = 3;
            }
            catch (InterruptedException e) {
                throw e;
            }
            catch (PcException e) {
                --threeStrikes;
            }
        } while (lastState.ordinal() < completionState.ordinal());
        return response;
    }

    public FilePath publishRunReport(int runId, String reportDirectory) throws IOException, PcException, InterruptedException {
        PcRunResults runResultsList = this.restProxy.getRunResults(runId);
        if (runResultsList.getResultsList() != null) {
            for (PcRunResult result : runResultsList.getResultsList()) {
                if (!result.getName().equals("Reports.zip")) continue;
                File dir = new File(reportDirectory);
                dir.mkdirs();
                String reportArchiveFullPath = dir.getCanonicalPath() + IOUtils.DIR_SEPARATOR + "Reports.zip";
                this.logger.println(String.format("%s - %s", DateFormatter.getDateTime(), Messages.PublishingAnalysisReport()));
                this.restProxy.GetRunResultData(runId, result.getID(), reportArchiveFullPath);
                FilePath fp = new FilePath(new File(reportArchiveFullPath));
                fp.unzip(fp.getParent());
                fp.delete();
                FilePath reportFile = fp.sibling("Report.html");
                if (!reportFile.exists()) continue;
                return reportFile;
            }
        }
        this.logger.println(String.format("%s - %s", DateFormatter.getDateTime(), Messages.FailedToGetRunReport()));
        return null;
    }

    public boolean logout() {
        if (!this.loggedIn) {
            return true;
        }
        boolean logoutSucceeded = false;
        try {
            logoutSucceeded = this.restProxy.logout();
            this.loggedIn = !logoutSucceeded;
        }
        catch (PcException e) {
            this.logger.println(String.format("%s - %s", DateFormatter.getDateTime(), e.getMessage()));
        }
        catch (Exception e) {
            this.logger.println(e);
        }
        this.logger.println(String.format("%s - %s", DateFormatter.getDateTime(), logoutSucceeded ? Messages.LogoutSucceeded() : Messages.LogoutFailed()));
        return logoutSucceeded;
    }

    public boolean stopRun(int runId) {
        boolean stopRunSucceeded = false;
        try {
            this.logger.println(String.format("%s - %s", DateFormatter.getDateTime(), Messages.StoppingRun()));
            stopRunSucceeded = this.restProxy.stopRun(runId, "stop");
        }
        catch (PcException e) {
            this.logger.println(String.format("%s - %s", DateFormatter.getDateTime(), e.getMessage()));
        }
        catch (Exception e) {
            this.logger.println(String.format("%s - %s", DateFormatter.getDateTime(), e));
        }
        this.logger.println(String.format("%s - %s", DateFormatter.getDateTime(), stopRunSucceeded ? Messages.StopRunSucceeded() : Messages.StopRunFailed()));
        return stopRunSucceeded;
    }

    public PcRunEventLog getRunEventLog(int runId) {
        try {
            return this.restProxy.getRunEventLog(runId);
        }
        catch (PcException e) {
            this.logger.println(String.format("%s - %s", DateFormatter.getDateTime(), e.getMessage()));
        }
        catch (Exception e) {
            this.logger.println(String.format("%s - %s", DateFormatter.getDateTime(), e.getMessage()));
        }
        return null;
    }

    public void addRunToTrendReport(int runId, String trendReportId) {
        TrendReportRequest trRequest = new TrendReportRequest(this.model.getAlmProject(true), runId, null);
        this.logger.println(String.format("%s - Adding run: %s to trend report: %s", DateFormatter.getDateTime(), runId, trendReportId));
        try {
            this.restProxy.updateTrendReport(trendReportId, trRequest);
            this.logger.println(String.format("%s - %s: %s %s: %s", DateFormatter.getDateTime(), Messages.PublishingRun(), runId, Messages.OnTrendReport(), trendReportId));
        }
        catch (PcException e) {
            this.logger.println(String.format("%s - %s: %s", DateFormatter.getDateTime(), Messages.FailedToAddRunToTrendReport(), e.getMessage()));
        }
        catch (IOException e) {
            this.logger.println(String.format("%s - %s: %s.", DateFormatter.getDateTime(), Messages.FailedToAddRunToTrendReport(), Messages.ProblemConnectingToPCServer()));
        }
    }

    public void waitForRunToPublishOnTrendReport(int runId, String trendReportId) throws PcException, IOException, InterruptedException {
        ArrayList trendReportMetaDataResultsList;
        boolean publishEnded = false;
        int counterPublishStarted = 0;
        int counterPublishNotStarted = 0;
        boolean resultNotFound = true;
        while (!(trendReportMetaDataResultsList = this.restProxy.getTrendReportMetaData(trendReportId)).isEmpty()) {
            for (PcTrendedRun result : trendReportMetaDataResultsList) {
                resultNotFound = result.getRunID() != runId;
                if (resultNotFound) continue;
                if (result.getState().equals("Trended") || result.getState().equals("Error")) {
                    publishEnded = true;
                    this.logger.println(String.format("%s - Run: %s %s: %s", DateFormatter.getDateTime(), runId, Messages.PublishingStatus(), result.getState()));
                    break;
                }
                Thread.sleep(5000L);
                if (++counterPublishStarted < 360) continue;
                String msg = String.format("%s: %s", Messages.Error(), Messages.PublishingEndTimeout());
                throw new PcException(msg);
            }
            if (!publishEnded && resultNotFound) {
                Thread.sleep(5000L);
                if (++counterPublishNotStarted >= 180) {
                    String msg = String.format("%s", Messages.PublishingStartTimeout());
                    throw new PcException(msg);
                }
                if (counterPublishNotStarted % 12 == 0) {
                    this.logger.println(String.format("%s - %s. %s: %s ... ", DateFormatter.getDateTime(), Messages.WaitingForTrendReportToStart(), Messages.MinutesUntilTimeout(), 10 - counterPublishNotStarted / 12));
                }
            }
            if (!publishEnded && counterPublishStarted < 120 && counterPublishNotStarted < 120) continue;
        }
    }

    public boolean downloadTrendReportAsPdf(String trendReportId, String directory) throws PcException {
        try {
            this.logger.println(String.format("%s - %s: %s %s", DateFormatter.getDateTime(), Messages.DownloadingTrendReport(), trendReportId, Messages.InPDFFormat()));
            InputStream in = this.restProxy.getTrendingPDF(trendReportId);
            File dir = new File(directory);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            String filePath = directory + IOUtils.DIR_SEPARATOR + "trendReport" + trendReportId + ".pdf";
            Path destination = Paths.get(filePath, new String[0]);
            Files.copy(in, destination, StandardCopyOption.REPLACE_EXISTING);
            this.logger.println(String.format("%s - %s: %s %s", DateFormatter.getDateTime(), Messages.TrendReport(), trendReportId, Messages.SuccessfullyDownloaded()));
        }
        catch (Exception e) {
            this.logger.println(String.format("%s - %s: %s", DateFormatter.getDateTime(), Messages.FailedToDownloadTrendReport(), e.getMessage()));
            throw new PcException(e.getMessage());
        }
        return true;
    }

    public void publishTrendReport(String filePath, String trendReportId) {
        if (filePath == null) {
            return;
        }
        this.logger.println(String.format("%s - %s", DateFormatter.getDateTime(), HyperlinkNote.encodeTo((String)filePath, (String)(Messages.ViewTrendReport() + " " + trendReportId))));
    }

    public Map<String, String> getTrendReportByXML(String trendReportId, int runId, TrendReportTypes.DataType dataType, TrendReportTypes.PctType pctType, TrendReportTypes.Measurement measurement) throws IOException, PcException, IntrospectionException, NoSuchMethodException {
        LinkedHashMap<String, String> measurmentsMap = new LinkedHashMap<String, String>();
        measurmentsMap.put("RunId", "_" + runId + "_");
        measurmentsMap.put("Trend Measurement Type", measurement.toString() + "_" + pctType.toString());
        TrendReportTransactionDataRoot res = this.restProxy.getTrendReportByXML(trendReportId, runId);
        List RowsListObj = res.getTrendReportRoot();
        for (int i = 0; i < RowsListObj.size(); ++i) {
            try {
                Method rowListMethod = RowsListObj.get(i).getClass().getMethod("getTrendReport" + dataType.toString() + "DataRowList", new Class[0]);
                for (Object DataRowObj : (ArrayList)rowListMethod.invoke(RowsListObj.get(i), new Object[0])) {
                    if (!DataRowObj.getClass().getMethod("getPCT_TYPE", new Class[0]).invoke(DataRowObj, new Object[0]).equals(pctType.toString())) continue;
                    Method method = DataRowObj.getClass().getMethod("get" + measurement.toString(), new Class[0]);
                    measurmentsMap.put(DataRowObj.getClass().getMethod("getPCT_NAME", new Class[0]).invoke(DataRowObj, new Object[0]).toString(), method.invoke(DataRowObj, new Object[0]) == null ? "" : method.invoke(DataRowObj, new Object[0]).toString());
                }
                continue;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return measurmentsMap;
    }
}

