/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.octane.vulnerabilities;

import com.hp.octane.integrations.OctaneSDK;
import com.microfocus.application.automation.tools.octane.configuration.FodConfigUtil;
import com.microfocus.application.automation.tools.octane.configuration.SDKBasedLoggerProvider;
import com.microfocus.application.automation.tools.octane.configuration.SSCServerConfigUtil;
import com.microfocus.application.automation.tools.octane.tests.build.BuildHandlerUtils;
import com.microfocus.application.automation.tools.octane.vulnerabilities.VulnerabilitiesUtils;
import hudson.Extension;
import hudson.model.Run;
import java.lang.reflect.InvocationTargetException;
import org.apache.logging.log4j.Logger;
import org.jenkinsci.plugins.workflow.flow.GraphListener;
import org.jenkinsci.plugins.workflow.graph.FlowEndNode;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;

@Extension
public class VulnerabilitiesWorkflowListener
implements GraphListener {
    private static final Logger logger = SDKBasedLoggerProvider.getLogger(VulnerabilitiesWorkflowListener.class);

    public void onNewHead(FlowNode flowNode) {
        if (!OctaneSDK.hasClients()) {
            return;
        }
        try {
            if (BuildHandlerUtils.isWorkflowEndNode(flowNode)) {
                this.sendPipelineFinishedEvent((FlowEndNode)flowNode);
            }
        }
        catch (Exception e) {
            logger.error("failed to build and/or dispatch STARTED/FINISHED event for " + String.valueOf(flowNode), (Throwable)e);
        }
    }

    protected void sendPipelineFinishedEvent(FlowEndNode flowEndNode) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        WorkflowRun parentRun = BuildHandlerUtils.extractParentRun((FlowNode)flowEndNode);
        if (!OctaneSDK.hasClients()) {
            return;
        }
        SSCServerConfigUtil.SSCProjectVersionPair projectVersionPair = SSCServerConfigUtil.getProjectConfigurationFromWorkflowRun(parentRun);
        if (!VulnerabilitiesUtils.insertQueueItem((Run)parentRun, projectVersionPair)) {
            return;
        }
        Long release = FodConfigUtil.getFODReleaseFromRun(parentRun);
        if (release != null) {
            logger.info("FOD configuration was found in " + String.valueOf(parentRun));
            VulnerabilitiesUtils.insertFODQueueItem((Run)parentRun, release);
        }
        if (projectVersionPair == null && release == null) {
            logger.debug("No Security Scan integration configuration was found " + String.valueOf(parentRun));
        }
    }
}

