/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.octane.vulnerabilities;

import com.hp.octane.integrations.OctaneClient;
import com.hp.octane.integrations.OctaneSDK;
import com.hp.octane.integrations.services.configurationparameters.FortifySSCFetchTimeoutParameter;
import com.hp.octane.integrations.services.vulnerabilities.ToolType;
import com.microfocus.application.automation.tools.octane.configuration.SDKBasedLoggerProvider;
import com.microfocus.application.automation.tools.octane.configuration.SSCServerConfigUtil;
import com.microfocus.application.automation.tools.octane.tests.build.BuildHandlerUtils;
import hudson.model.ParametersAction;
import hudson.model.Run;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.Logger;

public class VulnerabilitiesUtils {
    private static Logger logger = SDKBasedLoggerProvider.getLogger(VulnerabilitiesUtils.class);

    private VulnerabilitiesUtils() {
    }

    public static void insertFODQueueItem(Run run, Long releaseId) {
        HashMap<String, String> additionalProperties = new HashMap<String, String>();
        additionalProperties.put("releaseId", releaseId.toString());
        VulnerabilitiesUtils.insertQueueItem(run, ToolType.FOD, additionalProperties);
    }

    public static boolean insertQueueItem(Run run, SSCServerConfigUtil.SSCProjectVersionPair projectVersionPair) {
        if (projectVersionPair != null) {
            logger.warn("SSC configuration was found in " + String.valueOf(run));
            String sscServerUrl = SSCServerConfigUtil.getSSCServer();
            if (sscServerUrl == null || sscServerUrl.isEmpty()) {
                logger.debug("SSC configuration not found in the whole CI Server");
                return false;
            }
            VulnerabilitiesUtils.insertQueueItem(run, ToolType.SSC, null);
        }
        return true;
    }

    private static void insertQueueItem(Run run, ToolType toolType, Map<String, String> props) {
        String jobCiId = BuildHandlerUtils.getJobCiId(run);
        String buildCiId = BuildHandlerUtils.getBuildCiId(run);
        Long queueItemTimeoutHours = VulnerabilitiesUtils.getQueueItemTimeoutHoursFromJob(run);
        String parents = BuildHandlerUtils.getRootJobCiIds(run);
        OctaneSDK.getClients().forEach(octaneClient -> octaneClient.getVulnerabilitiesService().enqueueRetrieveAndPushVulnerabilities(jobCiId, buildCiId, toolType, run.getStartTimeInMillis(), queueItemTimeoutHours == null ? (long)VulnerabilitiesUtils.getFortifyTimeoutHours(octaneClient.getInstanceId()) : queueItemTimeoutHours, props, parents));
    }

    public static int getFortifyTimeoutHours(String instanceId) {
        OctaneClient octaneClient = OctaneSDK.getClientByInstanceId((String)instanceId);
        FortifySSCFetchTimeoutParameter parameter = (FortifySSCFetchTimeoutParameter)octaneClient.getConfigurationService().getConfiguration().getParameter("FORTIFY_SSC_FETCH_TIMEOUT");
        if (parameter != null) {
            return parameter.getTimeout();
        }
        return 12;
    }

    private static Long getQueueItemTimeoutHoursFromJob(Run run) {
        Long queueItemTimeoutHours = null;
        String paramName = "fortify-maximum-analysis-timeout-hours";
        try {
            ParametersAction parameters = (ParametersAction)run.getAction(ParametersAction.class);
            if (parameters != null && parameters.getParameter(paramName) != null) {
                queueItemTimeoutHours = Long.parseLong((String)parameters.getParameter(paramName).getValue());
            }
        }
        catch (Exception e) {
            logger.warn("Failed to parse  " + paramName + " : " + e.getMessage());
            queueItemTimeoutHours = null;
        }
        return queueItemTimeoutHours;
    }
}

