/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.octane.vulnerabilities;

import com.hp.octane.integrations.OctaneSDK;
import com.microfocus.application.automation.tools.octane.configuration.FodConfigUtil;
import com.microfocus.application.automation.tools.octane.configuration.SDKBasedLoggerProvider;
import com.microfocus.application.automation.tools.octane.configuration.SSCServerConfigUtil;
import com.microfocus.application.automation.tools.octane.vulnerabilities.VulnerabilitiesUtils;
import hudson.Extension;
import hudson.model.AbstractBuild;
import hudson.model.Run;
import hudson.model.listeners.RunListener;
import org.apache.logging.log4j.Logger;

@Extension
public class VulnerabilitiesListener
extends RunListener<AbstractBuild> {
    private static Logger logger = SDKBasedLoggerProvider.getLogger(VulnerabilitiesListener.class);

    public void onFinalized(AbstractBuild build) {
        if (!OctaneSDK.hasClients()) {
            return;
        }
        SSCServerConfigUtil.SSCProjectVersionPair projectVersionPair = SSCServerConfigUtil.getProjectConfigurationFromBuild(build);
        if (!VulnerabilitiesUtils.insertQueueItem((Run)build, projectVersionPair)) {
            return;
        }
        Long release = FodConfigUtil.getFODReleaseFromBuild(build);
        if (release != null) {
            logger.info("FOD configuration was found in " + String.valueOf(build));
            VulnerabilitiesUtils.insertFODQueueItem((Run)build, release);
        }
        if (projectVersionPair == null && release == null) {
            logger.debug("No Security Scan integration configuration was found " + String.valueOf(build));
        }
    }
}

