/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.octane.tests.junit;

import com.microfocus.application.automation.tools.octane.tests.junit.AbstractMavenModuleDetection;
import hudson.FilePath;
import hudson.model.AbstractBuild;
import hudson.model.FreeStyleProject;
import hudson.model.Project;
import hudson.model.Run;
import hudson.tasks.Builder;
import hudson.tasks.Maven;
import java.io.File;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;

public class MavenBuilderModuleDetection
extends AbstractMavenModuleDetection {
    public MavenBuilderModuleDetection(Run build) {
        super(build);
    }

    @Override
    protected void addPomDirectories(Run build) {
        if (build instanceof AbstractBuild) {
            if (((AbstractBuild)build).getProject() instanceof FreeStyleProject || "hudson.matrix.MatrixConfiguration".equals(((AbstractBuild)build).getProject().getClass().getName())) {
                boolean unknownBuilder = false;
                for (Builder builder : ((Project)((AbstractBuild)build).getProject()).getBuilders()) {
                    if (builder instanceof Maven) {
                        Maven maven = (Maven)builder;
                        if (maven.pom != null) {
                            if (maven.pom.endsWith("/pom.xml") || maven.pom.endsWith("\\pom.xml")) {
                                this.addPomDirectory(new FilePath(this.rootDir, maven.pom.substring(0, maven.pom.length() - 8)));
                                continue;
                            }
                            int p = maven.pom.lastIndexOf(File.separatorChar);
                            if (p > 0) {
                                this.addPomDirectory(new FilePath(this.rootDir, maven.pom.substring(0, p)));
                                continue;
                            }
                        }
                        this.addPomDirectory(this.rootDir);
                        continue;
                    }
                    unknownBuilder = true;
                }
                if (unknownBuilder && this.rootDir != null && !this.pomDirs.contains(this.rootDir)) {
                    this.addPomDirectory(this.rootDir);
                }
            }
        } else if ("org.jenkinsci.plugins.workflow.job.WorkflowRun".equals(WorkflowRun.class.getName()) && this.rootDir != null) {
            this.addPomDirectory(this.rootDir);
        }
    }
}

