/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.octane.tests.junit;

import com.microfocus.application.automation.tools.octane.tests.build.BuildHandlerUtils;
import com.microfocus.application.automation.tools.octane.tests.junit.ModuleDetection;
import hudson.FilePath;
import hudson.model.Run;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;

public abstract class AbstractMavenModuleDetection
implements ModuleDetection {
    protected FilePath rootDir;
    protected List<FilePath> pomDirs;

    public AbstractMavenModuleDetection(Run build) {
        this.rootDir = BuildHandlerUtils.getWorkspace(build);
        this.pomDirs = new LinkedList<FilePath>();
        this.addPomDirectories(build);
    }

    protected abstract void addPomDirectories(Run var1);

    @Override
    public String getModule(FilePath resultFile) throws IOException, InterruptedException {
        for (FilePath pomDir : this.pomDirs) {
            if (!this.childOf(pomDir, resultFile)) continue;
            return this.normalize(this.locatePom(resultFile, pomDir));
        }
        return null;
    }

    protected void addPomDirectory(FilePath pomDir) {
        this.pomDirs.add(pomDir);
    }

    protected boolean childOf(FilePath parent, FilePath child) {
        while (child != null) {
            if (parent.equals((Object)child)) {
                return true;
            }
            child = child.getParent();
        }
        return false;
    }

    private String locatePom(FilePath filePath, FilePath pomDir) throws IOException, InterruptedException {
        FilePath parentPath;
        while (filePath != null && !(parentPath = filePath.getParent()).equals((Object)pomDir)) {
            FilePath pomPath = new FilePath(parentPath, "pom.xml");
            if (pomPath.exists()) {
                return parentPath.getRemote().substring(this.rootDir.getRemote().length());
            }
            filePath = parentPath;
        }
        return pomDir.getRemote().substring(this.rootDir.getRemote().length());
    }

    private String normalize(String path) {
        return path.replace("\\", "/").replaceFirst("^/", "");
    }
}

