/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.octane.tests.gherkin;

import com.hp.octane.integrations.testresults.GherkinUtils;
import com.microfocus.application.automation.tools.octane.actions.cucumber.CucumberResultsService;
import com.microfocus.application.automation.tools.octane.actions.cucumber.CucumberTestResultsAction;
import com.microfocus.application.automation.tools.octane.configuration.SDKBasedLoggerProvider;
import com.microfocus.application.automation.tools.octane.tests.OctaneTestsExtension;
import com.microfocus.application.automation.tools.octane.tests.TestProcessingException;
import com.microfocus.application.automation.tools.octane.tests.TestResultContainer;
import hudson.Extension;
import hudson.model.Run;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.logging.log4j.Logger;

@Extension
public class GherkinTestExtension
extends OctaneTestsExtension {
    private static Logger logger = SDKBasedLoggerProvider.getLogger(GherkinTestExtension.class);

    @Override
    public boolean supports(Run<?, ?> build) {
        if (build.getAction(CucumberTestResultsAction.class) != null) {
            logger.debug("CucumberTestResultsAction found, gherkin results expected");
            return true;
        }
        logger.debug("CucumberTestResultsAction not found, no gherkin results expected");
        return false;
    }

    @Override
    public TestResultContainer getTestResults(Run<?, ?> build, String jenkinsRootUrl) throws TestProcessingException, IOException, InterruptedException {
        try {
            List gherkinFiles = GherkinUtils.findGherkinFilesByTemplateWithCounter((String)build.getRootDir().getAbsolutePath(), (String)"OctaneGherkinResults%s.xml", (int)0);
            List testResults = GherkinUtils.parseFiles((Collection)gherkinFiles);
            return new TestResultContainer(testResults.iterator(), null);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TestProcessingException("Error while processing gherkin test results", e);
        }
    }

    private List<File> findGherkinFiles(File buildDir) {
        ArrayList<File> result = new ArrayList<File>();
        int i = 0;
        File gherkinTestResultsFile = new File(buildDir, CucumberResultsService.getGherkinResultFileName(i));
        while (gherkinTestResultsFile.exists()) {
            result.add(gherkinTestResultsFile);
            gherkinTestResultsFile = new File(buildDir, CucumberResultsService.getGherkinResultFileName(++i));
        }
        return result;
    }
}

