/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.octane.testrunner;

import com.hp.octane.integrations.dto.executor.impl.TestingToolType;
import com.hp.octane.integrations.dto.general.MbtUnitParameter;
import com.hp.octane.integrations.executor.TestToRunData;
import com.hp.octane.integrations.executor.TestsToRunConverter;
import com.hp.octane.integrations.executor.TestsToRunConverterResult;
import com.hp.octane.integrations.executor.TestsToRunConvertersFactory;
import com.hp.octane.integrations.executor.TestsToRunFramework;
import com.hp.octane.integrations.executor.converters.MbtCodelessTest;
import com.hp.octane.integrations.executor.converters.MbtCodelessUnit;
import com.hp.octane.integrations.executor.converters.MbtTest;
import com.hp.octane.integrations.executor.converters.MbtUftTest;
import com.hp.octane.integrations.utils.SdkStringUtils;
import com.microfocus.application.automation.tools.AlmToolsUtils;
import com.microfocus.application.automation.tools.model.TestsFramework;
import com.microfocus.application.automation.tools.octane.configuration.ConfigurationValidator;
import com.microfocus.application.automation.tools.octane.testrunner.TestsToRunConverterModel;
import com.microfocus.application.automation.tools.octane.testrunner.VariableInjectionAction;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.StringParameterValue;
import hudson.model.TaskListener;
import hudson.remoting.VirtualChannel;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import jenkins.tasks.SimpleBuildStep;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.jenkinsci.remoting.RoleChecker;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class TestsToRunConverterBuilder
extends Builder
implements SimpleBuildStep {
    private static final String DEFAULT_EXECUTING_DIRECTORY = "${workspace}";
    private static final String CHECKOUT_DIRECTORY_PARAMETER = "testsToRunCheckoutDirectory";
    private static final String CODELESS_SCRIPT_FILE = ".cl";
    private static final String TEST_FILE_EXT = ".json";
    private static final String MBT_JSON_FILE = "mbt.json";
    public static final String TESTS_TO_RUN_PARAMETER = "testsToRun";
    private TestsToRunConverterModel framework;

    public TestsToRunConverterBuilder(String framework) {
        this.framework = new TestsToRunConverterModel(framework, "");
    }

    @DataBoundConstructor
    public TestsToRunConverterBuilder(String framework, String format) {
        this.framework = new TestsToRunConverterModel(framework, format);
    }

    private static void printToConsole(TaskListener listener, String msg) {
        listener.getLogger().println(TestsToRunConverterBuilder.class.getSimpleName() + " : " + msg);
    }

    public void perform(@Nonnull Run<?, ?> build, @Nonnull FilePath filePath, @Nonnull Launcher launcher, @Nonnull TaskListener listener) throws InterruptedException, IOException {
        try {
            TestsToRunConverterResult convertResult;
            ParametersAction parameterAction = (ParametersAction)build.getAction(ParametersAction.class);
            String rawTests = null;
            String executingDirectory = DEFAULT_EXECUTING_DIRECTORY;
            if (parameterAction != null) {
                ParameterValue checkoutDirParameter;
                ParameterValue testsParameter;
                ParameterValue executionIdParameter;
                ParameterValue suiteRunIdParameter;
                ParameterValue suiteIdParameter = parameterAction.getParameter("suiteId");
                if (suiteIdParameter != null) {
                    TestsToRunConverterBuilder.printToConsole(listener, "suiteId : " + String.valueOf(suiteIdParameter.getValue()));
                }
                if ((suiteRunIdParameter = parameterAction.getParameter("suiteRunId")) != null) {
                    TestsToRunConverterBuilder.printToConsole(listener, "suiteRunId : " + String.valueOf(suiteRunIdParameter.getValue()));
                }
                if ((executionIdParameter = parameterAction.getParameter("executionId")) != null) {
                    TestsToRunConverterBuilder.printToConsole(listener, "executionId : " + String.valueOf(executionIdParameter.getValue()));
                }
                if ((testsParameter = parameterAction.getParameter(TESTS_TO_RUN_PARAMETER)) != null && testsParameter.getValue() instanceof String) {
                    rawTests = (String)testsParameter.getValue();
                    TestsToRunConverterBuilder.printToConsole(listener, "testsToRun found with value : " + rawTests);
                }
                if ((checkoutDirParameter = parameterAction.getParameter(CHECKOUT_DIRECTORY_PARAMETER)) != null) {
                    if (testsParameter.getValue() instanceof String && StringUtils.isNotEmpty((String)((String)checkoutDirParameter.getValue()))) {
                        executingDirectory = (String)checkoutDirParameter.getValue();
                        TestsToRunConverterBuilder.printToConsole(listener, "testsToRunCheckoutDirectory parameter found with value : " + executingDirectory);
                    } else {
                        TestsToRunConverterBuilder.printToConsole(listener, "testsToRunCheckoutDirectory parameter found, but its value is empty or its type is not String. Using default value.");
                    }
                }
                TestsToRunConverterBuilder.printToConsole(listener, "checkout directory : " + executingDirectory);
            }
            if (StringUtils.isEmpty(rawTests)) {
                TestsToRunConverterBuilder.printToConsole(listener, "testsToRun is not found or has empty value. Skipping.");
                return;
            }
            if (this.framework == null || SdkStringUtils.isEmpty((String)this.getFramework())) {
                TestsToRunConverterBuilder.printToConsole(listener, "No frameworkModel is selected. Skipping.");
                return;
            }
            String frameworkName = this.getFramework();
            String frameworkFormat = this.getFormat();
            TestsToRunConverterBuilder.printToConsole(listener, "Selected framework = " + frameworkName);
            if (SdkStringUtils.isNotEmpty((String)frameworkFormat)) {
                TestsToRunConverterBuilder.printToConsole(listener, "Using format = " + frameworkFormat);
            }
            TestsToRunFramework testsToRunFramework = TestsToRunFramework.fromValue((String)frameworkName);
            boolean isMbt = rawTests.contains("mbtData");
            Map<String, String> globalParameters = this.getGlobalParameters(parameterAction);
            List testsData = TestsToRunConverter.parse((String)rawTests);
            TestsToRunConvertersFactory.createConverter((TestsToRunFramework)testsToRunFramework).enrichTestsData(testsData, globalParameters);
            if (isMbt) {
                try {
                    EnvVars env = build.getEnvironment(listener);
                    executingDirectory = env.expand(executingDirectory);
                }
                catch (IOException | InterruptedException e) {
                    listener.error("Failed loading build environment " + String.valueOf(e));
                }
                convertResult = (TestsToRunConverterResult)filePath.act((FilePath.FileCallable)new GetConvertResult(testsToRunFramework, frameworkFormat, testsData, executingDirectory, globalParameters));
            } else {
                convertResult = new GetConvertResult(testsToRunFramework, frameworkFormat, testsData, executingDirectory, globalParameters).invoke(null, null);
            }
            if (convertResult.getMbtTests() != null) {
                this.processTests(build, filePath, launcher, listener, convertResult);
            }
            TestsToRunConverterBuilder.printToConsole(listener, "Found #tests : " + convertResult.getTestsData().size());
            TestsToRunConverterBuilder.printToConsole(listener, "Set to parameter : " + convertResult.getTestsToRunConvertedParameterName() + " = " + convertResult.getConvertedTestsString());
            TestsToRunConverterBuilder.printToConsole(listener, "********************* Conversion is done *********************");
            if ("org.jenkinsci.plugins.workflow.job.WorkflowRun".equals(build.getClass().getName())) {
                ArrayList<StringParameterValue> newParams = parameterAction != null ? new ArrayList<StringParameterValue>(parameterAction.getAllParameters()) : new ArrayList();
                newParams.add(new StringParameterValue(convertResult.getTestsToRunConvertedParameterName(), convertResult.getConvertedTestsString()));
                ParametersAction newParametersAction = new ParametersAction(newParams);
                build.addOrReplaceAction((Action)newParametersAction);
            } else {
                VariableInjectionAction via = new VariableInjectionAction(convertResult.getTestsToRunConvertedParameterName(), convertResult.getConvertedTestsString());
                build.addAction((Action)via);
            }
        }
        catch (IllegalArgumentException e) {
            TestsToRunConverterBuilder.printToConsole(listener, "Failed to convert : " + e.getMessage());
            build.setResult(Result.FAILURE);
            return;
        }
    }

    private void processTests(Run<?, ?> build, FilePath filePath, Launcher launcher, TaskListener listener, TestsToRunConverterResult convertResult) throws IOException, InterruptedException {
        Map<TestingToolType, List<MbtTest>> mbtTestsByType = convertResult.getMbtTests().stream().collect(Collectors.groupingBy(MbtTest::getType));
        if (CollectionUtils.isNotEmpty((Collection)mbtTestsByType.get(TestingToolType.UFT))) {
            this.prepareUftTests(mbtTestsByType.get(TestingToolType.UFT), build, filePath, launcher, listener);
        }
        if (CollectionUtils.isNotEmpty((Collection)mbtTestsByType.get(TestingToolType.CODELESS))) {
            this.prepareCodelessTests(mbtTestsByType.get(TestingToolType.CODELESS), build, filePath);
        }
    }

    private Map<String, String> getGlobalParameters(ParametersAction parameterAction) {
        HashMap<String, String> map = new HashMap<String, String>();
        HashSet<String> predefinedParams = new HashSet<String>(Arrays.asList("ADD_GLOBAL_PARAMETERS_TO_TESTS", "suiteId", "suiteRunId", "octaneSpaceId", "octaneWorkspaceId", "octaneConfigId", "octaneUrl", "octaneRunByUsername"));
        parameterAction.getAllParameters().stream().filter(p -> predefinedParams.contains(p.getName()) || p.getName().toLowerCase(Locale.ROOT).contains("octane")).forEach(param -> this.addParameterIfExist(map, parameterAction, param.getName()));
        return map;
    }

    private void addParameterIfExist(Map<String, String> map, ParametersAction parameterAction, String paramName) {
        ParameterValue param = parameterAction.getParameter(paramName);
        if (param != null) {
            map.put(param.getName(), param.getValue().toString());
        }
    }

    private void prepareUftTests(List<MbtUftTest> tests, @Nonnull Run<?, ?> build, @Nonnull FilePath workspace, @Nonnull Launcher launcher, @Nonnull TaskListener listener) throws IOException, InterruptedException {
        String strProps;
        build.getRootDir();
        Properties props = new Properties();
        props.setProperty("runType", "MBT");
        props.setProperty("resultsFilename", "must be here");
        EnvVars env = build.getEnvironment(listener);
        props.setProperty("parentFolder", workspace.getRemote() + "\\___mbt");
        props.setProperty("repoFolder", workspace.getRemote());
        ParametersAction parameterAction = (ParametersAction)build.getAction(ParametersAction.class);
        ParameterValue checkoutDirParameter = parameterAction.getParameter(CHECKOUT_DIRECTORY_PARAMETER);
        if (checkoutDirParameter != null) {
            props.setProperty("parentFolder", env.expand((String)checkoutDirParameter.getValue()) + "\\___mbt");
            props.setProperty("repoFolder", env.expand((String)checkoutDirParameter.getValue()));
        }
        int counter = 1;
        for (MbtUftTest mbtUftTest : tests) {
            props.setProperty("test" + counter, mbtUftTest.getName());
            props.setProperty("package" + counter, "_" + counter);
            props.setProperty("script" + counter, env.expand(mbtUftTest.getScript()));
            props.setProperty("unitIds" + counter, mbtUftTest.getUnitIds().stream().map(n -> n.toString()).collect(Collectors.joining(";")));
            props.setProperty("underlyingTests" + counter, env.expand(String.join((CharSequence)";", mbtUftTest.getUnderlyingTests())));
            if (mbtUftTest.getEncodedIterations() != null && !mbtUftTest.getEncodedIterations().isEmpty()) {
                props.setProperty("datableParams" + counter, mbtUftTest.getEncodedIterations());
            }
            ++counter;
        }
        Date now = new Date();
        SimpleDateFormat formatter = new SimpleDateFormat("ddMMyyyyHHmmssSSS");
        String time = formatter.format((Object)now);
        try {
            strProps = AlmToolsUtils.getPropsAsString(props);
        }
        catch (IOException e) {
            build.setResult(Result.FAILURE);
            listener.error("Failed to store properties on agent machine: " + String.valueOf(e));
            return;
        }
        String propsFileName = String.format("mbt_props%s.txt", time);
        FilePath fileProps = workspace.child(propsFileName);
        URL cmdExeUrl = Jenkins.get().pluginManager.uberClassLoader.getResource("HpToolsLauncher.exe");
        if (cmdExeUrl == null) {
            listener.fatalError("HpToolsLauncher.exe not found in resources");
            return;
        }
        FilePath cmdLineExe = workspace.child("HpToolsLauncher.exe");
        try {
            if (!AlmToolsUtils.tryCreatePropsFile(listener, strProps, fileProps)) {
                build.setResult(Result.FAILURE);
                return;
            }
            TestsToRunConverterBuilder.printToConsole(listener, "MBT props file saved to " + fileProps.getRemote());
            if (!cmdLineExe.exists()) {
                cmdLineExe.copyFrom(cmdExeUrl);
                TestsToRunConverterBuilder.printToConsole(listener, "HPToolLauncher copied to " + cmdLineExe.getRemote());
            }
        }
        catch (IOException | InterruptedException e) {
            build.setResult(Result.FAILURE);
            listener.error("Copying executable files to executing node " + String.valueOf(e));
        }
        try {
            AlmToolsUtils.runOnBuildEnv(build, launcher, listener, cmdLineExe, propsFileName, null);
        }
        catch (IOException ioe) {
            Util.displayIOException((IOException)ioe, (TaskListener)listener);
            build.setResult(Result.FAILURE);
            listener.error("Failed running HpToolsLauncher " + String.valueOf(ioe));
            return;
        }
    }

    private void prepareCodelessTests(List<MbtCodelessTest> tests, Run<?, ?> build, FilePath workspace) throws IOException, InterruptedException {
        FilePath parentFolder = workspace.child(String.format("codeless_%s", build.getNumber()));
        parentFolder.mkdirs();
        this.writeUnitScriptFiles(tests, parentFolder);
        this.writeMbtJsonFile(tests, parentFolder);
    }

    private void writeUnitScriptFiles(List<MbtCodelessTest> tests, FilePath parentFolder) throws IOException, InterruptedException {
        for (MbtCodelessTest test : tests) {
            for (MbtCodelessUnit unit : test.getUnits()) {
                String fileName = unit.getUnitId() + CODELESS_SCRIPT_FILE;
                FilePath unitFile = parentFolder.child(fileName);
                unitFile.write(unit.getScript(), String.valueOf(StandardCharsets.UTF_8));
                unit.setPath(unitFile.getRemote());
            }
        }
    }

    private void writeMbtJsonFile(List<MbtCodelessTest> tests, FilePath parentFolder) throws IOException, InterruptedException {
        JSONArray mbtJsonArr = new JSONArray();
        int counter = 1;
        for (MbtCodelessTest test : tests) {
            JSONObject codelessTestJson = new JSONObject();
            JSONObject testJsonObj = new JSONObject();
            testJsonObj.put("reportPath", (Object)parentFolder.getRemote());
            codelessTestJson.put("test", (Object)testJsonObj);
            JSONArray unitsJsonArr = this.generateUnitsJson(test.getUnits());
            codelessTestJson.put("units", (Object)unitsJsonArr);
            JSONObject dataJsonObj = this.generateDataJson(test);
            codelessTestJson.put("data", (Object)dataJsonObj);
            String fileName = counter + "_" + test.getName() + TEST_FILE_EXT;
            FilePath testFile = parentFolder.child(fileName);
            testFile.write(codelessTestJson.toString(), String.valueOf(StandardCharsets.UTF_8));
            JSONObject mbtTestJsonObj = new JSONObject();
            mbtTestJsonObj.put("counter", (Object)counter);
            mbtTestJsonObj.put("testName", (Object)test.getName());
            mbtTestJsonObj.put("path", (Object)testFile.getRemote());
            mbtJsonArr.add((Object)mbtTestJsonObj);
            ++counter;
        }
        FilePath mbtJsonFile = parentFolder.child(MBT_JSON_FILE);
        mbtJsonFile.write(mbtJsonArr.toString(), String.valueOf(StandardCharsets.UTF_8));
    }

    private JSONArray generateUnitsJson(List<MbtCodelessUnit> codelessUnits) {
        JSONArray unitsJsonArr = new JSONArray();
        codelessUnits.forEach(codelessUnit -> {
            JSONObject unitJsonObj = new JSONObject();
            unitJsonObj.put("unitId", (Object)codelessUnit.getUnitId());
            unitJsonObj.put("name", (Object)codelessUnit.getName());
            unitJsonObj.put("order", (Object)codelessUnit.getOrder());
            unitJsonObj.put("path", (Object)codelessUnit.getPath());
            JSONArray parametersJsonArr = new JSONArray();
            if (!CollectionUtils.isEmpty((Collection)codelessUnit.getParameters())) {
                codelessUnit.getParameters().forEach(parameter -> {
                    JSONObject parameterJsonObj = new JSONObject();
                    parameterJsonObj.put("id", (Object)parameter.getUnitParameterId());
                    parameterJsonObj.put("name", (Object)parameter.getUnitParameterName());
                    parameterJsonObj.put("type", (Object)parameter.getType());
                    parametersJsonArr.add((Object)parameterJsonObj);
                });
            }
            unitJsonObj.put("parameters", (Object)parametersJsonArr);
            unitsJsonArr.add((Object)unitJsonObj);
        });
        return unitsJsonArr;
    }

    private JSONObject generateDataJson(MbtCodelessTest test) {
        List<MbtCodelessUnit> sortedUnits = test.getUnits().stream().sorted(Comparator.comparing(MbtCodelessUnit::getOrder)).collect(Collectors.toList());
        ArrayList sortedInputParameters = new ArrayList();
        sortedUnits.forEach(unit -> {
            List sortedList = unit.getParameters().stream().filter(parameter -> parameter.getType().equalsIgnoreCase("input")).sorted(Comparator.comparing(MbtUnitParameter::getOrder)).collect(Collectors.toList());
            sortedInputParameters.addAll(sortedList);
        });
        HashMap<String, MbtUnitParameter> outputParamNameToParameterMap = new HashMap<String, MbtUnitParameter>();
        sortedUnits.forEach(unit -> unit.getParameters().stream().filter(parameter -> parameter.getType().equalsIgnoreCase("output")).forEach(parameter -> outputParamNameToParameterMap.put(parameter.getName(), (MbtUnitParameter)parameter)));
        HashMap<String, MbtCodelessUnit> paramNameToUnitMap = new HashMap<String, MbtCodelessUnit>();
        sortedUnits.forEach(unit -> unit.getParameters().forEach(parameter -> paramNameToUnitMap.put(this.createParameterKey((MbtUnitParameter)parameter), (MbtCodelessUnit)unit)));
        List iterationParams = test.getMbtDataTable().getParameters();
        List iterations = test.getMbtDataTable().getIterations();
        JSONObject dataJsonObj = new JSONObject();
        JSONArray iterationsJsonArr = new JSONArray();
        for (List currentIteration : iterations) {
            JSONArray iterationJsonArr = new JSONArray();
            for (MbtUnitParameter currentParameter : sortedInputParameters) {
                JSONObject parameterJsonObj = this.generateParameterDataJson(currentParameter, currentIteration, iterationParams, paramNameToUnitMap, outputParamNameToParameterMap);
                iterationJsonArr.add((Object)parameterJsonObj);
            }
            iterationsJsonArr.add((Object)iterationJsonArr);
        }
        dataJsonObj.put("iterations", (Object)iterationsJsonArr);
        return dataJsonObj;
    }

    private String createParameterKey(MbtUnitParameter parameter) {
        return parameter.getParameterId() + "_" + parameter.getName();
    }

    private JSONObject generateParameterDataJson(MbtUnitParameter currentParameter, List<String> currentIteration, List<String> iterationParams, Map<String, MbtCodelessUnit> paramNameToUnitMap, Map<String, MbtUnitParameter> outputParamNameToParameterMap) {
        MbtCodelessUnit currentUnit = paramNameToUnitMap.get(this.createParameterKey(currentParameter));
        boolean isLinkedToOutput = StringUtils.isNotEmpty((String)currentParameter.getOutputParameter());
        JSONObject parameterJsonObj = new JSONObject();
        parameterJsonObj.put("unitOrder", (Object)currentUnit.getOrder());
        parameterJsonObj.put("paramName", (Object)currentParameter.getUnitParameterName());
        JSONObject valueJsonObj = new JSONObject();
        if (isLinkedToOutput) {
            MbtUnitParameter outputParameter = outputParamNameToParameterMap.get(currentParameter.getOutputParameter());
            MbtCodelessUnit linkedParamUnit = paramNameToUnitMap.get(this.createParameterKey(outputParameter));
            valueJsonObj.put("type", (Object)"parameter");
            valueJsonObj.put("name", (Object)(linkedParamUnit.getOrder() + ":" + outputParameter.getUnitParameterName()));
        } else {
            valueJsonObj.put("type", (Object)"literal");
            String value = currentIteration.get(iterationParams.indexOf(currentParameter.getName()));
            valueJsonObj.put("value", (Object)(value != null ? value : ""));
        }
        parameterJsonObj.put("value", (Object)valueJsonObj);
        return parameterJsonObj;
    }

    public TestsToRunConverterModel getTestsToRunConverterModel() {
        return this.framework;
    }

    public String getFramework() {
        return this.framework.getFramework().getName();
    }

    public String getFormat() {
        return this.framework.getFramework().getFormat();
    }

    public boolean getIsCustom() {
        return this.framework != null && TestsToRunFramework.Custom.value().equals(this.framework.getFramework().getName());
    }

    private static class GetConvertResult
    implements FilePath.FileCallable<TestsToRunConverterResult> {
        private TestsToRunFramework framework;
        private List<TestToRunData> testData;
        private String executingDirectory;
        private String format;
        private Map<String, String> globalParameters;

        public GetConvertResult(TestsToRunFramework framework, String format, List<TestToRunData> testData, String executingDirectory, Map<String, String> globalParameters) {
            this.framework = framework;
            this.testData = testData;
            this.format = format;
            this.executingDirectory = executingDirectory;
            this.globalParameters = globalParameters;
        }

        public TestsToRunConverterResult invoke(File file, VirtualChannel virtualChannel) throws IOException, InterruptedException {
            return TestsToRunConvertersFactory.createConverter((TestsToRunFramework)this.framework).setFormat(this.format).convert(this.testData, this.executingDirectory, this.globalParameters);
        }

        public void checkRoles(RoleChecker roleChecker) throws SecurityException {
        }
    }

    @Symbol(value={"convertTestsToRun"})
    @Extension
    public static class Descriptor
    extends BuildStepDescriptor<Builder> {
        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public String getDisplayName() {
            return "OpenText Software Delivery Management testing framework converter";
        }

        public FormValidation doTestConvert(@QueryParameter(value="testsToRun") String rawTests, @QueryParameter(value="teststorunconverter.framework") String framework, @QueryParameter(value="teststorunconverter.format") String format) {
            try {
                if (StringUtils.isEmpty((String)rawTests)) {
                    throw new IllegalArgumentException("'Tests to run' parameter is missing");
                }
                if (StringUtils.isEmpty((String)framework)) {
                    throw new IllegalArgumentException("'Framework' parameter is missing");
                }
                TestsToRunFramework testsToRunFramework = TestsToRunFramework.fromValue((String)framework);
                if (TestsToRunFramework.Custom.equals((Object)testsToRunFramework) && StringUtils.isEmpty((String)format)) {
                    throw new IllegalArgumentException("'Format' parameter is missing");
                }
                TestsToRunConverterResult convertResult = TestsToRunConvertersFactory.createConverter((TestsToRunFramework)testsToRunFramework).setFormat(format).convert(rawTests, TestsToRunConverterBuilder.DEFAULT_EXECUTING_DIRECTORY, null);
                String result = Util.escape((String)convertResult.getConvertedTestsString());
                return ConfigurationValidator.wrapWithFormValidation(true, "Conversion is successful : <div style=\"margin-top:20px\">" + result + "</div>");
            }
            catch (Exception e) {
                return ConfigurationValidator.wrapWithFormValidation(false, "Failed to convert : " + e.getMessage());
            }
        }

        public List<TestsFramework> getFrameworks() {
            return TestsToRunConverterModel.Frameworks;
        }
    }
}

