/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.octane.octaneExecution;

import com.hp.octane.integrations.OctaneClient;
import com.hp.octane.integrations.OctaneSDK;
import com.hp.octane.integrations.dto.DTOFactory;
import com.hp.octane.integrations.dto.parameters.CIParameter;
import com.hp.octane.integrations.dto.parameters.CIParameterType;
import com.hp.octane.integrations.dto.parameters.CIParameters;
import com.hp.octane.integrations.exceptions.ConfigurationException;
import com.hp.octane.integrations.exceptions.PermissionException;
import com.hp.octane.integrations.octaneExecution.ExecutionMode;
import com.hp.octane.integrations.services.SupportsConsoleLog;
import com.hp.octane.integrations.services.testexecution.TestExecutionContext;
import com.hp.octane.integrations.services.testexecution.TestExecutionService;
import com.microfocus.application.automation.tools.octane.CIJenkinsServicesImpl;
import com.microfocus.application.automation.tools.octane.ImpersonationUtil;
import com.microfocus.application.automation.tools.octane.JellyUtils;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Cause;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.queue.QueueTaskFuture;
import hudson.security.ACLContext;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import jenkins.tasks.SimpleBuildStep;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class ExecuteTestsInOctaneBuilder
extends Builder
implements SimpleBuildStep {
    private String configurationId;
    private String executionMode;
    private String ids;
    private String workspaceId;

    @DataBoundConstructor
    public ExecuteTestsInOctaneBuilder(String configurationId, String workspaceId, String executionMode, String ids) {
        this.configurationId = "none".equalsIgnoreCase(configurationId) ? null : configurationId;
        this.workspaceId = "none".equalsIgnoreCase(workspaceId) ? null : workspaceId;
        this.executionMode = executionMode;
        this.ids = ids;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void perform(@Nonnull Run<?, ?> build, @Nonnull FilePath filePath, @Nonnull Launcher launcher, @Nonnull TaskListener listener) throws InterruptedException, IOException {
        Long myWorkspaceIdAsLong;
        SupportsConsoleLogImpl supportsConsoleLog = new SupportsConsoleLogImpl(listener);
        supportsConsoleLog.println("Start **********************************************************************************************");
        supportsConsoleLog.println("");
        if (this.configurationId == null) {
            throw new IllegalArgumentException("Software Delivery Management configuration is not defined.");
        }
        if (this.workspaceId == null) {
            throw new IllegalArgumentException("Software Delivery Management workspace is not defined.");
        }
        String myConfigurationId = this.configurationId;
        String myWorkspaceId = this.workspaceId;
        String myExecutionMode = this.executionMode;
        String myIds = this.ids;
        try {
            EnvVars env = build.getEnvironment(listener);
            myConfigurationId = env.expand(this.configurationId);
            myWorkspaceId = env.expand(this.workspaceId);
            myExecutionMode = env.expand(this.executionMode);
            myIds = env.expand(this.ids);
        }
        catch (IOException | InterruptedException e) {
            listener.error("Failed loading build environment " + String.valueOf(e));
        }
        try {
            myWorkspaceIdAsLong = Long.parseLong(myWorkspaceId);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to convert workspace to long :  " + myWorkspaceId);
        }
        OctaneClient octaneClient = OctaneSDK.getClientByInstanceId((String)myConfigurationId);
        TestExecutionService testExecutionService = octaneClient.getTestExecutionService();
        List suiteIds = Arrays.stream(myIds.split(",")).map(str -> str.trim()).filter(str -> StringUtils.isNotEmpty((String)str) && StringUtils.isNumeric((String)str)).map(str -> Long.parseLong(str.trim())).distinct().collect(Collectors.toList());
        try {
            testExecutionService.validateAllSuiteIdsExistAndReturnSuiteNames(myWorkspaceIdAsLong, suiteIds);
        }
        catch (IllegalArgumentException e) {
            listener.error(e.getMessage());
            build.setResult(Result.FAILURE);
            return;
        }
        ParametersAction parameterAction = (ParametersAction)build.getAction(ParametersAction.class);
        switch (ExecutionMode.fromValue((String)myExecutionMode)) {
            case SUITE_RUNS_IN_OCTANE: {
                Long optionalReleaseId = this.getLongValueParameter(parameterAction, "octane_release_id");
                String optionalSuiteRunName = this.getStringValueParameter(parameterAction, "octane_new_suite_run_name");
                testExecutionService.executeSuiteRuns(myWorkspaceIdAsLong, suiteIds, optionalReleaseId, optionalSuiteRunName, (SupportsConsoleLog)supportsConsoleLog);
                break;
            }
            case SUITE_IN_CI: {
                List testExecutions = testExecutionService.prepareTestExecutionForSuites(myWorkspaceIdAsLong, suiteIds, (SupportsConsoleLog)supportsConsoleLog);
                ACLContext securityContext = ImpersonationUtil.startImpersonation(myConfigurationId, null);
                HashMap futures = new HashMap();
                try {
                    testExecutions.forEach(testExecution -> {
                        AbstractProject project = this.getJobFromTestRunner((TestExecutionContext)testExecution);
                        try {
                            supportsConsoleLog.print(String.format("%s %s, triggering test runner '%s' (%s tests): ", testExecution.getIdentifierType().getName(), testExecution.getIdentifier(), testExecution.getTestRunner().getName(), testExecution.getTests().size()));
                            listener.hyperlink("/job/" + project.getFullName().replace("/", "/job/"), project.getFullName());
                            supportsConsoleLog.newLine();
                        }
                        catch (IOException e) {
                            throw new RuntimeException("Failed to print link to triggered job : " + e.getMessage());
                        }
                        int delay = 0;
                        Cause.UpstreamCause cause = new Cause.UpstreamCause(build);
                        CIParameter testsToRunParam = ((CIParameter)DTOFactory.getInstance().newDTO(CIParameter.class)).setName("testsToRun").setValue((Object)testExecution.getTestsToRun()).setType(CIParameterType.STRING);
                        CIParameters ciParams = (CIParameters)DTOFactory.getInstance().newDTO(CIParameters.class);
                        ciParams.setParameters(Collections.singletonList(testsToRunParam));
                        ParametersAction parametersAction = new ParametersAction(CIJenkinsServicesImpl.createParameters((Job)project, ciParams));
                        QueueTaskFuture future = project.scheduleBuild2(delay, (Cause)cause, new Action[]{parametersAction});
                        futures.put(testExecution, future);
                    });
                }
                finally {
                    ImpersonationUtil.stopImpersonation(securityContext);
                }
                supportsConsoleLog.println("Waiting for test runners to finish ... ");
                Result buildResult = Result.SUCCESS;
                for (Map.Entry entry : futures.entrySet()) {
                    try {
                        AbstractBuild buildFromFuture = (AbstractBuild)((QueueTaskFuture)entry.getValue()).get();
                        try {
                            supportsConsoleLog.print("Build ");
                            String url = "/job/" + buildFromFuture.getProject().getFullName().replace("/", "/job/") + "/" + buildFromFuture.getNumber();
                            listener.hyperlink(url, buildFromFuture.getProject().getFullName() + " " + buildFromFuture.getDisplayName());
                            supportsConsoleLog.append(" - " + String.valueOf(buildFromFuture.getResult()));
                            supportsConsoleLog.newLine();
                        }
                        catch (IOException e) {
                            throw new RuntimeException("Failed to print link to triggered job : " + e.getMessage());
                        }
                        if (!buildFromFuture.getResult().isWorseThan(buildResult)) continue;
                        buildResult = buildFromFuture.getResult();
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Failed in waiting for job finishing : " + e.getMessage());
                    }
                }
                if (!buildResult.isWorseThan(Result.SUCCESS)) break;
                build.setResult(buildResult);
                break;
            }
            default: {
                throw new RuntimeException("not supported execution mode");
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private AbstractProject getJobFromTestRunner(TestExecutionContext testExecution) {
        String ciJobName = testExecution.getTestRunner().getEntityValue("ci_job").getName();
        Job job = (Job)Jenkins.get().getItemByFullName(ciJobName);
        if (job == null) throw new ConfigurationException("Job is not found " + ciJobName, 404);
        if (job instanceof AbstractProject && ((AbstractProject)job).isDisabled()) {
            throw new ConfigurationException("Job is disabled " + ciJobName, 404);
        }
        boolean hasBuildPermission = job.hasPermission(Item.BUILD);
        if (!hasBuildPermission) {
            throw new PermissionException("No permission to run job " + ciJobName, 403);
        }
        if (!(job instanceof AbstractProject) && !job.getClass().getName().equals("org.jenkinsci.plugins.workflow.job.WorkflowJob")) return (AbstractProject)job;
        return (AbstractProject)job;
    }

    private Long getLongValueParameter(ParametersAction parameterAction, String paramName) {
        if (parameterAction == null) {
            return null;
        }
        ParameterValue pv = parameterAction.getParameter(paramName);
        if (pv != null && pv.getValue() instanceof String) {
            try {
                return Long.valueOf((String)pv.getValue());
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    private String getStringValueParameter(ParametersAction parameterAction, String paramName) {
        if (parameterAction == null) {
            return null;
        }
        ParameterValue pv = parameterAction.getParameter(paramName);
        if (pv != null && pv.getValue() instanceof String) {
            return (String)pv.getValue();
        }
        return null;
    }

    public String getConfigurationId() {
        return this.configurationId;
    }

    public String getWorkspaceId() {
        return this.workspaceId;
    }

    public String getExecutionMode() {
        return this.executionMode;
    }

    public String getIds() {
        return this.ids;
    }

    public static class SupportsConsoleLogImpl
    implements SupportsConsoleLog {
        TaskListener listener;

        public SupportsConsoleLogImpl(TaskListener listener) {
            this.listener = listener;
        }

        public void println(String msg) {
            this.listener.getLogger().println(ExecuteTestsInOctaneBuilder.class.getSimpleName() + " : " + msg);
        }

        public void print(String msg) {
            this.listener.getLogger().print(ExecuteTestsInOctaneBuilder.class.getSimpleName() + " : " + msg);
        }

        public void append(String msg) {
            this.listener.getLogger().print(msg);
        }

        public void newLine() {
            this.listener.getLogger().println();
        }
    }

    @Symbol(value={"executeTestsFromAlmOctane"})
    @Extension
    public static class Descriptor
    extends BuildStepDescriptor<Builder> {
        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public String getDisplayName() {
            return "Execute OpenText functional tests from Software Delivery Management (Tech Preview)";
        }

        public ListBoxModel doFillExecutionModeItems() {
            ListBoxModel m = new ListBoxModel();
            for (ExecutionMode mode : ExecutionMode.values()) {
                m.add(mode.description(), mode.value());
            }
            return m;
        }

        public ListBoxModel doFillConfigurationIdItems() {
            return JellyUtils.fillConfigurationIdModel();
        }

        public ListBoxModel doFillWorkspaceIdItems(@QueryParameter String configurationId, @QueryParameter(value="workspaceId") String workspaceId) {
            return JellyUtils.fillWorkspaceModel(configurationId, workspaceId);
        }
    }
}

