/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.octane.model.processors.scm;

import com.hp.octane.integrations.dto.DTOFactory;
import com.hp.octane.integrations.dto.scm.SCMChange;
import com.hp.octane.integrations.dto.scm.SCMCommit;
import com.hp.octane.integrations.dto.scm.SCMData;
import com.hp.octane.integrations.dto.scm.SCMRepository;
import com.hp.octane.integrations.dto.scm.SCMType;
import com.microfocus.application.automation.tools.octane.configuration.SDKBasedLoggerProvider;
import com.microfocus.application.automation.tools.octane.model.processors.scm.CommonOriginRevision;
import com.microfocus.application.automation.tools.octane.model.processors.scm.SCMProcessor;
import hudson.model.AbstractBuild;
import hudson.model.Run;
import hudson.model.User;
import hudson.model.UserProperty;
import hudson.scm.ChangeLogSet;
import hudson.scm.SCM;
import hudson.scm.SVNRevisionState;
import hudson.scm.SubversionChangeLogSet;
import hudson.scm.SubversionSCM;
import hudson.tasks.Mailer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.logging.log4j.Logger;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;

class SvnSCMProcessor
implements SCMProcessor {
    private static final Logger logger = SDKBasedLoggerProvider.getLogger(SvnSCMProcessor.class);
    private static final DTOFactory dtoFactory = DTOFactory.getInstance();
    private static final int PARENT_COMMIT_INDEX = 1;

    SvnSCMProcessor() {
    }

    @Override
    public SCMData getSCMData(AbstractBuild build, SCM scm) {
        ArrayList<ChangeLogSet<? extends ChangeLogSet.Entry>> changes = new ArrayList<ChangeLogSet<? extends ChangeLogSet.Entry>>();
        changes.add(build.getChangeSet());
        return this.extractSCMData((Run)build, scm, changes);
    }

    @Override
    public SCMData getSCMData(WorkflowRun run, SCM scm) {
        return this.extractSCMData((Run)run, scm, run.getChangeSets());
    }

    @Override
    public CommonOriginRevision getCommonOriginRevision(Run run) {
        return null;
    }

    private SCMData extractSCMData(Run run, SCM scm, List<ChangeLogSet<? extends ChangeLogSet.Entry>> changes) {
        if (!(scm instanceof SubversionSCM)) {
            throw new IllegalArgumentException("SubversionSCM type of SCM was expected here, found '" + scm.getClass().getName() + "'");
        }
        SubversionSCM svnData = (SubversionSCM)scm;
        SCMRepository repository = SvnSCMProcessor.getSCMRepository(svnData);
        String builtRevId = this.getBuiltRevId(run, svnData, repository.getUrl());
        List<SCMCommit> tmpCommits = this.extractCommits(changes);
        return ((SCMData)dtoFactory.newDTO(SCMData.class)).setRepository(repository).setBuiltRevId(builtRevId).setCommits(tmpCommits);
    }

    private List<SCMCommit> extractCommits(List<ChangeLogSet<? extends ChangeLogSet.Entry>> changes) {
        LinkedList<SCMCommit> tmpCommits = new LinkedList<SCMCommit>();
        for (ChangeLogSet<? extends ChangeLogSet.Entry> set : changes) {
            for (ChangeLogSet.Entry change : set) {
                if (!(change instanceof SubversionChangeLogSet.LogEntry)) continue;
                SubversionChangeLogSet.LogEntry commit = (SubversionChangeLogSet.LogEntry)change;
                User user = commit.getAuthor();
                String userEmail = null;
                ArrayList<SCMChange> tmpChanges = new ArrayList<SCMChange>();
                for (SubversionChangeLogSet.Path item : commit.getAffectedFiles()) {
                    SCMChange tmpChange = ((SCMChange)dtoFactory.newDTO(SCMChange.class)).setType(item.getEditType().getName()).setFile(item.getValue());
                    tmpChanges.add(tmpChange);
                }
                for (UserProperty property : user.getAllProperties()) {
                    if (!(property instanceof Mailer.UserProperty)) continue;
                    userEmail = ((Mailer.UserProperty)property).getAddress();
                }
                String parentRevId = SvnSCMProcessor.getParentRevId(commit);
                SCMCommit tmpCommit = ((SCMCommit)dtoFactory.newDTO(SCMCommit.class)).setTime(Long.valueOf(commit.getTimestamp())).setUser(commit.getAuthor().getId()).setUserEmail(userEmail).setRevId(commit.getCommitId()).setParentRevId(parentRevId).setComment(commit.getMsg().trim()).setChanges(tmpChanges);
                tmpCommits.add(tmpCommit);
            }
        }
        return tmpCommits;
    }

    private String getBuiltRevId(Run run, SubversionSCM svnData, String svnRepositoryUrl) {
        String builtRevId = null;
        try {
            SVNRevisionState revisionState = (SVNRevisionState)svnData.calcRevisionsFromBuild(run, null, null, null);
            if (revisionState != null) {
                builtRevId = String.valueOf(revisionState.getRevision(svnRepositoryUrl));
            }
        }
        catch (IOException | InterruptedException e) {
            logger.error("failed to get revision state", (Throwable)e);
        }
        return builtRevId;
    }

    private static String getParentRevId(SubversionChangeLogSet.LogEntry commit) {
        String parentRevId = null;
        try {
            if (commit.getParent() != null && commit.getParent().getLogs() != null && commit.getParent().getLogs().size() > 1) {
                parentRevId = ((SubversionChangeLogSet.LogEntry)commit.getParent().getLogs().get(1)).getCommitId();
            } else {
                logger.info("parent rev ID is not available in the commit's logs");
            }
        }
        catch (Exception e) {
            logger.error("failed to retrieve parentRevId", (Throwable)e);
        }
        return parentRevId;
    }

    private static SCMRepository getSCMRepository(SubversionSCM svnData) {
        String url = null;
        if (svnData.getLocations().length > 0 && svnData.getLocations()[0] != null) {
            url = svnData.getLocations()[0].getURL();
        }
        return ((SCMRepository)dtoFactory.newDTO(SCMRepository.class)).setType(SCMType.SVN).setUrl(url);
    }
}

