/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.octane.model.processors.scm;

import com.hp.octane.integrations.dto.DTOFactory;
import com.hp.octane.integrations.dto.scm.SCMChange;
import com.hp.octane.integrations.dto.scm.SCMCommit;
import com.hp.octane.integrations.dto.scm.SCMData;
import com.hp.octane.integrations.dto.scm.SCMFileBlame;
import com.hp.octane.integrations.dto.scm.SCMRepository;
import com.hp.octane.integrations.dto.scm.SCMType;
import com.hp.octane.integrations.dto.scm.impl.LineRange;
import com.hp.octane.integrations.dto.scm.impl.RevisionsMap;
import com.hp.octane.integrations.dto.scm.impl.SCMFileBlameImpl;
import com.microfocus.application.automation.tools.octane.configuration.SDKBasedLoggerProvider;
import com.microfocus.application.automation.tools.octane.model.processors.scm.CommonOriginRevision;
import com.microfocus.application.automation.tools.octane.model.processors.scm.SCMProcessor;
import hudson.FilePath;
import hudson.model.AbstractBuild;
import hudson.model.Run;
import hudson.model.User;
import hudson.model.UserProperty;
import hudson.plugins.git.Branch;
import hudson.plugins.git.BranchSpec;
import hudson.plugins.git.GitChangeSet;
import hudson.plugins.git.GitSCM;
import hudson.plugins.git.extensions.impl.RelativeTargetDirectory;
import hudson.plugins.git.util.BuildData;
import hudson.remoting.VirtualChannel;
import hudson.scm.ChangeLogSet;
import hudson.scm.SCM;
import hudson.tasks.Mailer;
import hudson.util.DescribableList;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jenkins.MasterToSlaveFileCallable;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.reflect.FieldUtils;
import org.apache.logging.log4j.Logger;
import org.eclipse.jgit.api.BlameCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.blame.BlameResult;
import org.eclipse.jgit.diff.Edit;
import org.eclipse.jgit.diff.EditList;
import org.eclipse.jgit.diff.RawText;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;

class GitSCMProcessor
implements SCMProcessor {
    private static final Logger logger = SDKBasedLoggerProvider.getLogger(GitSCMProcessor.class);
    private static final DTOFactory dtoFactory = DTOFactory.getInstance();
    private static final String MASTER = "refs/remotes/origin/master";

    GitSCMProcessor() {
    }

    @Override
    public SCMData getSCMData(AbstractBuild build, SCM scm) {
        ArrayList<ChangeLogSet<? extends ChangeLogSet.Entry>> changes = new ArrayList<ChangeLogSet<? extends ChangeLogSet.Entry>>();
        changes.add(build.getChangeSet());
        SCMData scmData = this.extractSCMData((Run)build, scm, changes);
        scmData = this.enrichLinesOnSCMData(scmData, build);
        return scmData;
    }

    private SCMData enrichLinesOnSCMData(SCMData scmData, AbstractBuild build) {
        long startTime = System.currentTimeMillis();
        try {
            FilePath workspace = build.getWorkspace();
            if (workspace != null) {
                scmData = (SCMData)workspace.act((FilePath.FileCallable)new LineEnricherCallable(GitSCMProcessor.getCheckoutDir(build), scmData));
                logger.debug("Line enricher: process took: " + (System.currentTimeMillis() - startTime) / 1000L + " seconds");
            } else {
                logger.warn("Line enricher: workspace is null");
            }
        }
        catch (Exception e1) {
            logger.error("Line enricher: FAILED. could not enrich lines on SCM Data : " + e1.getMessage());
        }
        return scmData;
    }

    @Override
    public SCMData getSCMData(WorkflowRun run, SCM scm) {
        return this.extractSCMData((Run)run, scm, run.getChangeSets());
    }

    @Override
    public CommonOriginRevision getCommonOriginRevision(Run run) {
        CommonOriginRevision commonOriginRevision = new CommonOriginRevision();
        commonOriginRevision.branch = this.getBranchName(run);
        try {
            AbstractBuild abstractBuild = (AbstractBuild)run;
            FilePath workspace = ((AbstractBuild)run).getWorkspace();
            if (workspace != null) {
                commonOriginRevision.revision = (String)workspace.act((FilePath.FileCallable)new FileContentCallable(GitSCMProcessor.getCheckoutDir(abstractBuild)));
            }
            logger.debug("most recent common revision resolved to " + commonOriginRevision.revision + " (branch: " + commonOriginRevision.branch + ")");
        }
        catch (Exception e) {
            logger.error("failed to resolve most recent common revision : " + e.getClass().getName() + " - " + e.getMessage());
            return commonOriginRevision;
        }
        return commonOriginRevision;
    }

    private SCMData extractSCMData(Run run, SCM scm, List<ChangeLogSet<? extends ChangeLogSet.Entry>> changes) {
        if (!(scm instanceof GitSCM)) {
            throw new IllegalArgumentException("GitSCM type of SCM was expected here, found '" + scm.getClass().getName() + "'");
        }
        GitSCM gitData = (GitSCM)scm;
        String builtRevId = null;
        SCMRepository repository = this.getRepository(run, gitData);
        BuildData buildData = gitData.getBuildData(run);
        if (buildData != null && buildData.getLastBuiltRevision() != null) {
            builtRevId = buildData.getLastBuiltRevision().getSha1String();
        }
        List<SCMCommit> tmpCommits = this.extractCommits(changes);
        return ((SCMData)dtoFactory.newDTO(SCMData.class)).setRepository(repository).setBuiltRevId(builtRevId).setCommits(tmpCommits);
    }

    private String getBranchName(Run r) {
        try {
            SCM scm = ((AbstractBuild)r).getProject().getScm();
            GitSCM git = (GitSCM)scm;
            List branches = git.getBranches();
            String rawBranchName = ((BranchSpec)branches.get(0)).toString();
            if (rawBranchName != null && rawBranchName.startsWith("${") && rawBranchName.endsWith("}")) {
                String param = rawBranchName.substring(2, rawBranchName.length() - 1);
                if (((AbstractBuild)r).getBuildVariables().get(param) != null) {
                    return ((AbstractBuild)r).getBuildVariables().get(param).toString();
                }
                return param;
            }
            if (rawBranchName != null && rawBranchName.startsWith("*/")) {
                return rawBranchName.substring(2);
            }
            return rawBranchName;
        }
        catch (Exception e) {
            logger.error("failed to extract branch name", (Throwable)e);
            return null;
        }
    }

    private static String getCheckoutDir(AbstractBuild r) {
        RelativeTargetDirectory relativeTargetDirectory;
        DescribableList extensions = ((GitSCM)r.getProject().getScm()).getExtensions();
        if (extensions != null && (relativeTargetDirectory = (RelativeTargetDirectory)extensions.get(RelativeTargetDirectory.class)) != null && relativeTargetDirectory.getRelativeTargetDir() != null) {
            return relativeTargetDirectory.getRelativeTargetDir();
        }
        return "";
    }

    private SCMRepository getRepository(Run run, GitSCM gitData) {
        SCMRepository result = null;
        String url = null;
        String branch = null;
        if (gitData != null && gitData.getBuildData(run) != null) {
            BuildData buildData = gitData.getBuildData(run);
            if (buildData != null) {
                if (buildData.getRemoteUrls() != null && !buildData.getRemoteUrls().isEmpty()) {
                    url = (String)buildData.getRemoteUrls().toArray()[0];
                }
                if (buildData.getLastBuiltRevision() != null && !buildData.getLastBuiltRevision().getBranches().isEmpty()) {
                    branch = ((Branch)buildData.getLastBuiltRevision().getBranches().toArray()[0]).getName();
                }
                result = ((SCMRepository)dtoFactory.newDTO(SCMRepository.class)).setType(SCMType.GIT).setUrl(url).setBranch(branch);
            } else {
                logger.warn("failed to obtain BuildData; no SCM repository info will be available");
            }
        }
        return result;
    }

    private List<SCMCommit> extractCommits(List<ChangeLogSet<? extends ChangeLogSet.Entry>> changes) {
        LinkedList<SCMCommit> commits = new LinkedList<SCMCommit>();
        for (ChangeLogSet<? extends ChangeLogSet.Entry> set : changes) {
            for (ChangeLogSet.Entry change : set) {
                if (!(change instanceof GitChangeSet)) continue;
                GitChangeSet commit = (GitChangeSet)change;
                ArrayList<SCMChange> tmpChanges = new ArrayList<SCMChange>();
                for (GitChangeSet.Path item : commit.getAffectedFiles()) {
                    SCMChange tmpChange = ((SCMChange)dtoFactory.newDTO(SCMChange.class)).setType(item.getEditType().getName()).setFile(item.getPath());
                    tmpChanges.add(tmpChange);
                }
                SCMCommit tmpCommit = ((SCMCommit)dtoFactory.newDTO(SCMCommit.class)).setTime(Long.valueOf(commit.getTimestamp())).setRevId(commit.getCommitId()).setParentRevId(commit.getParentCommit()).setComment(commit.getComment().trim()).setChanges(tmpChanges);
                this.setUserInCommit(commit, tmpCommit);
                commits.add(tmpCommit);
            }
        }
        return commits;
    }

    private void setUserInCommit(GitChangeSet commit, SCMCommit dtoCommit) {
        User user = commit.getAuthor();
        String userName = user.getId();
        String userEmail = null;
        for (UserProperty property : user.getAllProperties()) {
            if (!(property instanceof Mailer.UserProperty)) continue;
            userEmail = ((Mailer.UserProperty)property).getAddress();
        }
        try {
            String authorEmail;
            if ("noreply".equals(userName) && StringUtils.isNotEmpty((String)(authorEmail = (String)FieldUtils.readField((Object)commit, (String)"authorEmail", (boolean)true))) && authorEmail.contains("@")) {
                userEmail = authorEmail;
                userName = authorEmail.substring(0, authorEmail.indexOf(64));
            }
        }
        catch (Exception e) {
            logger.info("Failed to extract authorEmail : " + e.getMessage());
        }
        dtoCommit.setUser(userName).setUserEmail(userEmail);
    }

    private static Set<String> getAddedOrEditedFiles(SCMData scmData) {
        HashSet<String> filesCommittedInPPR = new HashSet<String>();
        for (SCMCommit curCommit : scmData.getCommits()) {
            curCommit.getChanges().stream().filter(change -> !change.getType().equals("delete")).forEach(change -> filesCommittedInPPR.add(change.getFile()));
        }
        return filesCommittedInPPR;
    }

    private static List<SCMFileBlame> getBlameData(Repository repo, Set<String> files) {
        BlameCommand blamer = new BlameCommand(repo);
        ArrayList<SCMFileBlame> fileBlameList = new ArrayList<SCMFileBlame>();
        try {
            ObjectId commitID = repo.resolve("HEAD");
            for (String filePath : files) {
                blamer.setStartCommit((AnyObjectId)commitID);
                blamer.setFilePath(filePath);
                BlameResult blameResult = blamer.call();
                if (blameResult == null) continue;
                RawText rawText = blameResult.getResultContents();
                int fileSize = rawText.size();
                RevisionsMap revisionsMap = new RevisionsMap();
                if (fileSize > 0) {
                    String startRangeRevision = blameResult.getSourceCommit(0).getName();
                    int startRange = 1;
                    for (int i = 1; i < fileSize; ++i) {
                        String currentRevision = blameResult.getSourceCommit(i).getName();
                        if (currentRevision.equals(startRangeRevision)) continue;
                        LineRange range = new LineRange(startRange, i);
                        revisionsMap.addRangeToRevision(startRangeRevision, range);
                        startRange = i + 1;
                        startRangeRevision = currentRevision;
                    }
                }
                fileBlameList.add((SCMFileBlame)new SCMFileBlameImpl(filePath, revisionsMap));
            }
        }
        catch (IOException e) {
            logger.error("failed to resolve repo head", (Throwable)e);
        }
        catch (GitAPIException e) {
            logger.error("failed to get blame result from git", (Throwable)e);
        }
        return fileBlameList;
    }

    private static void handleModifyDiff(EditList fileEdits, SCMChange scmChange) {
        if (scmChange != null) {
            for (Edit edit : fileEdits) {
                switch (edit.getType()) {
                    case INSERT: {
                        scmChange.insertAddedLines(new LineRange(edit.getBeginB() + 1, edit.getEndB()));
                        break;
                    }
                    case DELETE: {
                        scmChange.insertDeletedLines(new LineRange(edit.getBeginA() + 1, edit.getEndA()));
                        break;
                    }
                    case REPLACE: {
                        scmChange.insertDeletedLines(new LineRange(edit.getBeginA() + 1, edit.getEndA()));
                        scmChange.insertAddedLines(new LineRange(edit.getBeginB() + 1, edit.getEndB()));
                        break;
                    }
                }
            }
        }
    }

    private static void handleDeleteLinesDiff(EditList fileEdits, SCMChange scmChange) {
        if (scmChange != null) {
            for (Edit edit : fileEdits) {
                scmChange.insertDeletedLines(new LineRange(edit.getBeginA() + 1, edit.getEndA()));
            }
        }
    }

    private static void handleAddLinesDiff(EditList fileEdits, SCMChange scmChange) {
        if (scmChange != null) {
            for (Edit edit : fileEdits) {
                scmChange.insertAddedLines(new LineRange(edit.getBeginB() + 1, edit.getEndB()));
            }
        }
    }

    private static final class LineEnricherCallable
    extends MasterToSlaveFileCallable<SCMData> {
        private final String checkoutDir;
        private final SCMData scmData;

        private LineEnricherCallable(String checkoutDir, SCMData scmData) {
            this.checkoutDir = checkoutDir;
            this.scmData = scmData;
        }

        /*
         * Exception decompiling
         */
        public SCMData invoke(File rootDir, VirtualChannel channel) throws IOException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 4[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private static /* synthetic */ void lambda$invoke$0(Map fileChanges, SCMChange change) {
            fileChanges.put(change.getFile(), change);
        }
    }

    private static final class FileContentCallable
    extends MasterToSlaveFileCallable<String> {
        private final String checkoutDir;

        private FileContentCallable(String checkoutDir) {
            this.checkoutDir = checkoutDir;
        }

        /*
         * Exception decompiling
         */
        public String invoke(File rootDir, VirtualChannel channel) throws IOException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }
}

