/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.octane.model.processors.scm;

import com.hp.octane.integrations.dto.DTOFactory;
import com.hp.octane.integrations.dto.scm.SCMChange;
import com.hp.octane.integrations.dto.scm.SCMCommit;
import com.hp.octane.integrations.dto.scm.SCMData;
import com.hp.octane.integrations.dto.scm.SCMRepository;
import com.hp.octane.integrations.dto.scm.SCMType;
import com.microfocus.application.automation.tools.octane.configuration.SDKBasedLoggerProvider;
import com.microfocus.application.automation.tools.octane.model.processors.scm.CommonOriginRevision;
import com.microfocus.application.automation.tools.octane.model.processors.scm.SCMProcessor;
import hudson.model.AbstractBuild;
import hudson.model.Run;
import hudson.model.User;
import hudson.model.UserProperty;
import hudson.scm.ChangeLogSet;
import hudson.scm.SCM;
import hudson.tasks.Mailer;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.Logger;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;

class GenericSCMProcessor
implements SCMProcessor {
    private static final Logger logger = SDKBasedLoggerProvider.getLogger(GenericSCMProcessor.class);
    private static final DTOFactory dtoFactory = DTOFactory.getInstance();

    GenericSCMProcessor() {
    }

    @Override
    public SCMData getSCMData(AbstractBuild build, SCM scm) {
        ArrayList<ChangeLogSet<? extends ChangeLogSet.Entry>> changes = new ArrayList<ChangeLogSet<? extends ChangeLogSet.Entry>>();
        changes.add(build.getChangeSet());
        return this.extractSCMData(scm, changes);
    }

    @Override
    public SCMData getSCMData(WorkflowRun run, SCM scm) {
        return this.extractSCMData(scm, run.getChangeSets());
    }

    @Override
    public CommonOriginRevision getCommonOriginRevision(Run run) {
        return null;
    }

    private SCMData extractSCMData(SCM scm, List<ChangeLogSet<? extends ChangeLogSet.Entry>> changes) {
        logger.info("building generic scm data for SCM of type " + scm.getType());
        SCMRepository repository = this.buildScmRepository();
        List<SCMCommit> tmpCommits = this.extractCommits(changes);
        return ((SCMData)dtoFactory.newDTO(SCMData.class)).setRepository(repository).setCommits(tmpCommits);
    }

    private List<SCMCommit> extractCommits(List<ChangeLogSet<? extends ChangeLogSet.Entry>> changes) {
        ArrayList<SCMCommit> tmpCommits = new ArrayList<SCMCommit>();
        for (ChangeLogSet<? extends ChangeLogSet.Entry> set : changes) {
            for (ChangeLogSet.Entry change : set) {
                User user = change.getAuthor();
                String userEmail = null;
                ArrayList<SCMChange> tmpChanges = new ArrayList<SCMChange>();
                for (ChangeLogSet.AffectedFile item : change.getAffectedFiles()) {
                    SCMChange tmpChange = ((SCMChange)dtoFactory.newDTO(SCMChange.class)).setType(item.getEditType().getName()).setFile(item.getPath());
                    tmpChanges.add(tmpChange);
                }
                for (UserProperty property : user.getAllProperties()) {
                    if (!(property instanceof Mailer.UserProperty)) continue;
                    userEmail = ((Mailer.UserProperty)property).getAddress();
                }
                SCMCommit tmpCommit = this.buildScmCommit(tmpChanges, change, userEmail);
                tmpCommits.add(tmpCommit);
            }
        }
        return tmpCommits;
    }

    private SCMCommit buildScmCommit(List<SCMChange> tmpChanges, ChangeLogSet.Entry commit, String userEmail) {
        return ((SCMCommit)dtoFactory.newDTO(SCMCommit.class)).setTime(Long.valueOf(commit.getTimestamp())).setUser(commit.getAuthor().getId()).setUserEmail(userEmail).setRevId(commit.getCommitId()).setComment(commit.getMsg().trim()).setChanges(tmpChanges);
    }

    private SCMRepository buildScmRepository() {
        return ((SCMRepository)dtoFactory.newDTO(SCMRepository.class)).setType(SCMType.UNKNOWN);
    }
}

