/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.octane.model.processors.projects;

import com.microfocus.application.automation.tools.octane.configuration.SDKBasedLoggerProvider;
import com.microfocus.application.automation.tools.octane.model.processors.projects.AbstractProjectProcessor;
import com.microfocus.application.automation.tools.octane.tests.build.BuildHandlerUtils;
import hudson.model.Action;
import hudson.model.Cause;
import hudson.model.CauseAction;
import hudson.model.Job;
import hudson.model.ParametersAction;
import hudson.model.Run;
import org.apache.logging.log4j.Logger;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;

public class WorkFlowJobProcessor
extends AbstractProjectProcessor<WorkflowJob> {
    private static final Logger logger = SDKBasedLoggerProvider.getLogger(WorkFlowJobProcessor.class);

    WorkFlowJobProcessor(Job job) {
        super((WorkflowJob)job);
    }

    @Override
    public void scheduleBuild(Cause cause, ParametersAction parametersAction) {
        int delay = ((WorkflowJob)this.job).getQuietPeriod();
        CauseAction causeAction = new CauseAction(cause);
        ((WorkflowJob)this.job).scheduleBuild2(delay, new Action[]{parametersAction, causeAction});
    }

    @Override
    public String getTranslatedJobName() {
        if ("org.jenkinsci.plugins.workflow.multibranch.WorkflowMultiBranchProject".equals(((WorkflowJob)this.job).getParent().getClass().getName())) {
            return BuildHandlerUtils.translateFolderJobName(((WorkflowJob)this.job).getFullName());
        }
        return super.getTranslatedJobName();
    }

    @Override
    protected void stopBuild(Run run) {
        WorkflowRun aBuild = (WorkflowRun)run;
        try {
            aBuild.doStop();
            logger.info("Build is stopped : " + ((WorkflowJob)aBuild.getParent()).getDisplayName() + aBuild.getDisplayName());
        }
        catch (Exception e) {
            logger.warn("Failed to stop build '" + aBuild.getDisplayName() + "' :" + e.getMessage(), (Throwable)e);
        }
    }
}

